package com.ejianc.poc.vo;

import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;

import java.util.Date;

/**
 * @author CJ
 * @Description:
 * @date 2021/4/20 17:43
 */
public class AuthChangeRecordVO extends BaseVO {

    /**
     * 记录类型：授权组织删除
     */
    public static final String RECORD_TYPE_ORG_DEL = "1";
    /**
     * 记录类型：授权人岗位变化
     */
    public static final String RECORD_TYPE_POST_CHANGE = "2";
    private static final long serialVersionUID = -1626767187195584912L;

    /**
     * 被授权人Id,多个空格分隔
     */
    private String userId;

    /**
     * 被授权岗位ID ，多个空格分隔
     */
    private String postId;

    /**
     * 原被授权对象岗位路径
     */
    private String originalPostNamePath;

    /**
     * 原被授权对象组织路径
     */
    private String originalOrgNamePath;

    /**
     * 原被授权组织Id
     */
    private String originalOrgId;

    /**
     * 原被授权对象岗位ID
     */
    private String originalPostId;

    /**
     * 当前授权组织Id
     */
    private String curOrgId;

    /**
     * 当前授权对象岗位Id
     */
    private String curPostId;

    /**
     * 当前授权组织路径
     */
    private String curOrgNamePath;

    /**
     * 当前授权人岗位路径
     */
    private String curPostNamePath;

    /**
     * 记录类型：1-授权组织删除，2-授权对象岗位变化
     */
    private String type;

    /**
     * 授权对象所属二级集团Id
     */
    private String providerId;

    /**
     * 被授权对象名称，多个空格分隔
     */
    private String targetName;

    /**
     * 记录所属组织Id
     */
    private String orgId;

    /**
     * 记录所属组织编码
     */
    private String orgCode;

    /**
     * 变动时间
     */
    @JsonFormat(
            shape = JsonFormat.Shape.STRING,
            pattern = "yyyy-MM-dd HH:mm:ss",
            timezone = "GMT+8"
    )
    private Date changeTime;

    public String getOrgId() {
        return orgId;
    }

    public void setOrgId(String orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getUserId() {
        return userId;
    }

    public void setUserId(String userId) {
        this.userId = userId;
    }

    public String getPostId() {
        return postId;
    }

    public void setPostId(String postId) {
        this.postId = postId;
    }

    public String getTargetName() {
        return targetName;
    }

    public void setTargetName(String targetName) {
        this.targetName = targetName;
    }

    public String getOriginalPostNamePath() {
        return originalPostNamePath;
    }

    public void setOriginalPostNamePath(String originalPostNamePath) {
        this.originalPostNamePath = originalPostNamePath;
    }

    public String getOriginalOrgNamePath() {
        return originalOrgNamePath;
    }

    public void setOriginalOrgNamePath(String originalOrgNamePath) {
        this.originalOrgNamePath = originalOrgNamePath;
    }

    public String getOriginalOrgId() {
        return originalOrgId;
    }

    public void setOriginalOrgId(String originalOrgId) {
        this.originalOrgId = originalOrgId;
    }

    public String getOriginalPostId() {
        return originalPostId;
    }

    public void setOriginalPostId(String originalPostId) {
        this.originalPostId = originalPostId;
    }

    public String getCurOrgId() {
        return curOrgId;
    }

    public void setCurOrgId(String curOrgId) {
        this.curOrgId = curOrgId;
    }

    public String getCurPostId() {
        return curPostId;
    }

    public void setCurPostId(String curPostId) {
        this.curPostId = curPostId;
    }

    public String getCurOrgNamePath() {
        return curOrgNamePath;
    }

    public void setCurOrgNamePath(String curOrgNamePath) {
        this.curOrgNamePath = curOrgNamePath;
    }

    public String getCurPostNamePath() {
        return curPostNamePath;
    }

    public void setCurPostNamePath(String curPostNamePath) {
        this.curPostNamePath = curPostNamePath;
    }

    public String getType() {
        return type;
    }

    public void setType(String type) {
        this.type = type;
    }

    public String getProviderId() {
        return providerId;
    }

    public void setProviderId(String providerId) {
        this.providerId = providerId;
    }

    public Date getChangeTime() {
        return changeTime;
    }

    public void setChangeTime(Date changeTime) {
        this.changeTime = changeTime;
    }
}
