/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.WorkAuthVO;
import java.io.Serializable;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"workAuth"})
public class WorkAuthController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private IWorkAuthService service;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<WorkAuthVO> saveOrUpdate(@RequestBody WorkAuthVO saveorUpdateVO) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)BeanMapper.map((Object)saveorUpdateVO, WorkAuthEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<WorkAuthVO> queryDetail(Long id) {
        WorkAuthEntity entity = (WorkAuthEntity)((Object)this.service.selectById(id));
        WorkAuthVO vo = (WorkAuthVO)BeanMapper.map((Object)((Object)entity), WorkAuthVO.class);
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)vo);
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<WorkAuthVO> vos) {
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<WorkAuthVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        List records = BeanMapper.mapList((Iterable)page.getRecords(), WorkAuthVO.class);
        if (ListUtil.isNotEmpty((List)records)) {
            records.forEach(auth -> {
                JSONArray array = null;
                if (auth.getTargetType() == 1) {
                    JSONObject position;
                    JSONObject user = this.ztjApisService.getUser(auth.getProviderId(), auth.getTargetId());
                    if (user != null) {
                        auth.setTargetName(user.getString("name"));
                    }
                    if ((position = this.ztjApisService.getUserMainPosition(auth.getProviderId(), auth.getTargetId())) != null) {
                        if (!Objects.equals(auth.getOrgId(), position.getString("id"))) {
                            auth.setOrgId(position.getString("id"));
                            this.service.saveOrUpdate(BeanMapper.map((Object)auth, WorkAuthEntity.class));
                        }
                        array = this.ztjApisService.getOrgPath(auth.getProviderId(), position.getString("id"));
                    }
                } else {
                    array = this.ztjApisService.getOrgPath(auth.getProviderId(), auth.getTargetId());
                }
                StringBuffer paths = new StringBuffer("");
                if (array != null) {
                    for (int i = array.size() - 1; i > -1; --i) {
                        JSONObject p = array.getJSONObject(i);
                        if (p.getBoolean("virtual").booleanValue()) continue;
                        paths.append(p.getString("name")).append(" ");
                    }
                }
                auth.setOrgName(paths.toString());
            });
        }
        pageData.setRecords(records);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

