package com.ejianc.poc.controller;

import java.io.Serializable;
import java.util.ArrayList;
import java.util.List;
import java.util.Objects;
import java.util.stream.Collectors;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.poc.bean.PositionChangeEntity;
import com.ejianc.poc.bean.WorkAuthSubEntity;
import com.ejianc.poc.bean.ZtjAppEntity;
import com.ejianc.poc.service.IPositionChangeService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.service.IZtjAppService;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.PositionChangeVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.vo.WorkAuthVO;

/**
 * 工作授权表
 * 
 * @author generator
 * 
 */
@Controller
@RequestMapping("workAuth")
public class WorkAuthController implements Serializable {
	private static final long serialVersionUID = 1L;

	private Logger logger = LoggerFactory.getLogger(this.getClass());

	@Autowired
	private ZtjApisService ztjApisService;

	@Autowired
	private IWorkAuthService service;

	@Autowired
	private IWorkAuthSubService subService;

	@Autowired
	private IZtjAppService appService;

	@Autowired
	private IPositionChangeService changeService;

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<WorkAuthVO> saveOrUpdate(@RequestBody WorkAuthVO saveorUpdateVO) {
		WorkAuthEntity entity = BeanMapper.map(saveorUpdateVO, WorkAuthEntity.class);
		service.saveOrUpdate(entity, false);
		WorkAuthVO vo = BeanMapper.map(entity, WorkAuthVO.class);
		return CommonResponse.success("保存或修改单据成功！", vo);
	}

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdateBatch", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdateBatch(@RequestBody List<JSONObject> vos) {
		if(ListUtil.isNotEmpty(vos)){
			QueryParam param = new QueryParam();
			List<WorkAuthEntity> authEntities = new ArrayList<>();
			for (JSONObject vo : vos) {
				JSONObject object = vo;
				String corpProviderId  = object.getString("corpProviderId");
				String corpPk  = object.getString("corpPk");
				String targetType  = object.getString("targetType");
				String providerId  = object.getString("providerId");
				String targetId  = object.getString("id");
				param.getParams().put("corpProviderId",new Parameter(QueryParam.EQ,corpProviderId));
				param.getParams().put("corpPk",new Parameter(QueryParam.EQ,corpPk));
				param.getParams().put("targetId",new Parameter(QueryParam.EQ,targetId));
				param.getParams().put("providerId",new Parameter(QueryParam.EQ,providerId));
				param.getParams().put("targetType",new Parameter(QueryParam.EQ,targetType));
				List<WorkAuthEntity> exist = service.queryList(param,false);
				if(ListUtil.isNotEmpty(exist)){
					return CommonResponse.error("授权对象【"+vo.getString("name")+"】已存在授权列表中，请不要重复授权。");
				}
				WorkAuthEntity entity = new WorkAuthEntity();
				entity.setCorpPk(corpPk);
				entity.setCorpProviderId(corpProviderId);
				JSONArray array = ztjApisService.getOrgPath(corpProviderId,corpPk);
				if(array.size()>0){
					StringBuffer paths = new StringBuffer("");
					if(array!=null){
						for (int i = array.size()-1; i >-1; i--) {
							JSONObject p = array.getJSONObject(i);
							if(p.get("virtual")==null || !p.getBoolean("virtual")){
								paths.append(p.getString("name")).append(" ");
							}
						}
					}
					entity.setCorpName(paths.toString());
				}
				if(!OrgVO.rootOrgCode.equals(corpProviderId)){
					JSONObject corp = ztjApisService.getOrgParent(corpProviderId,corpPk);
					entity.setCorpParentPk(corp.getString("id"));
					entity.setCorpParentProviderId(corp.getString("providerId"));
				}
				entity.setOrgId(object.getString("positionId"));
				entity.setProviderId(providerId);
				entity.setTargetType(Integer.valueOf(targetType));
				entity.setTargetId(targetId);
				authEntities.add(entity);
			}
			service.saveOrUpdateBatch(authEntities);
		}
		return CommonResponse.success("操作成功！");
	}

	/**
	 * @Description saveOrUpdate 新增或者修改
	 */
	@RequestMapping(value = "/saveOrUpdateSubBatch", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> saveOrUpdateSubBatch(@RequestBody List<JSONObject> vos) {
		if(ListUtil.isNotEmpty(vos)){
			for (JSONObject vo : vos) {
				if(vo.get("authSubId")==null && vo.getBoolean("auth")){
					WorkAuthSubEntity sub = new WorkAuthSubEntity();
					sub.setPid(vo.getLong("pid"));
					sub.setAuthId(vo.getLong("id"));
					sub.setAuthName(vo.getString("name"));
					subService.saveOrUpdate(sub,false);
				}else if(vo.get("authSubId")!=null && !vo.getBoolean("auth")){
					subService.removeById(vo.getLong("authSubId"),false);
				}
			}
		}
		return CommonResponse.success("操作成功！");
	}

	/**
	 * @Description queryDetail 查询详情
	 * @param id
	 */
	@RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<WorkAuthVO> queryDetail(Long id) {
		WorkAuthEntity entity = service.selectById(id);
		WorkAuthVO vo = BeanMapper.map(entity, WorkAuthVO.class);
		return CommonResponse.success("查询详情数据成功！", vo);
	}

	/**
	 * @Description delete 批量删除单据
	 * @Param [ids]
	 */
	@RequestMapping(value = "/delete", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<String> delete(@RequestBody List<WorkAuthVO> vos) {
		for (int i = 0; i < vos.size(); i++) {
			WorkAuthVO vo = vos.get(i);
			if(vo.getTargetId().equals(InvocationInfoProxy.getUserid()+"")){
				return CommonResponse.error("授权对象包含自己，无法删除！");
			}
		}
		QueryParam param = new QueryParam();
		param.getParams().put("pid",new Parameter(QueryParam.IN,vos.stream().map(WorkAuthVO::getId).collect(Collectors.toList())));
		List<WorkAuthSubEntity> subEntities = subService.queryList(param,false);
		service.removeByIds(vos.stream().map(WorkAuthVO::getId).collect(Collectors.toList()), true);
		if(ListUtil.isNotEmpty(subEntities)){
			subService.removeByIds(subEntities.stream().map(WorkAuthSubEntity::getId).collect(Collectors.toList()), true);
		}
		return CommonResponse.success("删除成功！");
	}

	/**
	 * @Description queryList 查询列表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse
	 *         <java.lang.String>
	 */
	@RequestMapping(value = "/queryList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<WorkAuthVO>> queryList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();

		IPage<WorkAuthEntity> page = service.queryPage(param, false);
		IPage<WorkAuthVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<WorkAuthVO> records = BeanMapper.mapList(page.getRecords(), WorkAuthVO.class);
		if(ListUtil.isNotEmpty(records)){
			records.forEach(auth->{
				JSONArray array = null;
				int ii = -1;
				if(auth.getTargetType() == 1){//人员
					JSONObject user = ztjApisService.getUser(auth.getProviderId(),auth.getTargetId());
					if(user!=null){
						auth.setTargetName(user.getString("name"));
					}
					JSONObject position = ztjApisService.getUserMainPosition(auth.getProviderId(),auth.getTargetId());
					if(position!=null){
						if(!Objects.equals(auth.getOrgId(),position.getString("id"))){
							//todo：记录人员岗位变化
							//todo：更新auth
							auth.setOrgId(position.getString("id"));
							service.saveOrUpdate(BeanMapper.map(auth,WorkAuthEntity.class));
						}
						array = ztjApisService.getOrgPath(auth.getProviderId(),position.getString("id"));
					}
				}else {//岗位
					ii = 0;
					JSONObject user = ztjApisService.getPosition(auth.getProviderId(),auth.getTargetId());
					if(user!=null){
						auth.setTargetName(user.getString("name"));
					}
					array  = ztjApisService.getOrgPath(auth.getProviderId(),auth.getTargetId());
				}
				StringBuffer paths = new StringBuffer("");
				if(array!=null){
					for (int i = array.size()-1; i >ii; i--) {
						JSONObject p = array.getJSONObject(i);
						if(p.get("virtual")==null || !p.getBoolean("virtual")){
							paths.append(p.getString("name")).append(" ");
						}
					}
				}
				auth.setOrgName(paths.toString());
			});
		}
		pageData.setRecords(records);

		return CommonResponse.success("查询列表数据成功！", pageData);
	}

	/**
	 * @Description queryList 查询授权统计报表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse
	 *         <java.lang.String>
	 */
	@RequestMapping(value = "/queryStatisticsList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<JSONObject>> queryStatisticsList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();

		IPage<WorkAuthEntity> page = service.queryPage(param, false);
		IPage<JSONObject> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<WorkAuthVO> records = BeanMapper.mapList(page.getRecords(), WorkAuthVO.class);
		List<JSONObject> recordList = new ArrayList<>();
		if(ListUtil.isNotEmpty(records)){
			records.forEach(auth->{
				JSONArray array = null;
				int ii = -1;
				if(auth.getTargetType() == 1){//人员
					JSONObject user = ztjApisService.getUser(auth.getProviderId(),auth.getTargetId());
					if(user!=null){
						auth.setTargetName(user.getString("name"));
					}
					JSONObject position = ztjApisService.getUserMainPosition(auth.getProviderId(),auth.getTargetId());
					if(position!=null){
						if(!Objects.equals(auth.getOrgId(),position.getString("id"))){
							auth.setOrgId(position.getString("id"));
							service.saveOrUpdate(BeanMapper.map(auth,WorkAuthEntity.class));
						}
						array = ztjApisService.getOrgPath(auth.getProviderId(),position.getString("id"));
					}
				}else {//岗位
					ii = 0;
					JSONObject user = ztjApisService.getPosition(auth.getProviderId(),auth.getTargetId());
					if(user!=null){
						auth.setTargetName(user.getString("name"));
					}
					array  = ztjApisService.getOrgPath(auth.getProviderId(),auth.getTargetId());
				}
				StringBuffer paths = new StringBuffer("");
				if(array!=null){
					for (int i = array.size()-1; i >ii; i--) {
						JSONObject p = array.getJSONObject(i);
						if(p.get("virtual")==null || !p.getBoolean("virtual")){
							paths.append(p.getString("name")).append(" ");
						}
					}
				}
				auth.setOrgName(paths.toString());
				QueryParam subParam = new QueryParam();
				subParam.getParams().put("pid",new Parameter(QueryParam.EQ,auth.getId()));
				List<WorkAuthSubEntity> subEntities = subService.queryList(subParam,false);
				JSONObject res = new JSONObject();
				res.put("targetName",auth.getTargetName());
				res.put("orgName",auth.getOrgName());
				res.put("corpName",auth.getCorpName());

				/*res.put("targetType",auth.getTargetType());
				res.put("targetId",auth.getTargetId());
				res.put("providerId",auth.getProviderId());
				res.put("corpPk",auth.getCorpPk());
				res.put("corpProviderId",auth.getCorpProviderId());
				res.put("corpParentPk",auth.getCorpParentPk());
				res.put("corpParentProviderId",auth.getCorpParentProviderId());
				res.put("orgId",auth.getOrgId());*/
				res.put("id",auth.getId());
				if(ListUtil.isNotEmpty(subEntities)){
					res.put("scope", subEntities.stream().map(WorkAuthSubEntity::getAuthName).collect(Collectors.joining(",")));
				}else {
					res.put("scope","");
				}
				recordList.add(res);
			});
		}
		pageData.setRecords(recordList);

		return CommonResponse.success("查询列表数据成功！", pageData);
	}


	/**
	 * @Author mrsir_wxp
	 * @Date 2021/4/20 查询授权子表
	 * @Description queryAuthAppList
	 * @Param [pid]
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.util.List<com.alibaba.fastjson.JSONObject>>
	 */
	@RequestMapping(value = "/queryAuthAppList", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<List<JSONObject>> queryAuthAppList(@RequestParam String pid) {
		QueryParam param = new QueryParam();
		List<ZtjAppEntity> appEntities = appService.queryList(param,false);
		param.getParams().put("pid",new Parameter(QueryParam.EQ,pid));
		List<WorkAuthSubEntity> subEntities = subService.queryList(param,false);
		List<JSONObject> res = new ArrayList<>();
		appEntities.forEach(app->{
			JSONObject object = new JSONObject();
			object.put("id",app.getId());
			object.put("name",app.getName());
			object.put("pid",pid);
			if(ListUtil.isNotEmpty(subEntities)){
				subEntities.forEach(s->{
					if(s.getAuthId().equals(app.getId())){
						object.put("auth",true);
						object.put("authSubId",s.getId());
					}
				});
				if(object.get("authSubId")==null){
					object.put("auth",false);
					object.put("authSubId",null);
				}
			}else {
				object.put("auth",false);
				object.put("authSubId",null);
			}
			res.add(object);
		});
		return CommonResponse.success("查询列表数据成功！", res);
	}

	/***
	 * @Author mrsir_wxp
	 * @Date 2021/4/21 定时任务更新授权人岗位信息
	 * @Description updateAuthPositionChange
	 * @Param []
	 * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
	 */
	@RequestMapping(value = "/updateAuthPositionChange", method = RequestMethod.GET)
	@ResponseBody
	public CommonResponse<String> updateAuthPositionChange(){
		QueryParam param = new QueryParam();
		param.getParams().put("targetType",new Parameter(QueryParam.EQ,1));
		List<WorkAuthEntity>  entities = service.queryList(param);
		if(ListUtil.isNotEmpty(entities)){
			entities.forEach(e->{
				JSONObject position = ztjApisService.getUserMainPosition(e.getProviderId(),e.getTargetId());
				if(!Objects.equals(position.getString("id"),e.getOrgId())){
					PositionChangeEntity changeEntity = new PositionChangeEntity();
					changeEntity.setCorpName(e.getCorpName());
					changeEntity.setCorpPk(e.getCorpPk());
					changeEntity.setCorpProviderId(e.getCorpProviderId());

					changeEntity.setTargetId(e.getTargetId());
					changeEntity.setNewPositionName(position.getString("name"));
					JSONObject p = ztjApisService.getPosition(e.getProviderId(),e.getOrgId());
					changeEntity.setOldPositionName(p.getString("name"));
					changeService.saveOrUpdate(changeEntity,false);
					e.setOrgId(position.getString("id"));
					service.saveOrUpdate(e,false);
				}
			});
		}
		return CommonResponse.success();
	}

	/**
	 * @Description queryList 查询 被授权人员岗位变化报表
	 * @param param
	 * @Return com.ejianc.framework.core.response.CommonResponse
	 *         <java.lang.String>
	 */
	@RequestMapping(value = "/queryAuthPositionChangeList", method = RequestMethod.POST)
	@ResponseBody
	public CommonResponse<IPage<PositionChangeVO>> queryAuthPositionChangeList(@RequestBody QueryParam param) {
		/** 模糊搜索配置字段示例 */
		List<String> fuzzyFields = param.getFuzzyFields();

		IPage<PositionChangeEntity> page = changeService.queryPage(param, false);
		IPage<PositionChangeVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
		List<PositionChangeVO> records = BeanMapper.mapList(page.getRecords(), PositionChangeVO.class);
		if(ListUtil.isNotEmpty(page.getRecords())){
			List<PositionChangeEntity> pageRecords = page.getRecords();
			for (int i = 0, pageRecordsSize = pageRecords.size(); i < pageRecordsSize; i++) {
				PositionChangeEntity e = pageRecords.get(i);
				PositionChangeVO change = records.get(i);
				JSONObject user = ztjApisService.getUser(e.getTargetProviderId(), e.getTargetId());
				change.setTargetName(user.getString("name"));
			}
		}
		pageData.setRecords(records);

		return CommonResponse.success("查询列表数据成功！", pageData);
	}
}
