package com.ejianc.poc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.poc.bean.AuthChangeRecordEntity;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.bean.WorkAuthSubEntity;
import com.ejianc.poc.mapper.AuthChangeRecordMapper;
import com.ejianc.poc.service.IAuthChangeRecordService;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.vo.AuthChangeRecordVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.transaction.annotation.Transactional;

import java.util.*;

/**
 * @author CJ
 * @Description:
 * @date 2021/4/20 17:48
 */
@Service(value = "authChangeService")
public class AuthChangeServiceImpl extends BaseServiceImpl<AuthChangeRecordMapper, AuthChangeRecordEntity> implements IAuthChangeRecordService {

    @Autowired
    private ZtjApisService ztjApisService;

    @Autowired
    private IWorkAuthService workAuthService;

    @Autowired
    private IWorkAuthSubService workAuthSubService;

    @Override
    @Transactional(rollbackFor = Exception.class)
    public boolean checkOrgList(List<WorkAuthEntity> authOrgList) {
//      providerId + corp_pk
        Map<String, String> namePathCache = new HashMap<>();
//      被删除组织记录：corp_providerId + corp_pk
        Set<String> orgIds = new HashSet<>();
//      corp_providerId + user_id
        Set<String> userIds = new HashSet<>();


        //缓存用户信息
        Map<String, JSONObject> userMap = new HashMap<>();
        //缓存岗位信息
        Map<String, JSONObject> postMap = new HashMap<>();
        //缓存组织信息
        //组织的ProviderId + 组织的Id为key
        Map<String, JSONObject> orgMap = new HashMap<>();

//        corp_providerId + corp_pk
        Map<String, AuthChangeRecordEntity> recordMap = new HashMap<>();


        JSONObject tmpOrg = null;
        JSONObject tmpPost = null;
        String uniqOrg = null;
        String uniqTarget = null;
        JSONObject tmpTarget = null;
        AuthChangeRecordEntity tmpRecord = null;
        List<AuthChangeRecordEntity> recordList = new ArrayList<>();
        List<Long> removeAuthId = new ArrayList<>();

        for(WorkAuthEntity auth : authOrgList) {
            uniqOrg = auth.getCorpProviderId() + auth.getCorpPk();
            uniqTarget = auth.getCorpProviderId() + auth.getTargetId();

            if(1 == auth.getTargetType()) {
                //尝试从缓存获取人员信息
                tmpTarget = userMap.get(uniqTarget);
                if(null == tmpTarget) {
                    tmpTarget = ztjApisService.getUser(auth.getCorpProviderId(), auth.getTargetId());
                    //查询用户主要岗位
                    tmpPost = ztjApisService.getUserMainPosition(auth.getCorpProviderId(), auth.getTargetId());
                    if(null != tmpPost) {
                        tmpTarget.put("mainPostId", tmpPost.getString("id"));
                    }
                }
            } else {
                //尝试从缓存获取岗位信息
                tmpTarget = postMap.get(uniqTarget);
                if(null == tmpTarget) {
                    tmpTarget = ztjApisService.getPosition(auth.getCorpProviderId(), auth.getTargetId());
                }
            }

            if(orgIds.contains(uniqOrg)) {
                if(!auth.getCorpPk().equals("986437")) {
                    //进行组织删除检查
                    tmpOrg = ztjApisService.getSureOrg(auth.getCorpProviderId(), auth.getCorpPk());
                }
                if(null != tmpOrg) {
                    orgMap.put(uniqOrg, tmpOrg);
                } else {
                    //组织不存在，生成授权组织删除记录
                    tmpRecord = generateRecord(auth, tmpTarget, namePathCache, orgMap);
                    recordList.add(tmpRecord);
                    orgIds.add(uniqOrg);
                    removeAuthId.add(auth.getId());
                }
            } else {
                tmpRecord = generateRecord(auth, tmpTarget, namePathCache, orgMap);
                recordList.add(tmpRecord);
                removeAuthId.add(auth.getId());
            }
        }

        if(CollectionUtils.isNotEmpty(removeAuthId)) {
            workAuthService.removeByIds(removeAuthId, false);

            QueryWrapper<WorkAuthSubEntity> subDelQuery = new QueryWrapper<>();
            subDelQuery.in("pid", subDelQuery);
            workAuthSubService.remove(subDelQuery, false);

            //保存授权组织删除记录
            super.saveOrUpdateBatch(recordList, recordList.size(), false);

            return true;
        }

        return false;
    }

    private AuthChangeRecordEntity generateRecord(WorkAuthEntity auth, JSONObject target, Map<String, String> namePathCache, Map<String, JSONObject> orgMap) {
        AuthChangeRecordEntity resp = new AuthChangeRecordEntity();
        String namePath = null;
        String uniqPostId = null;

        StringBuilder sp = new StringBuilder();
        JSONObject tmpJson = null;

        //被授权对象名称
        resp.setTargetName(target.getString("name"));
        //记录类型
        resp.setType(AuthChangeRecordVO.RECORD_TYPE_ORG_DEL);
        resp.setProviderId(auth.getCorpProviderId());
        //记录所属组织Id
        resp.setOrgId(auth.getCorpParentPk());
        JSONObject orgJson = orgMap.get(auth.getProviderId() + auth.getCorpParentPk());
        if(orgJson == null) {
            orgJson = ztjApisService.getSureOrg(auth.getProviderId(), auth.getCorpParentPk());
        }
//        if(null != orgJson) {
//            //记录所属组织编码
//            resp.setOrgCode(orgJson.getString("code"));
//        }
        //授权对象Id
        if(1 == auth.getTargetType()) {
            resp.setUserId(auth.getTargetId());
            uniqPostId = auth.getProviderId() + target.getString("mainPostId");
            resp.setOrignalPostId(target.getString("mainPostId"));
        } else {
            resp.setPostId(auth.getTargetId());
            uniqPostId = auth.getProviderId() + auth.getTargetId();
        }
        resp.setChangeTime(new Date());
        //授权组织删除记录
        resp.setOrignalOrgId(auth.getCorpPk());
        //获取原授权对象岗位路径
        namePath = namePathCache.get(uniqPostId);
        if(null == namePath) {
            if(sp.length() > 0) {
                resp.setOriginalPostNamePath(sp.toString());
            }
        } else {
            resp.setOriginalPostNamePath(namePath);
        }
        //获取删除组织路径
        namePath = namePathCache.get(auth.getCorpProviderId() + auth.getCorpPk());
        if(null == namePath) {
            queryNamePath(auth.getProviderId(), target.getString("mainPostId"), namePathCache, sp);
            if(sp.length() > 0) {
                resp.setOriginalOrgNamePath(sp.toString()+auth.getCorpName());
            }
        } else {
            resp.setOriginalOrgNamePath(namePath);
        }

        return resp;
    }

    private void queryNamePath(String providerId, String orgId, Map<String, String> namePathCache, StringBuilder sp) {
        JSONObject tmpJson = null;
        //查询获取岗位路径
        JSONArray pathArr = ztjApisService.getOrgPath(providerId, orgId);
        if(null != pathArr && pathArr.size() > 0) {
            sp = sp.delete(0, sp.length());
            for(int i = pathArr.size() -1; i >=0; i--) {
                tmpJson = pathArr.getJSONObject(i);
                if(null == tmpJson.get("virtual") || !tmpJson.getBoolean("virtual")) {
                    sp.append(tmpJson.getString("name"));
                    if(!namePathCache.containsKey(providerId+tmpJson.get("id"))) {
                        namePathCache.put(providerId+tmpJson.get("id"), sp.toString());
                    }
                }
            }
        }
    }
}
