package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.cache.redis.CacheManager;
import com.ejianc.framework.cache.serializer.Serializer;
import com.ejianc.framework.cache.serializer.impl.DefaultJDKSerializer;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.DeptVO;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.UserVO;
import org.apache.catalina.User;
import org.apache.commons.codec.binary.Hex;
import org.apache.commons.codec.digest.DigestUtils;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.nio.charset.Charset;
import java.util.ArrayList;
import java.util.List;
import java.util.UUID;

/**
 * @author CJ
 * @Description:
 * @date 2021/4/14 15:07
 */
@RestController
@RequestMapping(value = "/employee/")
public class EmployeeManageController {

    @Autowired
    private ZtjApisService ztjApisService;

    @Autowired
    private CacheManager cacheManager;

    private final String userCachePrefix = "orgUserList::";

    public static final String DEFAULT_CHARSET = "UTF-8";

    private final static String ORG_LIST_KEY = "org_list_key";

    private Serializer serializer = new DefaultJDKSerializer();

    @GetMapping(value = "pageList")
    public CommonResponse<IPage<UserVO>> pageList(@RequestParam(value = "pageSize") int pageSize,
                                          @RequestParam(value = "pageNumber") int pageNumber,
                                          @RequestParam(value = "providerId", required = false) String providerId,
                                          @RequestParam(value = "orgId") String orgId,
                                          @RequestParam(value = "deptId", required = false) String deptId) {
        String allOrgUsers = null;
        IPage<UserVO> pageUser = new Page<>();
        pageNumber = pageNumber - 1 <= 0 ? 1 : pageNumber;
        int from = (pageNumber - 1) * pageSize;
        int to = pageNumber * pageSize;
        int size = 0;
        List<UserVO> users = new ArrayList<>();
        List<UserVO> tmpUserList = null;
        JSONArray userOrgArr = null;
        String orgName = null;
        String deptName = null;

        pageUser.setSize(pageSize);
        pageUser.setCurrent(pageNumber);
        pageUser.setRecords(new ArrayList<>());

        if(OrgVO.rootOrgId.toString().equals(orgId)) {
            //获取所有二级集团单位信息
            JSONArray jsonArray = ztjApisService.getAllSecondOrgList();
            JSONObject objJson = null;
            JSONObject orgJson = null;

            for(Object obj : jsonArray) {
                objJson = JSONObject.parseObject(JSONObject.toJSONString(obj));
                orgJson = objJson.getJSONObject("root");

                allOrgUsers = ztjApisService.queryAllTreeOrgAndUsers(objJson.getString("id"), orgJson.getString("id"));
                if(StringUtils.isNotBlank(allOrgUsers)) {
                    orgJson = JSONObject.parseObject(allOrgUsers);
                    userOrgArr = orgJson.getJSONArray("children");
                    orgName = orgJson.getString("name");

                    if(null != userOrgArr) {
                        if(pageUser.getSize() <= pageUser.getRecords().size() || (userOrgArr.size() < (from - pageUser.getTotal()))) {
                            countUser(userOrgArr, pageUser);
                        } else {
                            users.addAll(parseOrgUseJsonList(userOrgArr, null, orgName, null, pageUser, "-99999"));
                        }
                    }
                }
            }
        } else {
            allOrgUsers = ztjApisService.queryAllTreeOrgAndUsers(providerId, orgId);

            if(StringUtils.isNotBlank(allOrgUsers)) {
                JSONObject orgJson = JSONObject.parseObject(allOrgUsers);
//                if(orgJson.getBoolean("virtual")) {
                    orgName = "";
                    //若为虚拟组织机构，则向上查询其最近的非虚拟上级
                    JSONArray orgPathJsonArr = ztjApisService.getOrgPath(providerId, orgId);
                    if(orgPathJsonArr.size() > 0) {
                        JSONObject tmpOrg = null;
                        for(Object obj : orgPathJsonArr) {
                            tmpOrg = (JSONObject)obj;
                            if("1".equals(tmpOrg.getString("type")) && !tmpOrg.getBoolean("virtual")) {
                                orgName = tmpOrg.getString("name") + orgName;
                            }
                        }
                    } else {
                        orgName = orgJson.getString("name");
                    }
                userOrgArr = orgJson.getJSONArray("children");

                if(null != userOrgArr) {
                    users.addAll(parseOrgUseJsonList(userOrgArr, deptId, orgName, null, pageUser,providerId));
                }
            }
        }

//        StringBuilder sp = new StringBuilder();
//        if(!pageUser.getRecords().isEmpty()) {
//            for(UserVO user : pageUser.getRecords()) {
//                sp.delete(0, sp.length());
//                JSONArray postArr = ztjApisService.getUserAllPosition(user.getProviderId(), user.getId().toString());
//                if(postArr.size() > 0) {
//                    postArr.stream().forEach(obj -> sp.append(((JSONObject)obj).get("name")).append(","));
//                    user.setPostName(sp.substring(0, sp.length()-1));
//                }
//            }
//        }

//        pageUser.setRecords(users);

        return CommonResponse.success("分页查询成功！", pageUser);
    }


    private void cacheOrgUserInfo(JSONArray jsonArray, String cacheKey) {
        cacheManager.removeCache(cacheKey);
        if(jsonArray != null && jsonArray.size() > 0) {
            cacheManager.piplineExecute(pipeline -> {
                pipeline.multi();
                String key = cacheKey;
                byte[] keyBytes = ORG_LIST_KEY.getBytes(Charset.forName(DEFAULT_CHARSET));
                byte[] fieldBytes = key.getBytes(Charset.forName(DEFAULT_CHARSET));
                for (Object orgObj : jsonArray) {
                    byte[] contentBytes = serializer.marshalToByte(JSON.toJSONString(orgObj));
                    pipeline.hset(keyBytes, fieldBytes, contentBytes);
                }
                pipeline.exec();
            });
        }
    }

    public JSONArray getOrgUserInfoCache(String cacheKey) {
        JSONArray resp = new JSONArray();
        String content = cacheManager.hget(ORG_LIST_KEY, cacheKey);
        resp.add(JSON.parseObject(content));
        return resp;
    }

    private void countUser(JSONArray orgUserArr, IPage page) {
        String orgType = null;
        List<UserVO> oneOrgUserList = null;
        JSONObject json = null;

        for(Object obj : orgUserArr) {
            json = (JSONObject) obj;
            orgType = json.get("type").toString();
            switch (orgType) {
                case "1":
                case "2": {
                    if(null != json.get("children")) {
                        countUser(json.getJSONArray("children"), page);
                    }
                    continue;
                }
                case "3": {
                    if(null != json.get("users")) {
                        page.setTotal(page.getTotal() + json.getJSONArray("users").size());
                    }
                    continue;
                }
                default:
                    continue;
            }
        }
    }

    private List<UserVO> parseOrgUseJsonList(List<Object> orgUserArr, String deptId, String orgName, String deptName, IPage page, String providerId) {
        List<UserVO> userList = new ArrayList<>();
        List<UserVO> tmpList = null;
        long takeNum = 0;

        String orgType = null;
        JSONArray jsonArr = null;
        JSONObject org = null;
        boolean isVirtual = false;

        if(StringUtils.isNotBlank(deptId)) {
            for(Object obj : orgUserArr) {
                org = (JSONObject) obj;
                if( "3".equals(org.getString("type")) && deptId.equals(org.getString("id")) && (null != org.get("children"))) {
                    userList.addAll(parseOrgUseJsonList(org.getJSONArray("children"), null, orgName, org.getString("name"), page, providerId));
                    break;
                }
            }
        } else {
            for(Object obj : orgUserArr) {
                org = (JSONObject) obj;
                orgType = org.getString("type");
                isVirtual = null != org.get("virtual") ? org.getBoolean("virtual") : true;

                switch (orgType) {
                    //单位
                    case "1":
                        jsonArr = org.getJSONArray("children");
                        if(null != jsonArr) {
                            tmpList = parseOrgUseJsonList(jsonArr, null, isVirtual ? orgName : orgName + org.getString("name"), deptName, page,providerId);
                            if(tmpList.size() > 0) {
                                takeNum += tmpList.size();
                                userList.addAll(tmpList);
                            }
                        }
                        continue;
                    case "2": {
                        //部门
                        jsonArr = org.getJSONArray("children");
                        if(null != jsonArr) {
                            tmpList = parseOrgUseJsonList(jsonArr, null, orgName, org.getString("name"), page,providerId);
                            if(tmpList.size() > 0) {
                                userList.addAll(tmpList);
                                takeNum += tmpList.size();
                            }
                        }
                        continue;
                    }
                    case "3": {
                        long start = (page.getCurrent() - 1) * page.getSize();
                        long limit = page.getSize() - (null != page.getRecords() ? page.getRecords().size() : 0);
                        start = start > page.getTotal() ? start - page.getTotal() : 0;
                        long to = start + limit;

                        jsonArr = jsonArr = org.getJSONArray("users");
                        if(null != jsonArr) {
                            page.setTotal(page.getTotal() + jsonArr.size());
                            if(jsonArr.size() < start || limit <= 0) {
                                continue;
                            }

                            tmpList = pageUsers(jsonArr.subList(Integer.valueOf(start+""), to > jsonArr.size() ? jsonArr.size() : Integer.valueOf(to+"")), providerId,
                                    org.getInteger("order"), orgName, deptName, org.getString("name"));
                            page.getRecords().addAll(tmpList);
                            takeNum += tmpList.size();
                        }
                        continue;
                    }
                    default:
                        continue;
                }
            }
        }

        return userList;
    }

    private List<UserVO> pageUsers(List<Object> userJsonArr, String curProviderId, int postOrder, String orgName, String deptName, String postName) {
        List<UserVO> resp = new ArrayList<>();
        JSONObject userJson = null;

        for(Object obj : userJsonArr) {
            userJson = (JSONObject) obj;
            UserVO tmp = new UserVO();
            tmp.setType(4);
            tmp.setName(null != userJson.get("name") ? userJson.get("name").toString() : null);
            tmp.setOrder(null != userJson.get("order") ? Integer.valueOf(userJson.get("order").toString()) : 9999);
            tmp.setGender(null != userJson.get("gender") ? Integer.valueOf(userJson.get("gender").toString()) : 1);
            tmp.setCategory(null != userJson.get("category") ? Integer.valueOf(userJson.get("category").toString()) : 101301);
            tmp.setPositionStatus(null != userJson.get("positionStatus") ? Integer.valueOf(userJson.get("positionStatus").toString()) : 101401);
            tmp.setProviderId(curProviderId);
            tmp.setPostOrder(postOrder);
            tmp.setId(Long.valueOf(userJson.get("id").toString()));
            tmp.setMainPosition(null != userJson.get("mainPosition") ? Boolean.valueOf(userJson.get("mainPosition").toString()) : false);
            tmp.setUniqSymbol(UUID.randomUUID().toString().replace("-",""));
            tmp.setChildren(null);
            tmp.setDeptName(deptName);
            tmp.setOrgName(orgName);
            tmp.setPostName(postName);
            resp.add(tmp);
        }

        return resp;
    }
}
