package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.*;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/4/14 15:38
 */
@RestController
@RequestMapping(value = "/org/")
public class OrgController {

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private ZtjApisService ztjApisService;

    @Autowired
    private SessionManager sessionManager;

    @Value("${oms.expandLevel}")
    private Integer expandLevel;

    @GetMapping(value = "lazyLoadOrgTree")
    public CommonResponse<List<BaseFieldVO>> lazyLoadOrgTree(@RequestParam(value = "providerId", required = false) String providerId,
                                                             @RequestParam(value = "pid", required = false) Long pid,
                                                             @RequestParam(value = "orgType") int orgType,
                                                             @RequestParam(value = "appId") String appId,
                                                             @RequestParam(value = "expandType", required = false) Integer expandType) {

        logger.info("查询树-参数：providerId-{}，pid-{}，orgType-{}，orgType-{}，appId-{}，expandType-{}", providerId, pid, orgType, appId, expandType);
        long start = System.currentTimeMillis();
        if(expandType == null){
            expandType = expandLevel;
        }
        List<BaseFieldVO> resp = new ArrayList<>();
        if(StringUtils.isBlank(providerId) && (null == pid)) {
            logger.info("查询有权限的根节点");
            resp.addAll(ztjApisService.getTreeRootByAppId(appId, null != expandType ? expandType : expandLevel));
            logger.info("查询有权限的根节点结果: {}", JSONObject.toJSONString(resp));
        } else {
            logger.info("查询指定组织节点的直接下级");
            if(orgType <= expandType) {
                //查询单位直接下级组织机构集合
                JSONArray jsonArray = null;
                if(String.valueOf(OrgVO.rootOrgId).equals(String.valueOf(pid))){
                    jsonArray = ztjApisService.getAllSecondOrgList();
                }else {
                    if(orgType == 3){//查询岗位下人员
                        jsonArray = ztjApisService.getPositionUsers(providerId,String.valueOf(pid));
                        for(Object obj : jsonArray) {
                            JSONObject personJson = (JSONObject)obj;
                            personJson.put("type","4");
                            JSONObject positionId = ztjApisService.getUserMainPosition(providerId,personJson.getString("id"));
                            personJson.put("positionId",positionId.getString("id"));
                            JSONArray array = ztjApisService.getOrgPath(providerId,String.valueOf(pid));
                            StringBuffer paths = new StringBuffer("");
                            if(array!=null){
                                for (int i = array.size()-1; i >-1; i--) {
                                    JSONObject p = array.getJSONObject(i);
                                    if(p.get("virtual")==null || !p.getBoolean("virtual")){
                                        paths.append(p.getString("name")).append(" ");
                                    }
                                }
                            }
                            personJson.put("positionName",paths);
                        }
                    }else {
                        jsonArray = ztjApisService.getOrgDirectChildren(providerId, pid.toString());
                        for(Object obj : jsonArray) {
                            JSONObject json = (JSONObject)obj;
                            json.put("positionId",pid);
                            if(json.getInteger("type") == 3){
                                StringBuffer paths = new StringBuffer("");
                                JSONArray array = ztjApisService.getOrgPath(providerId,String.valueOf(pid));
                                if(array!=null){
                                    for (int i = array.size()-1; i >-1; i--) {
                                        JSONObject p = array.getJSONObject(i);
                                        if(p.get("virtual")==null || !p.getBoolean("virtual")){
                                            paths.append(p.getString("name")).append(" ");
                                        }
                                    }
                                }
                                json.put("positionName",paths);
                            }
                        }
                    }
                }
                transToBaseFieldVO(jsonArray, resp, providerId, null != expandType ? expandType : expandLevel, pid.toString());

                logger.info("查询指定组织节点的直接下级结果：{}", JSONObject.toJSONString(resp));
            } else {
                logger.info("要查询节点的等级[{}]大于页面限制的展开层级[{}]，返回空集合。", orgType, expandLevel);
            }
        }

        if(CollectionUtils.isNotEmpty(resp)) {
            resp.sort(new Comparator<BaseFieldVO>() {
                @Override
                public int compare(BaseFieldVO b1, BaseFieldVO b2) {
                    if(b1.getType() < b2.getType()) {
                        return -1;
                    } else if(b1.getType() == b2.getType()) {
                        return b1.getOrder() < b2.getOrder() ? -1 : 1;
                    } else {
                        return 1;
                    }
                }
            });
        }

        long end = System.currentTimeMillis();
        logger.info("查询组织树耗时：-{}毫秒", (end - start));

        return CommonResponse.success("查询成功！", resp);
    }

    public static void transToBaseFieldVO(JSONArray data, List<BaseFieldVO> list, String providerId, Integer curExpandLevel, String parentIdOrgId) {
        String type = null;
        JSONObject objJson = null;
        JSONObject orgJson = null;
        String curProviderId = null;

        for(Object obj : data) {
            if(OrgVO.rootOrgCode.equals(providerId)) {
                objJson = JSONObject.parseObject(JSONObject.toJSONString(obj));
                orgJson = objJson.getJSONObject("root");
                curProviderId = null != objJson.get("id") ? objJson.get("id").toString() : null;
            } else {
                curProviderId = providerId;
                orgJson = JSONObject.parseObject(JSONObject.toJSONString(obj));
            }

            type = null != orgJson.get("type") ? orgJson.get("type").toString() : "4";
            if((null != curExpandLevel) && (Integer.valueOf(type) > curExpandLevel)) {
                continue;
            }
            switch (orgJson.get("type").toString()) {
                case "1" : {
                    OrgVO tmp = new OrgVO();
                    tmp.setShow(null != orgJson.get("show") ? Boolean.valueOf(orgJson.get("show").toString()) : true);
                    tmp.setVirtual(null != orgJson.get("virtual") ? Boolean.valueOf(orgJson.get("virtual").toString()) : false);
                    tmp.setFullName(null != orgJson.get("fullname") ? orgJson.get("fullname").toString() : null);
                    tmp.setCode(null != orgJson.get("code") ? orgJson.get("code").toString() : null);
                    tmp.setId(Long.valueOf(orgJson.get("id").toString()));
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get("name") ? orgJson.get("name").toString() : null);
                    tmp.setOrder(null != orgJson.get("order") ? Integer.valueOf(orgJson.get("order").toString()) : 9999);
                    tmp.setProviderId(curProviderId);
                    tmp.setUniqSymbol(orgJson.get("id").toString()+"-"+curProviderId);
                    tmp.setPid(StringUtils.isNotBlank(parentIdOrgId) ? parentIdOrgId : null != orgJson.get("parentIdOrgId") ? orgJson.get("parentIdOrgId").toString() : null);
                    list.add(tmp);
                    break;
                }
                case "2": {
                    DeptVO tmp = new DeptVO();
                    tmp.setVirtual(null != orgJson.get("virtual") ? Boolean.valueOf(orgJson.get("virtual").toString()) : false);
                    tmp.setCode(null != orgJson.get("code") ? orgJson.get("code").toString() : null);
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get("name") ? orgJson.get("name").toString() : null);
                    tmp.setOrder(null != orgJson.get("order") ? Integer.valueOf(orgJson.get("order").toString()) : 9999);
                    tmp.setProviderId(curProviderId);
                    tmp.setId(Long.valueOf(orgJson.get("id").toString()));
                    tmp.setUniqSymbol(orgJson.get("id").toString()+"-"+curProviderId);
                    tmp.setOrgId(StringUtils.isNotBlank(parentIdOrgId) ? parentIdOrgId : null != orgJson.get("parentIdOrgId") ? orgJson.get("parentIdOrgId").toString() : null);
                    list.add(tmp);
                    break;
                }
                case "3": {
                    PostVO tmp = new PostVO();
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get("name") ? orgJson.get("name").toString() : null);
                    tmp.setOrder(null != orgJson.get("order") ? Integer.valueOf(orgJson.get("order").toString()) : 9999);
                    tmp.setProviderId(curProviderId);
                    tmp.setId(Long.valueOf(orgJson.get("id").toString()));
                    tmp.setPositionId(orgJson.getString("positionId"));
                    tmp.setPositionName(orgJson.getString("positionName"));
                    tmp.setUniqSymbol(orgJson.get("id").toString()+"-"+curProviderId);
                    tmp.setOrgId(StringUtils.isNotBlank(parentIdOrgId) ? parentIdOrgId : null != orgJson.get("parentIdOrgId") ? orgJson.get("parentIdOrgId").toString() : null);
                    list.add(tmp);
                    break;
                }
                case "4": {
                    //用户
                    UserVO tmp = new UserVO();
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get("name") ? orgJson.get("name").toString() : null);
                    tmp.setOrder(null != orgJson.get("order") ? Integer.valueOf(orgJson.get("order").toString()) : 9999);
                    tmp.setGender(null != orgJson.get("gender") ? Integer.valueOf(orgJson.get("gender").toString()) : 1);
                    tmp.setCategory(null != orgJson.get("category") ? Integer.valueOf(orgJson.get("category").toString()) : 101301);
                    tmp.setPositionStatus(null != orgJson.get("positionStatus") ? Integer.valueOf(orgJson.get("positionStatus").toString()) : 101401);
                    tmp.setProviderId(curProviderId);
                    tmp.setId(Long.valueOf(orgJson.get("id").toString()));
                    tmp.setMainPosition(null != orgJson.get("mainPosition") ? Boolean.valueOf(orgJson.get("mainPosition").toString()) : false);
                    tmp.setPositionId(orgJson.getString("positionId"));
                    tmp.setPositionName(orgJson.getString("positionName"));
                    tmp.setUniqSymbol(orgJson.get("id").toString()+"-"+curProviderId);
                    list.add(tmp);
                    break;
                }
                default: ;
            }
        }
    }
}
