package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.poc.bean.AuthChangeRecordEntity;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.service.IAuthChangeRecordService;
import com.ejianc.poc.service.IWorkAuthService;
import com.ejianc.poc.vo.AuthChangeRecordVO;
import org.apache.commons.collections.CollectionUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.web.bind.annotation.*;

import java.util.ArrayList;
import java.util.List;

/**
 * @author CJ
 * @Description:
 * @date 2021/4/20 16:04
 */
@RestController
@RequestMapping(value = "/report/")
public class ReportController {

    @Autowired
    private IWorkAuthService workAuthService;

    @Autowired
    private IAuthChangeRecordService authChangeRecordService;

    /**
     * 刷新当前授权组织、岗位信息，若组织、岗位信息发生变化则生成对应的记录入库
     * @return
     */
    @GetMapping(value = "refreshDelAuthOrgInfo")
    public CommonResponse<JSONObject> refreshAuthedOrgInfo() {
        //查询当前工作授权中所有涉及到的组织信息
        List<WorkAuthEntity> authOrgList = workAuthService.queryAllAuthOrgList(null, null);
        authChangeRecordService.checkOrgList(authOrgList);

        return CommonResponse.success("刷新当前授权组织、岗位信息成功！");
    }

    @GetMapping(value = "pageList")
    public CommonResponse<JSONObject> pageList(@RequestParam(value = "orgId") String orgId,
                                               @RequestParam(value = "providerId") String providerId,
                                               @RequestParam(value = "pageSize") int pageSize,
                                               @RequestParam(value = "pageNumber") int pageNumber,
                                               @RequestParam(value = "recordType") int recordType) {
        JSONObject resp = new JSONObject();
        List<WorkAuthEntity> authOrgList = workAuthService.queryAllAuthOrgList(orgId, providerId);
        boolean result = authChangeRecordService.checkOrgList(authOrgList);

        if(!result) {
            resp.put("reloadPage", false);
            QueryParam queryParam = new QueryParam();
            queryParam.getParams().put("orgId", new Parameter(QueryParam.EQ, orgId));
            queryParam.getParams().put("providerId", new Parameter(QueryParam.EQ, providerId));
            queryParam.getParams().put("type", new Parameter(QueryParam.EQ, recordType));
            queryParam.setPageSize(pageSize);
            queryParam.setPageIndex(pageNumber);
            queryParam.getOrderMap().put("createTime", QueryParam.DESC);
            IPage<AuthChangeRecordEntity> page = authChangeRecordService.queryPage(queryParam);

            resp.put("current", page.getCurrent());
            resp.put("size", page.getSize());
            resp.put("pages", page.getPages());
            resp.put("total", page.getTotal());
            resp.put("records", CollectionUtils.isNotEmpty(page.getRecords()) ? BeanMapper.mapList(page.getRecords(), AuthChangeRecordVO.class) : new ArrayList<>());
        } else {
            resp.put("reloadPage", true);
        }
        return CommonResponse.success("分页查询成功！", resp);
    }
}
