/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.poc.service.impl.ZtjApisService;
import com.ejianc.poc.vo.BaseFieldVO;
import com.ejianc.poc.vo.DeptVO;
import com.ejianc.poc.vo.OrgVO;
import com.ejianc.poc.vo.PostVO;
import com.ejianc.poc.vo.UserVO;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.List;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.beans.factory.annotation.Value;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.RestController;

@RestController
@RequestMapping(value={"/org/"})
public class OrgController {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ZtjApisService ztjApisService;
    @Autowired
    private SessionManager sessionManager;
    @Value(value="${oms.expandLevel}")
    private Integer expandLevel;

    @GetMapping(value={"lazyLoadOrgTree"})
    public CommonResponse<List<BaseFieldVO>> lazyLoadOrgTree(@RequestParam(value="providerId", required=false) String providerId, @RequestParam(value="pid", required=false) Long pid, @RequestParam(value="orgType") int orgType, @RequestParam(value="appId") String appId, @RequestParam(value="expandType", required=false) Integer expandType) {
        this.logger.info("\u67e5\u8be2\u6811-\u53c2\u6570\uff1aproviderId-{}\uff0cpid-{}\uff0corgType-{}\uff0corgType-{}\uff0cappId-{}\uff0cexpandType-{}", new Object[]{providerId, pid, orgType, appId, expandType});
        long start = System.currentTimeMillis();
        if (expandType == null) {
            expandType = this.expandLevel;
        }
        ArrayList<BaseFieldVO> resp = new ArrayList<BaseFieldVO>();
        if (StringUtils.isBlank((CharSequence)providerId) && null == pid) {
            this.logger.info("\u67e5\u8be2\u6709\u6743\u9650\u7684\u6839\u8282\u70b9");
            resp.addAll(this.ztjApisService.getTreeRootByAppId(appId, null != expandType ? expandType : this.expandLevel));
            this.logger.info("\u67e5\u8be2\u6709\u6743\u9650\u7684\u6839\u8282\u70b9\u7ed3\u679c: {}", (Object)JSONObject.toJSONString(resp));
        } else {
            this.logger.info("\u67e5\u8be2\u6307\u5b9a\u7ec4\u7ec7\u8282\u70b9\u7684\u76f4\u63a5\u4e0b\u7ea7");
            if (orgType <= expandType) {
                JSONArray jsonArray = null;
                if (String.valueOf(OrgVO.rootOrgId).equals(String.valueOf(pid))) {
                    jsonArray = this.ztjApisService.getAllSecondOrgList();
                } else if (orgType == 3) {
                    jsonArray = this.ztjApisService.getPositionUsers(providerId, String.valueOf(pid));
                    for (Object obj : jsonArray) {
                        JSONObject personJson = (JSONObject)obj;
                        personJson.put("type", (Object)"4");
                        JSONObject positionId = this.ztjApisService.getUserMainPosition(providerId, personJson.getString("id"));
                        personJson.put("positionId", (Object)positionId.getString("id"));
                        JSONArray array = this.ztjApisService.getOrgPath(providerId, String.valueOf(pid));
                        StringBuffer paths = new StringBuffer("");
                        if (array != null) {
                            for (int i = array.size() - 1; i > -1; --i) {
                                JSONObject p = array.getJSONObject(i);
                                if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                                paths.append(p.getString("name")).append(" ");
                            }
                        }
                        personJson.put("positionName", (Object)paths);
                    }
                } else {
                    jsonArray = this.ztjApisService.getOrgDirectChildren(providerId, pid.toString());
                    for (Object obj : jsonArray) {
                        JSONObject json = (JSONObject)obj;
                        json.put("positionId", (Object)pid);
                        if (json.getInteger("type") != 3) continue;
                        StringBuffer paths = new StringBuffer("");
                        JSONArray array = this.ztjApisService.getOrgPath(providerId, String.valueOf(pid));
                        if (array != null) {
                            for (int i = array.size() - 1; i > -1; --i) {
                                JSONObject p = array.getJSONObject(i);
                                if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
                                paths.append(p.getString("name")).append(" ");
                            }
                        }
                        json.put("positionName", (Object)paths);
                    }
                }
                OrgController.transToBaseFieldVO(jsonArray, resp, providerId, null != expandType ? expandType : this.expandLevel, pid.toString());
                this.logger.info("\u67e5\u8be2\u6307\u5b9a\u7ec4\u7ec7\u8282\u70b9\u7684\u76f4\u63a5\u4e0b\u7ea7\u7ed3\u679c\uff1a{}", (Object)JSONObject.toJSONString(resp));
            } else {
                this.logger.info("\u8981\u67e5\u8be2\u8282\u70b9\u7684\u7b49\u7ea7[{}]\u5927\u4e8e\u9875\u9762\u9650\u5236\u7684\u5c55\u5f00\u5c42\u7ea7[{}]\uff0c\u8fd4\u56de\u7a7a\u96c6\u5408\u3002", (Object)orgType, (Object)this.expandLevel);
            }
        }
        if (CollectionUtils.isNotEmpty(resp)) {
            resp.sort(new Comparator<BaseFieldVO>(){

                @Override
                public int compare(BaseFieldVO b1, BaseFieldVO b2) {
                    if (b1.getOrder() < b2.getOrder()) {
                        return -1;
                    }
                    if (b1.getOrder().intValue() == b2.getOrder().intValue()) {
                        return b1.getId() < b2.getId() ? -1 : 1;
                    }
                    return 1;
                }
            });
        }
        long end = System.currentTimeMillis();
        this.logger.info("\u67e5\u8be2\u7ec4\u7ec7\u6811\u8017\u65f6\uff1a-{}\u6beb\u79d2", (Object)(end - start));
        return CommonResponse.success((String)"\u67e5\u8be2\u6210\u529f\uff01", resp);
    }

    public static void transToBaseFieldVO(JSONArray data, List<BaseFieldVO> list, String providerId, Integer curExpandLevel, String parentIdOrgId) {
        String type = null;
        JSONObject objJson = null;
        JSONObject orgJson = null;
        String curProviderId = null;
        for (Object obj : data) {
            if ("root_org_code".equals(providerId)) {
                objJson = JSONObject.parseObject((String)JSONObject.toJSONString(obj));
                orgJson = objJson.getJSONObject("root");
                curProviderId = null != objJson.get((Object)"id") ? objJson.get((Object)"id").toString() : null;
            } else {
                curProviderId = providerId;
                orgJson = JSONObject.parseObject((String)JSONObject.toJSONString(obj));
            }
            String string = type = null != orgJson.get((Object)"type") ? orgJson.get((Object)"type").toString() : "4";
            if (null != curExpandLevel && Integer.valueOf(type) > curExpandLevel) continue;
            switch (orgJson.get((Object)"type").toString()) {
                case "1": {
                    OrgVO tmp = new OrgVO();
                    tmp.setShow(Boolean.valueOf(null != orgJson.get((Object)"show") ? Boolean.valueOf(orgJson.get((Object)"show").toString()) : true));
                    tmp.setVirtual(Boolean.valueOf(null != orgJson.get((Object)"virtual") ? Boolean.valueOf(orgJson.get((Object)"virtual").toString()) : false));
                    tmp.setFullName(null != orgJson.get((Object)"fullname") ? orgJson.get((Object)"fullname").toString() : null);
                    tmp.setCode(null != orgJson.get((Object)"code") ? orgJson.get((Object)"code").toString() : null);
                    tmp.setId(Long.valueOf(orgJson.get((Object)"id").toString()));
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get((Object)"name") ? orgJson.get((Object)"name").toString() : null);
                    tmp.setOrder(Integer.valueOf(null != orgJson.get((Object)"order") ? Integer.valueOf(orgJson.get((Object)"order").toString()) : 9999));
                    tmp.setProviderId(curProviderId);
                    tmp.setUniqSymbol(orgJson.get((Object)"id").toString() + "-" + curProviderId);
                    tmp.setPid(StringUtils.isNotBlank((CharSequence)parentIdOrgId) ? parentIdOrgId : (null != orgJson.get((Object)"parentIdOrgId") ? orgJson.get((Object)"parentIdOrgId").toString() : null));
                    list.add((BaseFieldVO)tmp);
                    break;
                }
                case "2": {
                    OrgVO tmp = new DeptVO();
                    tmp.setVirtual(Boolean.valueOf(null != orgJson.get((Object)"virtual") ? Boolean.valueOf(orgJson.get((Object)"virtual").toString()) : false));
                    tmp.setCode(null != orgJson.get((Object)"code") ? orgJson.get((Object)"code").toString() : null);
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get((Object)"name") ? orgJson.get((Object)"name").toString() : null);
                    tmp.setOrder(Integer.valueOf(null != orgJson.get((Object)"order") ? Integer.valueOf(orgJson.get((Object)"order").toString()) : 9999));
                    tmp.setProviderId(curProviderId);
                    tmp.setId(Long.valueOf(orgJson.get((Object)"id").toString()));
                    tmp.setUniqSymbol(orgJson.get((Object)"id").toString() + "-" + curProviderId);
                    tmp.setOrgId(StringUtils.isNotBlank((CharSequence)parentIdOrgId) ? parentIdOrgId : (null != orgJson.get((Object)"parentIdOrgId") ? orgJson.get((Object)"parentIdOrgId").toString() : null));
                    list.add((BaseFieldVO)tmp);
                    break;
                }
                case "3": {
                    OrgVO tmp = new PostVO();
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get((Object)"name") ? orgJson.get((Object)"name").toString() : null);
                    tmp.setOrder(Integer.valueOf(null != orgJson.get((Object)"order") ? Integer.valueOf(orgJson.get((Object)"order").toString()) : 9999));
                    tmp.setProviderId(curProviderId);
                    tmp.setId(Long.valueOf(orgJson.get((Object)"id").toString()));
                    tmp.setPositionId(orgJson.getString("positionId"));
                    tmp.setPositionName(orgJson.getString("positionName"));
                    tmp.setUniqSymbol(orgJson.get((Object)"id").toString() + "-" + curProviderId);
                    tmp.setOrgId(StringUtils.isNotBlank((CharSequence)parentIdOrgId) ? parentIdOrgId : (null != orgJson.get((Object)"parentIdOrgId") ? orgJson.get((Object)"parentIdOrgId").toString() : null));
                    list.add((BaseFieldVO)tmp);
                    break;
                }
                case "4": {
                    OrgVO tmp = new UserVO();
                    tmp.setType(Integer.valueOf(type));
                    tmp.setName(null != orgJson.get((Object)"name") ? orgJson.get((Object)"name").toString() : null);
                    tmp.setOrder(Integer.valueOf(null != orgJson.get((Object)"order") ? Integer.valueOf(orgJson.get((Object)"order").toString()) : 9999));
                    tmp.setGender(Integer.valueOf(null != orgJson.get((Object)"gender") ? Integer.valueOf(orgJson.get((Object)"gender").toString()) : 1));
                    tmp.setCategory(Integer.valueOf(null != orgJson.get((Object)"category") ? Integer.valueOf(orgJson.get((Object)"category").toString()) : 101301));
                    tmp.setPositionStatus(Integer.valueOf(null != orgJson.get((Object)"positionStatus") ? Integer.valueOf(orgJson.get((Object)"positionStatus").toString()) : 101401));
                    tmp.setProviderId(curProviderId);
                    tmp.setId(Long.valueOf(orgJson.get((Object)"id").toString()));
                    tmp.setMainPosition(Boolean.valueOf(null != orgJson.get((Object)"mainPosition") ? Boolean.valueOf(orgJson.get((Object)"mainPosition").toString()) : false));
                    tmp.setPositionId(orgJson.getString("positionId"));
                    tmp.setPositionName(orgJson.getString("positionName"));
                    tmp.setUniqSymbol(orgJson.get((Object)"id").toString() + "-" + curProviderId);
                    list.add((BaseFieldVO)tmp);
                    break;
                }
            }
        }
    }
}

