/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.poc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.openidclient.openapi.helper.OpenAPIInvokeParameter;
import com.ejianc.framework.openidclient.openapi.service.IZtjOpenApiService;
import com.ejianc.poc.bean.UserAuthParam;
import com.ejianc.poc.controller.OrgController;
import com.ejianc.poc.service.IWorkAuthSubService;
import com.ejianc.poc.vo.BaseFieldVO;
import com.ejianc.poc.vo.OrgVO;
import java.net.URLEncoder;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class ZtjApisService {
    @Autowired
    private IZtjOpenApiService ztjOpenApiService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IWorkAuthSubService subService;

    public JSONArray getAllSecondOrgList() {
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "orglist";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseArray((String)userDetailStr);
        }
        return new JSONArray();
    }

    public JSONObject getSecondOrgInfo(String providerId) {
        if (StringUtils.isEmpty((CharSequence)providerId)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/root";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseObject((String)userDetailStr);
        }
        return new JSONObject();
    }

    public JSONArray getOrgPath(String providerId, String orgid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)orgid)) {
            return new JSONArray();
        }
        if ("root_org_code".equals(providerId)) {
            JSONObject p = new JSONObject();
            p.put("code", (Object)"root_org_code");
            p.put("id", (Object)OrgVO.rootOrgId);
            p.put("providerId", (Object)"root_org_code");
            p.put("fullname", (Object)"\u4e2d\u94c1\u5efa");
            p.put("name", (Object)"\u4e2d\u94c1\u5efa");
            p.put("virtual", (Object)false);
            p.put("show", (Object)true);
            p.put("order", (Object)1);
            p.put("type", (Object)1);
            JSONArray array = new JSONArray();
            array.add((Object)p);
            return array;
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/path/" + orgid;
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseArray((String)userDetailStr);
        }
        return new JSONArray();
    }

    public String getOrgPath(String providerId, String orgid, Boolean contentMyself) {
        JSONArray array = this.getOrgPath(providerId, orgid);
        StringBuffer path = new StringBuffer("");
        int ii = -1;
        if (!contentMyself.booleanValue()) {
            ii = 0;
        }
        for (int i = array.size() - 1; i > ii; --i) {
            JSONObject p = array.getJSONObject(i);
            if (p.get((Object)"virtual") != null && p.getBoolean("virtual").booleanValue()) continue;
            path.append(p.getString("name")).append(" ");
        }
        return path.toString();
    }

    public JSONObject getSureOrg(String providerId, String orgid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)orgid)) {
            return new JSONObject();
        }
        if ("root_org_code".equals(providerId)) {
            JSONObject p = new JSONObject();
            p.put("code", (Object)"root_org_code");
            p.put("id", (Object)OrgVO.rootOrgId);
            p.put("providerId", (Object)"root_org_code");
            p.put("fullname", (Object)"\u4e2d\u94c1\u5efa");
            p.put("name", (Object)"\u4e2d\u94c1\u5efa");
            p.put("virtual", (Object)false);
            p.put("show", (Object)true);
            p.put("order", (Object)1);
            p.put("type", (Object)1);
            return p;
        }
        JSONArray orgPath = this.getOrgPath(providerId, orgid);
        if (orgPath.size() > 0) {
            return orgPath.getJSONObject(0);
        }
        return new JSONObject();
    }

    public JSONObject getOrgParent(String providerId, String orgid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)orgid)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/company/" + orgid + "/parent";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        JSONObject p = null;
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            p = JSONObject.parseObject((String)userDetailStr);
            p.put("providerId", (Object)providerId);
        } else {
            p = new JSONObject();
            p.put("id", (Object)OrgVO.rootOrgId);
            p.put("code", (Object)"root_org_code");
            p.put("providerId", (Object)"root_org_code");
            p.put("name", (Object)"\u4e2d\u94c1\u5efa");
            p.put("fullname", (Object)"\u4e2d\u94c1\u5efa");
            p.put("virtual", (Object)false);
            p.put("show", (Object)true);
            p.put("order", (Object)1);
            p.put("type", (Object)1);
        }
        return p;
    }

    public JSONArray getOrgDirectChildren(String providerId, String orgid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)orgid)) {
            return new JSONArray();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/company/" + orgid + "/children";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseArray((String)userDetailStr);
        }
        return new JSONArray();
    }

    public JSONObject getSureDepartment(String providerId, String deptid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)deptid)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/department/" + deptid;
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseObject((String)userDetailStr);
        }
        return new JSONObject();
    }

    public JSONObject getDepartmentParent(String providerId, String deptid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)deptid)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/department/" + deptid + "/parent";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseObject((String)userDetailStr);
        }
        return new JSONObject();
    }

    public JSONArray getDepartmentDirectChildren(String providerId, String deptid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)deptid)) {
            return new JSONArray();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/department/" + deptid + "/children";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseArray((String)userDetailStr);
        }
        return new JSONArray();
    }

    public JSONObject getPosition(String providerId, String positionId) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)positionId)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/position/" + positionId;
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseObject((String)userDetailStr);
        }
        return new JSONObject();
    }

    public JSONObject getPositionDepartment(String providerId, String positionId) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)positionId)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/position/" + positionId + "/parent";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseObject((String)userDetailStr);
        }
        return new JSONObject();
    }

    public JSONArray getPositionUsers(String providerId, String positionId) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)positionId)) {
            return new JSONArray();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/position/" + positionId + "/users";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseArray((String)userDetailStr);
        }
        return new JSONArray();
    }

    public JSONObject getUser(String providerId, String userid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)userid)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/user/" + userid;
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseObject((String)userDetailStr);
        }
        return new JSONObject();
    }

    public JSONObject getUserMainPosition(String providerId, String userid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)userid)) {
            return new JSONObject();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/user/" + userid + "/mainposition";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseObject((String)userDetailStr);
        }
        return new JSONObject();
    }

    public JSONArray getUserAllPosition(String providerId, String userid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)userid)) {
            return new JSONArray();
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/user/" + userid + "/positions";
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseArray((String)userDetailStr);
        }
        return new JSONArray();
    }

    public JSONArray queryUsers(String providerId, String orgid, String username, Boolean mainPositionOnly) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)orgid)) {
            return new JSONArray();
        }
        if (mainPositionOnly == null) {
            mainPositionOnly = false;
        }
        if (username == null) {
            username = "";
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "org/" + providerId + "/searchuser/" + orgid + "?username=" + URLEncoder.encode(username) + "&mainPositionOnly=" + mainPositionOnly;
        String userDetailStr = this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
        if (StringUtils.isNotEmpty((CharSequence)userDetailStr)) {
            return JSONObject.parseArray((String)userDetailStr);
        }
        return new JSONArray();
    }

    public String queryAllTreeOrg(String providerId, String companyid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)companyid)) {
            return "";
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "tree/" + providerId + "/" + companyid;
        return this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
    }

    public String queryAllTreeOrgAndUsers(String providerId, String companyid) {
        if (StringUtils.isEmpty((CharSequence)providerId) || StringUtils.isEmpty((CharSequence)companyid)) {
            return "";
        }
        OpenAPIInvokeParameter apiInvokeParameter = new OpenAPIInvokeParameter();
        apiInvokeParameter.invoke_method = "GET";
        apiInvokeParameter.apiUrl = "tree/" + providerId + "/" + companyid + "/users";
        return this.ztjOpenApiService.getHrOpenApi(apiInvokeParameter);
    }

    public List<BaseFieldVO> getTreeRootByAppId(String appId, Integer expandLevel) {
        ArrayList<BaseFieldVO> root = new ArrayList<BaseFieldVO>();
        List<UserAuthParam> userAuthParams = this.subService.queryUserAuthList(this.sessionManager.getUserContext().getDeptCode());
        if (ListUtil.isEmpty(userAuthParams)) {
            return root;
        }
        JSONObject authJson = new JSONObject();
        for (UserAuthParam userAuthParam : userAuthParams) {
            authJson.put(userAuthParam.getAuthId(), (Object)(userAuthParam.getOrgIds() + "#" + userAuthParam.getProviderIds()));
        }
        String userAuthJson = authJson.getString(appId);
        if (StringUtils.isEmpty((CharSequence)userAuthJson)) {
            return root;
        }
        String orgIds = userAuthJson.split("#")[0];
        String providerIds = userAuthJson.split("#")[1];
        if (StringUtils.isEmpty((CharSequence)orgIds) || StringUtils.isEmpty((CharSequence)providerIds)) {
            return root;
        }
        boolean contains = false;
        for (String s : orgIds.split(",")) {
            if (!String.valueOf(OrgVO.rootOrgId).equals(s)) continue;
            contains = true;
            break;
        }
        if (contains) {
            root.add((BaseFieldVO)OrgVO.getRootOrg());
            return root;
        }
        String[] orgArr = orgIds.split(",");
        String[] providerArr = providerIds.split(",");
        HashMap<String, List> p_o = new HashMap<String, List>();
        for (int i = 0; i < providerArr.length; ++i) {
            List oList = p_o.computeIfAbsent(providerArr[i], k -> new ArrayList());
            if (oList.contains(orgArr[i])) continue;
            oList.add(orgArr[i]);
        }
        for (String provider : p_o.keySet()) {
            List oList = (List)p_o.get(provider);
            JSONArray data = new JSONArray();
            if (oList.size() == 1) {
                JSONObject sure = this.getSureOrg(provider, (String)oList.get(0));
                data.add((Object)sure);
            } else {
                ArrayList<JSONObject> objectList = new ArrayList<JSONObject>();
                for (String orgId : oList) {
                    objectList.add(this.getSureOrg(provider, orgId));
                }
                objectList.sort((o1, o2) -> {
                    if (o1.getString("code").length() > o2.getString("code").length()) {
                        return 1;
                    }
                    if (o1.getString("code").length() == o2.getString("code").length()) {
                        return 0;
                    }
                    return -1;
                });
                ArrayList<JSONObject> toRemove = new ArrayList<JSONObject>();
                for (int i = 0; i < objectList.size(); ++i) {
                    JSONObject o12 = (JSONObject)objectList.get(i);
                    for (int j = i + 1; j < objectList.size(); ++j) {
                        JSONObject o22 = (JSONObject)objectList.get(j);
                        if (!o22.getString("code").startsWith(o12.getString("code"))) continue;
                        toRemove.add(o22);
                    }
                }
                objectList.removeAll(toRemove);
                data.addAll(objectList);
            }
            block7: for (int i = 0; i < data.size(); ++i) {
                JSONObject o = data.getJSONObject(i);
                JSONArray path = this.getOrgPath(provider, o.getString("id"));
                if (path == null) continue;
                for (int j = 0; j < path.size(); ++j) {
                    JSONObject p = path.getJSONObject(j);
                    if (p.getInteger("type") != 1 || j <= 0) continue;
                    o.put("parentIdOrgId", (Object)p.getString("id"));
                    continue block7;
                }
            }
            OrgController.transToBaseFieldVO(data, root, provider, expandLevel, null);
        }
        return root;
    }

    public List<BaseFieldVO> getLogTreeRoot() {
        ArrayList<BaseFieldVO> root = new ArrayList<BaseFieldVO>();
        List<UserAuthParam> userAuthParams = this.subService.queryUserAuthListManage(this.sessionManager.getUserContext().getDeptCode());
        if (ListUtil.isEmpty(userAuthParams)) {
            return root;
        }
        JSONObject authJson = new JSONObject();
        for (UserAuthParam userAuthParam : userAuthParams) {
            authJson.put(userAuthParam.getAuthId(), (Object)(userAuthParam.getOrgIds() + "#" + userAuthParam.getProviderIds()));
        }
        String userAuthJson = authJson.getString("436574189119602768");
        if (StringUtils.isEmpty((CharSequence)userAuthJson)) {
            return root;
        }
        String orgIds = userAuthJson.split("#")[0];
        String providerIds = userAuthJson.split("#")[1];
        if (StringUtils.isEmpty((CharSequence)orgIds) || StringUtils.isEmpty((CharSequence)providerIds)) {
            return root;
        }
        boolean contains = false;
        for (String s : orgIds.split(",")) {
            if (!String.valueOf(OrgVO.rootOrgId).equals(s)) continue;
            contains = true;
            break;
        }
        if (contains) {
            root.add((BaseFieldVO)OrgVO.getRootOrg());
            return root;
        }
        String[] orgArr = orgIds.split(",");
        String[] providerArr = providerIds.split(",");
        HashMap<String, List> p_o = new HashMap<String, List>();
        for (int i = 0; i < providerArr.length; ++i) {
            List oList = p_o.computeIfAbsent(providerArr[i], k -> new ArrayList());
            if (oList.contains(orgArr[i])) continue;
            oList.add(orgArr[i]);
        }
        for (String provider : p_o.keySet()) {
            List oList = (List)p_o.get(provider);
            JSONArray data = new JSONArray();
            if (oList.size() == 1) {
                JSONObject sure = this.getSureOrg(provider, (String)oList.get(0));
                data.add((Object)sure);
            } else {
                ArrayList<JSONObject> objectList = new ArrayList<JSONObject>();
                for (String orgId : oList) {
                    objectList.add(this.getSureOrg(provider, orgId));
                }
                objectList.sort((o1, o2) -> {
                    if (o1.getString("code").length() > o2.getString("code").length()) {
                        return 1;
                    }
                    if (o1.getString("code").length() == o2.getString("code").length()) {
                        return 0;
                    }
                    return -1;
                });
                ArrayList<JSONObject> toRemove = new ArrayList<JSONObject>();
                for (int i = 0; i < objectList.size(); ++i) {
                    JSONObject o12 = (JSONObject)objectList.get(i);
                    for (int j = i + 1; j < objectList.size(); ++j) {
                        JSONObject o22 = (JSONObject)objectList.get(j);
                        if (!o22.getString("code").startsWith(o12.getString("code"))) continue;
                        toRemove.add(o22);
                    }
                }
                objectList.removeAll(toRemove);
                data.addAll(objectList);
            }
            block7: for (int i = 0; i < data.size(); ++i) {
                JSONObject o = data.getJSONObject(i);
                JSONArray path = this.getOrgPath(provider, o.getString("id"));
                if (path == null) continue;
                for (int j = 0; j < path.size(); ++j) {
                    JSONObject p = path.getJSONObject(j);
                    if (p.getInteger("type") != 1 || j <= 0) continue;
                    o.put("parentIdOrgId", (Object)p.getString("id"));
                    continue block7;
                }
            }
            OrgController.transToBaseFieldVO(data, root, provider, 4, null);
        }
        return root;
    }

    public static void main(String[] args) {
        ArrayList<JSONObject> objectList = new ArrayList<JSONObject>();
        JSONObject o1 = new JSONObject();
        o1.put("code", (Object)"0000100011");
        o1.put("name", (Object)"\u4e2d\u94c1\u5341\u4e00\u5c40");
        objectList.add(o1);
        o1 = new JSONObject();
        o1.put("code", (Object)"0000100012");
        o1.put("name", (Object)"\u4e2d\u94c1\u5341\u4e8c\u5c40");
        objectList.add(o1);
        JSONObject o2 = new JSONObject();
        o2.put("code", (Object)"000010001102");
        o2.put("name", (Object)"\u4e2d\u94c1\u5341\u4e00\u5c40\u96c6\u56e2\u673a\u5173");
        objectList.add(o2);
        JSONObject o3 = new JSONObject();
        o3.put("code", (Object)"0000100018");
        o3.put("name", (Object)"\u4e2d\u94c1\u5341\u516b\u5c40");
        objectList.add(o3);
        o3 = new JSONObject();
        o3.put("code", (Object)"00001000180111");
        o3.put("name", (Object)"\u4e2d\u94c1\u5341\u516b\u5c4000001000180111");
        objectList.add(o3);
        JSONObject o4 = new JSONObject();
        o4.put("code", (Object)"000010001802");
        o4.put("name", (Object)"\u4e2d\u94c1\u5341\u516b\u5c40\u673a\u5173");
        objectList.add(o4);
        o1 = new JSONObject();
        o1.put("code", (Object)"0000100017");
        o1.put("name", (Object)"\u4e2d\u94c1\u5341\u4e03\u5c40");
        objectList.add(o1);
        objectList.sort((o11, o21) -> {
            if (o11.getString("code").length() > o21.getString("code").length()) {
                return 1;
            }
            if (o11.getString("code").length() == o21.getString("code").length()) {
                return 0;
            }
            return -1;
        });
        ArrayList<JSONObject> toRemove = new ArrayList<JSONObject>();
        for (int i = 0; i < objectList.size(); ++i) {
            JSONObject o112 = (JSONObject)objectList.get(i);
            for (int j = i + 1; j < objectList.size(); ++j) {
                JSONObject o22 = (JSONObject)objectList.get(j);
                if (!o22.getString("code").startsWith(o112.getString("code"))) continue;
                toRemove.add(o22);
            }
        }
        objectList.removeAll(toRemove);
        System.out.println(objectList);
    }
}

