package com.ejianc.poc.service.impl;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.framework.skeleton.template.BaseVO;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;

import com.ejianc.poc.mapper.WorkAuthMapper;
import com.ejianc.poc.bean.WorkAuthEntity;
import com.ejianc.poc.service.IWorkAuthService;

import java.util.List;

/**
 * 工作授权表
 * 
 * @author generator
 * 
 */
@Service("workAuthService")
public class WorkAuthServiceImpl extends BaseServiceImpl<WorkAuthMapper, WorkAuthEntity> implements IWorkAuthService{

    @Autowired
    private WorkAuthMapper workAuthMapper;

    @Override
    public List<WorkAuthEntity> queryAllAuthOrgList(String orgId, String providerId) {
        QueryWrapper<WorkAuthEntity> query = new QueryWrapper<>();
        query.eq("dr", BaseVO.DR_UNDELETE);
        if(StringUtils.isNotBlank(orgId)) {
            query.eq("corp_pk", orgId);
            query.eq("corp_provider_id", providerId);
        }

        return workAuthMapper.selectList(query);
    }

    /**
     * 查询人员存在工作授权管理权限的授权列表
     * corpCode  选中的节点
     * ids  包含userId和岗位id的字符串集合
     *
     * @param corpCode
     * @param ids
     */
    @Override
    public List<WorkAuthEntity> queryUserAuthList(String corpCode, String ids) {
        return workAuthMapper.queryUserAuthList(corpCode,ids);
    }
}
