/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.mapper.ConstructionSchemeMapper;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.util.EJCDateUtil;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.vo.ConstructionSchemeImportVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="constructionSchemeService")
public class ConstructionSchemeServiceImpl
extends BaseServiceImpl<ConstructionSchemeMapper, ConstructionSchemeEntity>
implements IConstructionSchemeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConstructionSchemeMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IConSchemePlanService conSchemePlanService;

    @Override
    public CommonResponse<JSONObject> excelConstructionSchemeImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        ArrayList<ConstructionSchemeImportVO> successList = new ArrayList<ConstructionSchemeImportVO>();
        ArrayList<ConstructionSchemeImportVO> errorList = new ArrayList<ConstructionSchemeImportVO>();
        ArrayList rtErrorList = new ArrayList();
        boolean isFailed = false;
        for (Map.Entry entry : fileMap.entrySet()) {
            mf = (MultipartFile)entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u65bd\u5de5\u65b9\u6848\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            CommonResponse ctSpecialtyType = this.iDefdocApi.getDefDocByDefCode("ct_specialty_type");
            CommonResponse ctConsSchemeType = this.iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
            CommonResponse ctProjectManageType = this.iDefdocApi.getDefDocByDefCode("ct_project_manage_type");
            for (int i = 0; i < result.size(); ++i) {
                String finishConsSchemeDateStr;
                String projectManageTypeName;
                ConstructionSchemeImportVO vo;
                StringBuilder errorMessage;
                List datas;
                boolean flag;
                block64: {
                    String consTimeFrameStr;
                    String orgExpertExamine;
                    String consSchemeTypeName;
                    String specialtyTypeName;
                    List<String> consTimeFrameList;
                    flag = true;
                    datas = (List)result.get(i);
                    errorMessage = new StringBuilder("");
                    vo = new ConstructionSchemeImportVO();
                    vo.setId(IdWorker.getId());
                    String projectName = (String)datas.get(0);
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (StringUtils.isBlank((CharSequence)projectName) || MapUtils.isEmpty((Map)projectNameMap)) {
                        errorMessage.append("[\u5de5\u7a0b\u540d\u79f0]").append(projectName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        vo.setProjectName((String)projectNameMap.get("name"));
                        vo.setProjectCode((String)projectNameMap.get("code"));
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            vo.setProjectId(Long.parseLong((String)id));
                        } else {
                            vo.setProjectId((Long)id);
                        }
                        Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                        if (engineeringTypeId instanceof String) {
                            vo.setEngineeringTypeId(Long.parseLong((String)engineeringTypeId));
                        } else {
                            vo.setEngineeringTypeId((Long)engineeringTypeId);
                        }
                        Object projectLeave = projectNameMap.get("project_rank");
                        if (projectLeave instanceof String) {
                            vo.setProjectLeave(Long.parseLong((String)projectLeave));
                        } else {
                            vo.setProjectLeave((Long)projectLeave);
                        }
                    }
                    String consSchemeIdName = (String)datas.get(1);
                    ConSchemePlanEntity conSchemePlanEntity = (ConSchemePlanEntity)((Object)this.conSchemePlanService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ConSchemePlanEntity::getProjectId, (Object)vo.getProjectId())).eq(ConSchemePlanEntity::getConsSchemeName, (Object)consSchemeIdName)).eq(BaseEntity::getDr, (Object)0)).last(" LIMIT 1 ")));
                    if (conSchemePlanEntity == null) {
                        errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355]" + consSchemeIdName + ":\u672a\u627e\u5230");
                        flag = false;
                    } else {
                        Date planRedactDate = conSchemePlanEntity.getPlanRedactDate();
                        Date redactFinishDate = conSchemePlanEntity.getRedactFinishDate();
                        Long specialtyType = conSchemePlanEntity.getSpecialtyType();
                        Long consSchemeType = conSchemePlanEntity.getConsSchemeType();
                        String orgExpertExamine2 = conSchemePlanEntity.getOrgExpertExamine();
                        String consTimeFrame = conSchemePlanEntity.getConsTimeFrame();
                        Long projectTrait = conSchemePlanEntity.getProjectTrait();
                        String keyPointExplain = conSchemePlanEntity.getKeyPointExplain();
                        Date finishConsSchemeDate = conSchemePlanEntity.getFinishConsSchemeDate();
                        vo.setConsSchemeId(conSchemePlanEntity.getId());
                        vo.setPlanRedactDate(planRedactDate);
                        vo.setRedactFinishDate(redactFinishDate);
                        vo.setSpecialtyType(specialtyType);
                        vo.setConsSchemeType(consSchemeType);
                        vo.setOrgExpertExamine(orgExpertExamine2);
                        vo.setProjectTrait(projectTrait);
                        vo.setKeyPointExplain(keyPointExplain);
                        vo.setFinishConsSchemeDate(finishConsSchemeDate);
                        if (ToolUtil.isNotEmpty(consTimeFrame)) {
                            try {
                                consTimeFrameList = Arrays.asList(consTimeFrame.split("~"));
                                DateUtils.parseDate((String)consTimeFrameList.get(0), (String[])new String[]{"yyyy-MM-dd"});
                                DateUtils.parseDate((String)consTimeFrameList.get(1), (String[])new String[]{"yyyy-MM-dd"});
                                vo.setConsTimeFrame(consTimeFrame);
                                vo.setConsTimeFrameList(consTimeFrameList);
                            }
                            catch (Exception e3) {
                                errorMessage.append(consTimeFrame + "\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
                                flag = false;
                                this.logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
                            }
                        }
                    }
                    String consSchemeName = (String)datas.get(2);
                    if (ToolUtil.isEmpty(consSchemeName)) {
                        errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u540d\u79f0]").append("\u4e3a\u7a7a;");
                        flag = false;
                    } else {
                        vo.setConsSchemeName(consSchemeName);
                    }
                    String code = (String)datas.get(3);
                    if (ToolUtil.isNotEmpty(code)) {
                        vo.setCode(code);
                    } else {
                        errorMessage.append("[\u6587\u4ef6\u7f16\u7801]\u4e3a\u7a7a;");
                        flag = false;
                    }
                    String outsideCode = (String)datas.get(4);
                    if (ToolUtil.isNotEmpty(outsideCode)) {
                        vo.setOutsideCode(outsideCode);
                    }
                    String fileVersion = (String)datas.get(5);
                    vo.setFileVersion(fileVersion);
                    String planRedactDateStr = (String)datas.get(6);
                    if (ToolUtil.isNotEmpty(planRedactDateStr)) {
                        Date parse = EJCDateUtil.parseDate(planRedactDateStr, "yyyy-MM-dd");
                        if (ToolUtil.isNotEmpty(parse)) {
                            vo.setPlanRedactDate(parse);
                        } else {
                            errorMessage.append("[\u8ba1\u5212\u7f16\u5236\u65f6\u95f4]" + planRedactDateStr + ":\u683c\u5f0f\u9519\u8bef");
                            flag = false;
                        }
                    }
                    if (ToolUtil.isEmpty(specialtyTypeName = (String)datas.get(7))) {
                        if (ToolUtil.isEmpty(vo.getSpecialtyType())) {
                            errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]\u4e3a\u7a7a;");
                            flag = false;
                        }
                    } else if (!ctSpecialtyType.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)ctSpecialtyType.getData()))) {
                        errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]").append(specialtyTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        Long defdocDetailId = ((List)ctSpecialtyType.getData()).stream().filter(a -> specialtyTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                        if (defdocDetailId == null) {
                            errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]:\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u7167;");
                            flag = false;
                        } else {
                            vo.setSpecialtyType(defdocDetailId);
                        }
                    }
                    if (ToolUtil.isEmpty(consSchemeTypeName = (String)datas.get(8))) {
                        if (ToolUtil.isEmpty(vo.getConsSchemeType())) {
                            errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]\u4e3a\u7a7a;");
                            flag = false;
                        }
                    } else if (!ctConsSchemeType.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)ctConsSchemeType.getData()))) {
                        errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]").append(consSchemeTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        Long defdocDetailId = ((List)ctConsSchemeType.getData()).stream().filter(a -> consSchemeTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                        if (defdocDetailId == null) {
                            errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]:\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u7167;");
                            flag = false;
                        } else {
                            vo.setConsSchemeType(defdocDetailId);
                        }
                    }
                    if (ToolUtil.isNotEmpty(orgExpertExamine = (String)datas.get(9))) {
                        if ("\u662f".equals(orgExpertExamine)) {
                            vo.setOrgExpertExamine("Y");
                        } else if ("\u5426".equals(orgExpertExamine)) {
                            vo.setOrgExpertExamine("N");
                        } else {
                            errorMessage.append("[\u7ec4\u7ec7\u4e13\u5bb6\u5ba1\u67e5\u8981\u6c42]:\u683c\u5f0f\u9519\u8bef;");
                            flag = false;
                        }
                    }
                    if (ToolUtil.isEmpty(consTimeFrameStr = (String)datas.get(10))) {
                        if (ToolUtil.isEmpty(vo.getConsTimeFrame())) {
                            errorMessage.append("[\u65bd\u5de5\u65f6\u6bb5]\u4e3a\u7a7a;");
                            flag = false;
                        }
                    } else {
                        try {
                            consTimeFrameList = Arrays.asList(consTimeFrameStr.split("~"));
                            DateUtils.parseDate((String)consTimeFrameList.get(0), (String[])new String[]{"yyyy-MM-dd"});
                            DateUtils.parseDate((String)consTimeFrameList.get(1), (String[])new String[]{"yyyy-MM-dd"});
                            vo.setConsTimeFrame(consTimeFrameStr);
                            vo.setConsTimeFrameList(consTimeFrameList);
                        }
                        catch (Exception e4) {
                            errorMessage.append("[\u65bd\u5de5\u65f6\u6bb5]\u65e5\u671f\u683c\u5f0f\u9519\u8bef;");
                            flag = false;
                            if (!this.logger.isErrorEnabled()) break block64;
                            this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355 \u5bfc\u5165-\u6821\u9a8c\u6570\u636e \u5931\u8d25\uff01\u7f16\u5236\u5b8c\u6210\u65f6\u95f4\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                        }
                    }
                }
                if (ToolUtil.isEmpty(projectManageTypeName = (String)datas.get(11))) {
                    if (ToolUtil.isEmpty(vo.getConsSchemeType())) {
                        errorMessage.append("[\u9879\u76ee\u7ba1\u7406\u5206\u7c7b]\u4e3a\u7a7a;");
                        flag = false;
                    }
                } else if (!ctProjectManageType.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)ctProjectManageType.getData()))) {
                    errorMessage.append("[\u9879\u76ee\u7ba1\u7406\u5206\u7c7b]").append(projectManageTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)ctProjectManageType.getData()).stream().filter(a -> projectManageTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    if (defdocDetailId == null) {
                        errorMessage.append("[\u9879\u76ee\u7ba1\u7406\u5206\u7c7b]:\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u7167;");
                        flag = false;
                    } else {
                        vo.setProjectManageType(defdocDetailId);
                    }
                }
                if (ToolUtil.isNotEmpty(finishConsSchemeDateStr = (String)datas.get(12))) {
                    Date parse = EJCDateUtil.parseDate(finishConsSchemeDateStr, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        vo.setFinishConsSchemeDate(parse);
                    } else {
                        errorMessage.append("[\u5b8c\u6210\u65bd\u5de5\u65b9\u6848\u65f6\u95f4]" + finishConsSchemeDateStr + ":\u683c\u5f0f\u9519\u8bef");
                        flag = false;
                    }
                }
                vo.setRowIndex(i + 2);
                Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(vo.getProjectId()));
                CommonResponse orgVO = this.iOrgApi.getOneById((Long)stringStringMap.get("orgId"));
                if (!orgVO.isSuccess()) {
                    errorMessage.append("[\u9879\u76ee\u65e0\u5bf9\u5e94\u7ec4\u7ec7]");
                }
                vo.setOrgId((Long)stringStringMap.get("orgId"));
                vo.setOrgCode(((OrgVO)orgVO.getData()).getCode());
                vo.setOrgName(((OrgVO)orgVO.getData()).getName());
                vo.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                vo.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                vo.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                if (flag) {
                    successList.add(vo);
                    continue;
                }
                vo.setErrorMessage(errorMessage.toString());
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(ConstructionSchemeImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success((Object)json);
    }
}

