/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.DrawingCheckEntity;
import com.ejianc.ztpc.mapper.DrawingCheckMapper;
import com.ejianc.ztpc.service.IDrawingCheckService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.vo.DrawingCheckImportVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import java.util.ArrayList;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="drawingCheckService")
public class DrawingCheckServiceImpl
extends BaseServiceImpl<DrawingCheckMapper, DrawingCheckEntity>
implements IDrawingCheckService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DrawingCheckMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;

    @Override
    public CommonResponse<JSONObject> excelDrawingCheckImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<DrawingCheckImportVO> successList = new ArrayList<DrawingCheckImportVO>();
        ArrayList<DrawingCheckImportVO> errorList = new ArrayList<DrawingCheckImportVO>();
        HashMap<String, String> dictionaryQueryMap = new HashMap<String, String>();
        List employeeList = Lists.newArrayList();
        CommonResponse employeeResponse = this.iExternalApi.getMapAllEmployee();
        if (employeeResponse.isSuccess() && ListUtil.isNotEmpty((List)((List)employeeResponse.getData()))) {
            employeeList = (List)employeeResponse.getData();
        }
        Map employee = employeeList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5bfc\u5165\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            for (int i = 0; i < result.size(); ++i) {
                String constructionOpinion;
                String jointTrialTypeName;
                String specialtyName;
                String sysName;
                DrawingCheckImportVO vo;
                StringBuilder errorMessage;
                List datas;
                boolean flag;
                block47: {
                    String jointTrialCode;
                    flag = true;
                    datas = (List)result.get(i);
                    errorMessage = new StringBuilder("");
                    vo = new DrawingCheckImportVO();
                    vo.setId(IdWorker.getId());
                    String projectName = (String)datas.get(0);
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (StringUtils.isBlank((CharSequence)projectName) || MapUtils.isEmpty((Map)projectNameMap)) {
                        errorMessage.append("[\u9879\u76ee\u540d\u79f0]").append(projectName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        vo.setProjectName((String)projectNameMap.get("name"));
                        vo.setProjectCode((String)projectNameMap.get("code"));
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            vo.setProjectId(Long.parseLong((String)id));
                        } else {
                            vo.setProjectId((Long)id);
                        }
                    }
                    String compere = (String)datas.get(1);
                    if (ToolUtil.isNotEmpty(compere)) {
                        Map stringObjectMap = (Map)employee.get(compere);
                        if (stringObjectMap == null) {
                            errorMessage.append("[\u4e3b\u6301\u4eba]" + compere + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            try {
                                vo.setCompere(Long.parseLong(stringObjectMap.get("id").toString()));
                            }
                            catch (Exception e3) {
                                this.logger.info(e3.getMessage() + ";" + stringObjectMap.toString() + ";");
                                errorMessage.append("[\u4e3b\u6301\u4eba]" + compere + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                                flag = false;
                            }
                        }
                    }
                    if (StringUtils.isBlank((CharSequence)(jointTrialCode = (String)datas.get(2)))) {
                        errorMessage.append("[\u4f1a\u5ba1\u7f16\u7801]\u4e3a\u7a7a;");
                        flag = false;
                    } else {
                        vo.setJointTrialCode(jointTrialCode);
                    }
                    String jointTrialPlace = (String)datas.get(3);
                    if (StringUtils.isBlank((CharSequence)jointTrialPlace)) {
                        errorMessage.append("[\u4f1a\u5ba1\u5730\u70b9]\u4e3a\u7a7a;");
                        flag = false;
                    } else {
                        vo.setJointTrialPlace(jointTrialPlace);
                    }
                    String jointTrialDate = (String)datas.get(4);
                    if (StringUtils.isBlank((CharSequence)jointTrialDate)) {
                        errorMessage.append("[\u4f1a\u5ba1\u65e5\u671f]\u4e3a\u7a7a;");
                        flag = false;
                    } else {
                        try {
                            vo.setJointTrialDate(DateUtils.parseDate((String)jointTrialDate, (String[])new String[]{"yyyy-MM-dd"}));
                        }
                        catch (Exception e4) {
                            errorMessage.append("[\u4f1a\u5ba1\u65e5\u671f]\u65e5\u671f\u683c\u5f0f\u9519\u8bef;");
                            flag = false;
                            if (!this.logger.isErrorEnabled()) break block47;
                            this.logger.error("\u56fe\u7eb8\u4f1a\u8868 \u5bfc\u5165-\u6821\u9a8c\u6570\u636e \u5931\u8d25\uff01\u4f1a\u5ba1\u65e5\u671f\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                        }
                    }
                }
                String mgrpName = (String)datas.get(7);
                if (ToolUtil.isNotEmpty(mgrpName)) {
                    List data;
                    dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "mgrp");
                    CommonResponse mgrpCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (mgrpCommonResponse.isSuccess() && (data = (List)mgrpCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u673a\u7ec4]").append(mgrpName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            vo.setMgrp(dataDictionaryVO.getId());
                        }
                    }
                }
                if (ToolUtil.isNotEmpty(sysName = (String)datas.get(7))) {
                    List data;
                    dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "sys");
                    CommonResponse sysCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (sysCommonResponse.isSuccess() && (data = (List)sysCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> sysName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u7cfb\u7edf]").append(sysName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            vo.setSys(dataDictionaryVO.getId());
                        }
                    }
                }
                if (ToolUtil.isNotEmpty(specialtyName = (String)datas.get(7))) {
                    List data;
                    dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "specialty");
                    CommonResponse specialtyCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (specialtyCommonResponse.isSuccess() && (data = (List)specialtyCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> specialtyName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u4e13\u4e1a]").append(specialtyName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            vo.setSpecialty(dataDictionaryVO.getId());
                        }
                    }
                }
                if (ToolUtil.isNotEmpty(jointTrialTypeName = (String)datas.get(7))) {
                    List data;
                    dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "ct_joint_trial_type");
                    CommonResponse jointTrialTypeCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (jointTrialTypeCommonResponse.isSuccess() && (data = (List)jointTrialTypeCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> jointTrialTypeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u4f1a\u5ba1\u7c7b\u522b]").append(jointTrialTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            vo.setJointTrialType(dataDictionaryVO.getId());
                        }
                    }
                }
                if (StringUtils.isBlank((CharSequence)(constructionOpinion = (String)datas.get(9)))) {
                    errorMessage.append("[\u65bd\u5de5\u56fe\u7eb8\u4f1a\u5ba1\u610f\u89c1]\u4e3a\u7a7a;");
                    flag = false;
                } else {
                    vo.setConstructionOpinion(constructionOpinion);
                }
                String jointTrialOpinion = (String)datas.get(10);
                if (StringUtils.isBlank((CharSequence)jointTrialOpinion)) {
                    errorMessage.append("[\u4f1a\u5ba1\u610f\u89c1\u95ed\u73af]\u4e3a\u7a7a;");
                    flag = false;
                } else {
                    vo.setJointTrialOpinion(jointTrialOpinion);
                }
                vo.setRowIndex(i + 2);
                Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(vo.getProjectId()));
                CommonResponse orgVO = this.iOrgApi.getOneById((Long)stringStringMap.get("orgId"));
                if (!orgVO.isSuccess()) {
                    errorMessage.append("[\u9879\u76ee\u65e0\u5bf9\u5e94\u7ec4\u7ec7]");
                }
                vo.setOrgId((Long)stringStringMap.get("orgId"));
                vo.setOrgCode(((OrgVO)orgVO.getData()).getCode());
                vo.setOrgName(((OrgVO)orgVO.getData()).getName());
                vo.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                vo.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                vo.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                if (flag) {
                    successList.add(vo);
                    continue;
                }
                vo.setErrorMessage(errorMessage.toString());
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(DrawingCheckImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success((Object)json);
    }
}

