package com.ejianc.ztpc.controller;

import java.io.Serializable;

import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.BillcodeRuleSnEntity;
import com.ejianc.ztpc.service.IBillcodeRuleAttrService;
import com.ejianc.ztpc.service.IBillcodeRuleSnService;
import com.ejianc.ztpc.vo.BillcodeRuleAttrVO;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

import java.util.*;
import java.util.stream.Collectors;
import com.alibaba.fastjson.JSONObject;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.apache.commons.collections.CollectionUtils;
import javax.servlet.http.HttpServletResponse;

import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.framework.core.response.CommonResponse;
import org.springframework.beans.factory.annotation.Autowired;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;

import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;

import com.ejianc.ztpc.bean.BillcodeRuleEntity;
import com.ejianc.ztpc.service.IBillcodeRuleService;
import com.ejianc.ztpc.vo.BillcodeRuleVO;

/**
 * 取号编码规则
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("billcodeRule")
public class BillcodeRuleController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "BILLCODERULE";//此处需要根据实际修改

    @Autowired
    private IBillcodeRuleService service;
    @Autowired
    private IBillcodeRuleSnService billcodeRuleSnService;
    @Autowired
    private IBillcodeRuleAttrService billcodeRuleAttrService;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<BillcodeRuleVO> saveOrUpdate(@RequestBody BillcodeRuleVO saveOrUpdateVO) {
        //数据校验
        List<BillcodeRuleAttrVO> billCodeRuleAttrList = saveOrUpdateVO.getBillcodeRuleAttrList().stream().filter(o -> !"del".equals(o.getRowState())).collect(Collectors.toList());
        Integer startNum = 0;
        if(billCodeRuleAttrList != null && billCodeRuleAttrList.size() > 0){
            for (BillcodeRuleAttrVO billCodeRuleAttrVO : billCodeRuleAttrList) {
                if("rule06".equals(billCodeRuleAttrVO.getRuleElemCode())){
                    if(billCodeRuleAttrVO.getElemLength() == null){
                        return CommonResponse.error("子表【编码规则子元素】序列号必须设置元素长度！");
                    }
                    if(billCodeRuleAttrVO.getStartNum() == null){
                        return CommonResponse.error("子表【编码规则子元素】序列号必须设置流水起始号！");
                    }else{
                        startNum = billCodeRuleAttrVO.getStartNum();
                    }
                }
            }
        }else{
            return CommonResponse.error("子表【编码规则子元素】不能为空！");
        }
        //生成单据编码规则
        BillcodeRuleEntity entity = BeanMapper.map(saveOrUpdateVO, BillcodeRuleEntity.class);
        if(entity.getId() == null || entity.getId() == 0){
            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE, InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
            if(billCode.isSuccess()) {
                entity.setId(IdWorker.getId());
                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
            }else{
                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
            }
        }

        //保存流水号
        QueryWrapper<BillcodeRuleSnEntity> SnQuery1 = new QueryWrapper<>();
        SnQuery1.eq("rule_id", entity.getId());
        SnQuery1.eq("is_init", "1");

        BillcodeRuleSnEntity snServiceOne = billcodeRuleSnService.getOne(SnQuery1, false);
        if(snServiceOne != null ){
            return CommonResponse.error("该取号规则已被单据引用，不允许修改！");
        }else{
            //保存
            service.saveOrUpdate(entity, false);
            BillcodeRuleVO vo = BeanMapper.map(entity, BillcodeRuleVO.class);
            //没有被引用，新增或更新
            QueryWrapper<BillcodeRuleSnEntity> SnQuery2 = new QueryWrapper<>();
            SnQuery2.eq("rule_id", entity.getId());
            SnQuery2.eq("is_init", "0");
            BillcodeRuleSnEntity snInitOne = billcodeRuleSnService.getOne(SnQuery2, false);
            if(snInitOne == null){
                //不存在初始化的数据则新增
                snInitOne = new BillcodeRuleSnEntity();
                snInitOne.setRuleId(entity.getId());
                snInitOne.setIsInit("0");
                snInitOne.setStartSn(startNum);
            }else{
                snInitOne.setStartSn(startNum);
            }
            billcodeRuleSnService.saveOrUpdate(snInitOne);
            return CommonResponse.success("保存或修改单据成功！",vo);
        }
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<BillcodeRuleVO> queryDetail(Long id) {
    	BillcodeRuleEntity entity = service.selectById(id);
    	BillcodeRuleVO vo = BeanMapper.map(entity, BillcodeRuleVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<BillcodeRuleVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (BillcodeRuleVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        List<Long> idList = vos.stream().map(BillcodeRuleVO::getId).collect(Collectors.toList());
        QueryWrapper<BillcodeRuleSnEntity> SNQuery1 = new QueryWrapper<>();
        SNQuery1.eq("is_init", "1");
        SNQuery1.in("rule_id", idList);
//        int count = billCodeRuleSNService.count();
        int count = billcodeRuleSnService.count(SNQuery1);
        if(count > 0){
            return CommonResponse.error("取号规则已被单据引用，不允许删除！");
        }else{
            service.removeByIds(idList,true);
            return CommonResponse.success("删除成功！");
        }
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<BillcodeRuleVO>> queryList(@RequestBody QueryParam param) {

        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));

        /** 数据隔离 本下 没有组织orgId的删除下面代码-------------开始 */
        UserContext userContextCache =sessionManager.getUserContext();
        //当前应用有权限的根orgId，以逗号分割，可据此查询其本下数据，需判空
        String authOrgIds = userContextCache.getAuthOrgIds();
        List<OrgVO> orgVOList = null;
        if(StringUtils.isNotBlank(authOrgIds)){//移动端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "查询失败，获取当前本下组织信息失败。");
        }else {//pc端查询
            orgVOList = (List<OrgVO>) getRespData(iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "查询失败，获取当前本下组织信息失败。");
        }
        //普通组织 id
        List<Long> commonOrgIds = new ArrayList<>();
        //项目部 id
        List<Long> departmentIds = new ArrayList<>();
        orgVOList.stream().forEach(org -> {
            if(5 == org.getOrgType()) {
                //项目部
                departmentIds.add(org.getId());
            } else {
                //普通组织
                commonOrgIds.add(org.getId());
            }
        });
        if(CollectionUtils.isNotEmpty(commonOrgIds)) {
            /** 要求主表有orgId字段，保存单据所属组织 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, commonOrgIds));
        } else if(CollectionUtils.isNotEmpty(departmentIds)) {
            /** 要求主表有projectDepartmentId字段，保存单据所属项目部 */
            param.getParams().put("orgId", new Parameter(QueryParam.IN, departmentIds));
        }
        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<BillcodeRuleEntity> page = service.queryPage(param,false);
        IPage<BillcodeRuleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillcodeRuleVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<BillcodeRuleEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("BillcodeRule-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refBillcodeRuleData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<BillcodeRuleVO>> refBillcodeRuleData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<BillcodeRuleEntity> page = service.queryPage(param,false);
        IPage<BillcodeRuleVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), BillcodeRuleVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }
}
