/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.controller;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.BillCodeParam;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import com.ejianc.framework.core.util.ImportTemplate;
import com.ejianc.framework.skeleton.refer.util.ReferObjectUtil;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.BillcodeCategoryEntity;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.GreatDangerProjectEntity;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.enumUtils.FlowStateEnum;
import com.ejianc.ztpc.enumUtils.SchemeStateEnum;
import com.ejianc.ztpc.mapper.OpinionInfoMapper;
import com.ejianc.ztpc.service.IBillcodeCategoryService;
import com.ejianc.ztpc.service.IBillcodeRuleSnService;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.service.IGreatDangerProjectService;
import com.ejianc.ztpc.vo.BillcodeApiVO;
import com.ejianc.ztpc.vo.BillcodeRuleSnVO;
import com.ejianc.ztpc.vo.ConstructionSchemeImportVO;
import com.ejianc.ztpc.vo.ConstructionSchemeVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import com.google.common.collect.Lists;
import java.io.Serializable;
import java.text.ParseException;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.Objects;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateFormatUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.PostMapping;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"constructionScheme"})
public class ConstructionSchemeController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;
    @Autowired
    private IExternalApi iExternalApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IConstructionSchemeService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IConSchemePlanService conSchemePlanService;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private IGreatDangerProjectService greatDangerProjectService;
    @Autowired
    private OpinionInfoMapper opinionInfoMapper;
    @Autowired
    private IBillcodeCategoryService billcodeCategoryService;
    @Autowired
    private IBillcodeRuleSnService billcodeRuleSnService;
    @Autowired
    private IDefdocApi iDefdocApi;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<ConstructionSchemeVO> saveOrUpdate(@RequestBody ConstructionSchemeVO saveOrUpdateVO) {
        ConSchemePlanEntity conOrgDesignPlanEntity = (ConSchemePlanEntity)((Object)this.conSchemePlanService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)saveOrUpdateVO.getConsSchemeId())).eq(ConSchemePlanEntity::getExecuteState, (Object)ConOrgDesignStateEnum.THREE.getCode())).last("LIMIT 1")));
        if (Objects.nonNull((Object)conOrgDesignPlanEntity)) {
            return CommonResponse.error((String)"\u8be5\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u5df2\u4f7f\u7528\uff01");
        }
        if (CollectionUtils.isNotEmpty(saveOrUpdateVO.getConsTimeFrameList())) {
            saveOrUpdateVO.setConsTimeFrame(saveOrUpdateVO.getConsTimeFrameList().get(0) + "~" + saveOrUpdateVO.getConsTimeFrameList().get(1));
        }
        Date redactFinishDate = new Date();
        saveOrUpdateVO.setRedactFinishDate(redactFinishDate);
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), ConstructionSchemeEntity.class));
        if (entity.getId() == null || entity.getId() == 0L) {
            BillCodeParam billCodeParam = BillCodeParam.build((String)BILL_CODE, (Long)InvocationInfoProxy.getTenantid(), (BaseVO)saveOrUpdateVO);
            CommonResponse billCode = this.billCodeApi.generateBillCode(billCodeParam);
            if (billCode.isSuccess()) {
                entity.setCode((String)billCode.getData());
            } else {
                throw new BusinessException("\u7f51\u7edc\u5f02\u5e38\uff0c \u7f16\u7801\u751f\u6210\u5931\u8d25\uff0c \u8bf7\u7a0d\u540e\u518d\u8bd5");
            }
        }
        boolean sign = false;
        List<OpinionInfoEntity> opinionInfoList = entity.getOpinionInfoList();
        entity.setOpinionInfoList(null);
        if (saveOrUpdateVO.isWhetherUpdate()) {
            if (entity.getId() != null && entity.getId() != 0L) {
                sign = this.service.updateById((Object)entity);
            } else {
                entity.setFlowState(FlowStateEnum.ZERO.getCode());
                entity.setFlowStateName(FlowStateEnum.ZERO.getName());
                BillcodeApiVO billcodeApi = this.getBillcodeApi(saveOrUpdateVO);
                Iterator<OpinionInfoEntity> billcodeApiVOCommonResponse = null;
                if (billcodeApi != null) {
                    try {
                        billcodeApiVOCommonResponse = this.billcodeRuleSnService.generateBillcode(billcodeApi);
                        if (billcodeApiVOCommonResponse.isSuccess()) {
                            List<BillcodeRuleSnVO> snList = ((BillcodeApiVO)billcodeApiVOCommonResponse.getData()).getSnList();
                            for (BillcodeRuleSnVO codeSnVO : snList) {
                                entity.setOutsideCode(codeSnVO.getGenerateBillCode());
                            }
                        }
                    }
                    catch (Exception e) {
                        this.logger.info(e.getMessage());
                    }
                }
                if (billcodeApiVOCommonResponse != null && (billcodeApiVOCommonResponse.getCode() == 999 || billcodeApiVOCommonResponse.isSuccess())) {
                    sign = this.service.save((Object)entity);
                    if (sign && billcodeApiVOCommonResponse.isSuccess()) {
                        BillcodeApiVO responseData = (BillcodeApiVO)billcodeApiVOCommonResponse.getData();
                        this.billcodeRuleSnService.commitBillcode(responseData);
                    }
                } else {
                    if (billcodeApiVOCommonResponse == null) {
                        return CommonResponse.error((String)"\u53d6\u53f7\u5931\u8d25");
                    }
                    return CommonResponse.error((String)("\u53d6\u53f7\u5931\u8d25:" + billcodeApiVOCommonResponse.getMsg()));
                }
            }
        }
        Long userid = InvocationInfoProxy.getUserid();
        for (OpinionInfoEntity opinionInfo : opinionInfoList) {
            Long proposeUserId = opinionInfo.getProposeUserId();
            opinionInfo.setPid(entity.getId());
            if (userid == null || !userid.equals(proposeUserId)) continue;
            if (opinionInfo.getId() != null && opinionInfo.getId() != 0L) {
                if (opinionInfo.getDr() != null && opinionInfo.getDr() == 1) {
                    this.opinionInfoMapper.deleteById(opinionInfo.getId());
                    continue;
                }
                this.opinionInfoMapper.updateById((Object)opinionInfo);
                continue;
            }
            this.opinionInfoMapper.insert((Object)opinionInfo);
        }
        List collect = opinionInfoList.stream().filter(item -> (long)item.getDr().intValue() == 0L).collect(Collectors.toList());
        collect.stream().map(a -> {
            a.setRowState(null);
            return a;
        }).collect(Collectors.toList());
        opinionInfoList = collect;
        if (sign) {
            this.conSchemePlanService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(ConSchemePlanEntity::getRedactFinishDate, (Object)redactFinishDate)).eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)entity.getConsSchemeId()));
        }
        if (opinionInfoList.size() == 0) {
            this.service.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(ConstructionSchemeEntity::getOpinionFlag, (Object)0)).eq(BaseEntity::getId, (Object)entity.getId()));
        } else {
            this.service.update((Wrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(ConstructionSchemeEntity::getOpinionFlag, (Object)1)).eq(BaseEntity::getId, (Object)entity.getId()));
        }
        entity.setOpinionInfoList(opinionInfoList);
        ConstructionSchemeVO vo = (ConstructionSchemeVO)((Object)BeanMapper.map((Object)((Object)entity), ConstructionSchemeVO.class));
        if (StringUtils.isNotBlank((CharSequence)vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    public BillcodeApiVO getBillcodeApi(ConstructionSchemeVO vo) {
        BillcodeApiVO billcodeApiVO = new BillcodeApiVO();
        billcodeApiVO.setProjectId(vo.getProjectId());
        billcodeApiVO.setProjectCode(vo.getProjectCode());
        billcodeApiVO.setProjectName(vo.getProjectName());
        BillcodeCategoryEntity ctConstructionScheme = (BillcodeCategoryEntity)((Object)this.billcodeCategoryService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(BillcodeCategoryEntity::getEnableStatus, (Object)1)).eq(BillcodeCategoryEntity::getCode, (Object)"ct_construction_scheme")));
        if (ctConstructionScheme == null) {
            return null;
        }
        billcodeApiVO.setCategoryId(ctConstructionScheme.getId());
        ArrayList<BillcodeRuleSnVO> snVOList = new ArrayList<BillcodeRuleSnVO>();
        billcodeApiVO.setSnList(snVOList);
        BillcodeRuleSnVO billcodeRuleSnVO = new BillcodeRuleSnVO();
        snVOList.add(billcodeRuleSnVO);
        billcodeRuleSnVO.setSourcePid(vo.getId());
        billcodeRuleSnVO.setSourceCode(vo.getCode());
        billcodeRuleSnVO.setSourceType("BT230801000000001");
        billcodeRuleSnVO.setSourceTypeName("\u65bd\u5de5\u65b9\u6848");
        try {
            if (vo.getMgrp() != null) {
                JSONArray mgrpReferValue = ReferObjectUtil.getReferEntityValue((String)(vo.getMgrp() + ""), (String)"data-dictionary");
                JSONObject mgrpRef = (JSONObject)mgrpReferValue.get(0);
                billcodeRuleSnVO.setRule01(mgrpRef.getString("code"));
            }
            if (vo.getLocationCode() != null) {
                JSONArray locationReferValue = ReferObjectUtil.getReferEntityValue((String)(vo.getLocationCode() + ""), (String)"data-dictionary-category");
                JSONObject locationRef = (JSONObject)locationReferValue.get(0);
                billcodeRuleSnVO.setRule02(locationRef.getString("code"));
            }
        }
        catch (Exception e) {
            this.logger.info(e.getMessage());
            throw new BusinessException("referCode\u8f6c\u6362\u9519\u8bef");
        }
        return billcodeApiVO;
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<ConstructionSchemeVO> queryDetail(Long id) {
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)this.service.selectById(id));
        ConstructionSchemeVO vo = (ConstructionSchemeVO)((Object)BeanMapper.map((Object)((Object)entity), ConstructionSchemeVO.class));
        if (StringUtils.isNotBlank((CharSequence)vo.getConsTimeFrame())) {
            vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
        }
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<ConstructionSchemeVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (ConstructionSchemeVO constructionSchemeVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/cancel"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> cancel(@RequestBody Long id) {
        this.service.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(ConstructionSchemeEntity::getFlowState, (Object)FlowStateEnum.SIX.getCode())).set(ConstructionSchemeEntity::getFlowStateName, (Object)FlowStateEnum.SIX.getName())).set(ConstructionSchemeEntity::getFileState, (Object)"N")).eq(BaseEntity::getId, (Object)id));
        return CommonResponse.success((String)"\u4f5c\u5e9f\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<ConstructionSchemeVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        fuzzyFields.add("consSchemeName");
        fuzzyFields.add("code");
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        Parameter orgId = (Parameter)param.getParams().get("orgId");
        long parentOrgId = 0L;
        if (orgId != null) {
            parentOrgId = Long.parseLong(orgId.getValue().toString());
            param.getParams().remove("orgId");
        } else {
            parentOrgId = InvocationInfoProxy.getOrgId();
        }
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(Long.valueOf(parentOrgId)), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructionSchemeVO.class));
        pageData.getRecords().forEach(a -> {
            block3: {
                try {
                    if (StringUtils.isNotBlank((CharSequence)a.getConsTimeFrame())) {
                        String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[0], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)a.getConsTimeFrame().split("~")[1], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                        a.setConsTimeFrameList(Arrays.asList(a.getConsTimeFrame().split("~")));
                        a.setConsTimeFrame(startDate + "~" + endDate);
                    }
                }
                catch (Exception e) {
                    if (!this.logger.isErrorEnabled()) break block3;
                    this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u8f91\u8ba1\u5212\u6e05\u5355 \u8f6c\u6362\u65bd\u5de5\u65f6\u6bb5 \u5931\u8d25\uff01");
                }
            }
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) throws ParseException {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        param.getParams().put("orgId", new Parameter("in", ((List)this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData()).stream().map(BaseVO::getId).collect(Collectors.toList())));
        List list = this.service.queryList(param);
        List vos = new ArrayList();
        if (CollectionUtils.isNotEmpty((Collection)list)) {
            vos = BeanMapper.mapList((Iterable)list, ConstructionSchemeVO.class);
            for (ConstructionSchemeVO vo : vos) {
                if (vo.getOrgExpertExamine() != null) {
                    vo.setOrgExpertExamine(vo.getOrgExpertExamine().equals("Y") ? "\u662f" : "\u5426");
                }
                if (vo.getFileState() != null) {
                    vo.setFileState(vo.getFileState().equals("Y") ? "\u6709\u6548" : "\u65e0\u6548");
                }
                if (StringUtils.isNotBlank((CharSequence)vo.getConsTimeFrame())) {
                    String startDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)vo.getConsTimeFrame().split("~")[0], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                    String endDate = DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(DateUtils.parseDate((String)vo.getConsTimeFrame().split("~")[1], (String[])new String[]{"yyyy-MM-dd'T'HH:mm:ss.SSS'Z'"}));
                    vo.setConsTimeFrameList(Arrays.asList(vo.getConsTimeFrame().split("~")));
                    vo.setConsTimeFrame(startDate + "~" + endDate);
                }
                if (vo.getRedactFinishDate() != null) {
                    vo.setRedactFinishDateStr(DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(vo.getRedactFinishDate()));
                }
                if (vo.getFinishConsSchemeDate() != null) {
                    vo.setFinishConsSchemeDateStr(DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(vo.getFinishConsSchemeDate()));
                }
                if (vo.getPlanRedactDate() != null) {
                    vo.setPlanRedactDateStr(DateFormatUtils.ISO_8601_EXTENDED_DATE_FORMAT.format(vo.getPlanRedactDate()));
                }
                Long consSchemeType = vo.getConsSchemeType();
                CommonResponse consSchemeTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
                List data = (List)consSchemeTypeDefdoc.getData();
                if (consSchemeType == null) {
                    System.out.println("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b\u4e3a\u7a7a]");
                } else if (!consSchemeTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)data)) {
                    System.out.println("\u9519\u8bef\u7684\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6");
                } else {
                    for (DefdocDetailVO datum : (List)consSchemeTypeDefdoc.getData()) {
                        if (!consSchemeType.equals(datum.getId())) continue;
                        vo.setConsSchemeTypeName(datum.getName());
                    }
                }
                Long specialtyType = vo.getSpecialtyType();
                CommonResponse specialtyTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_specialty_type");
                List dataSpecialtyType = (List)specialtyTypeDefdoc.getData();
                if (specialtyType == null) {
                    System.out.println("\u4e13\u4e1a\u5206\u7c7b\u7c7b\u522b\u4e3a\u7a7a");
                } else if (!specialtyTypeDefdoc.isSuccess() || CollectionUtils.isEmpty((Collection)dataSpecialtyType)) {
                    System.out.println("\u9519\u8bef\u7684\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6");
                } else {
                    for (DefdocDetailVO datum : (List)specialtyTypeDefdoc.getData()) {
                        if (!specialtyType.equals(datum.getId())) continue;
                        vo.setSpecialTypeName(datum.getName());
                    }
                }
                Long projectTrait = vo.getProjectTrait();
                CommonResponse ctProjectTrait = this.iDefdocApi.getDefDocByDefCode("ct_project_trait");
                List dataProjectTrait = (List)ctProjectTrait.getData();
                if (projectTrait == null) {
                    System.out.println("\u5206\u90e8\u5206\u9879\u5de5\u7a0b\u7279\u5f81\u4e3a\u7a7a");
                } else if (!ctProjectTrait.isSuccess() || CollectionUtils.isEmpty((Collection)dataProjectTrait)) {
                    System.out.println("\u9519\u8bef\u7684\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6");
                } else {
                    for (DefdocDetailVO datum : (List)ctProjectTrait.getData()) {
                        if (!projectTrait.equals(datum.getId())) continue;
                        vo.setProjectTraitName(datum.getName());
                    }
                }
                if (vo.getApprovalPower() == null) continue;
                List employeeList = Lists.newArrayList();
                CommonResponse employeeResponse = this.iExternalApi.getMapAllEmployee();
                if (employeeResponse.isSuccess() && ListUtil.isNotEmpty((List)((List)employeeResponse.getData()))) {
                    employeeList = (List)employeeResponse.getData();
                }
                Map employee = employeeList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
                employee.forEach((k, v) -> {
                    if (vo.getApprovalPower().equals(v.get("id"))) {
                        vo.setApprovalPowerName(v.get("name").toString());
                    }
                });
            }
        }
        HashMap beans = new HashMap();
        beans.put("records", vos);
        ExcelExport.getInstance().export("Construction-scheme-export.xlsx", beans, response);
    }

    @RequestMapping(value={"/refConstructionSchemeData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<ConstructionSchemeVO>> refConstructionSchemeData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        JSONObject _con;
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("parentOrgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        if (StringUtils.isNotEmpty((CharSequence)condition) && Objects.nonNull((_con = JSONObject.parseObject((String)condition)).get((Object)"projectId"))) {
            param.getParams().put("projectId", new Parameter("eq", _con.get((Object)"projectId")));
        }
        param.getParams().put("fileState", new Parameter("eq", (Object)"Y"));
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), ConstructionSchemeVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    @PostMapping(value={"/upgrade"})
    @ResponseBody
    public CommonResponse<Void> upgrade(@RequestBody ConstructionSchemeVO vo) {
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)BeanMapper.map((Object)((Object)vo), ConstructionSchemeEntity.class));
        entity.setId(null);
        entity.setCreateUserCode(null);
        entity.setCreateTime(null);
        entity.setFileState("N");
        entity.setExecuteState(null);
        entity.setExecuteStateName(null);
        entity.setBillState(null);
        entity.setRedactFinishDate(new Date());
        entity.setOpinionInfoList(null);
        boolean sign = this.service.saveOrUpdate((Object)entity, false);
        this.conSchemePlanService.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().set(ConSchemePlanEntity::getExecuteState, (Object)ConOrgDesignStateEnum.ONE.getCode())).set(ConSchemePlanEntity::getExecuteStateName, (Object)ConOrgDesignStateEnum.ONE.getName())).eq(BaseEntity::getDr, (Object)0)).eq(BaseEntity::getId, (Object)entity.getConsSchemeId()));
        if (sign) {
            this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(vo.getId()), "BT230801000000001", "textAttachment", String.valueOf(entity.getId()), "BT230801000000001", "textAttachment");
        }
        return CommonResponse.success();
    }

    @PostMapping(value={"/upExpertArgumentFile"})
    @ResponseBody
    public CommonResponse<Void> upExpertArgumentFile(@RequestBody ConstructionSchemeVO vo) {
        ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)this.service.selectById(vo.getId()));
        GreatDangerProjectEntity greatDangerProject = (GreatDangerProjectEntity)((Object)this.greatDangerProjectService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(BaseEntity::getDr, (Object)0)).eq(GreatDangerProjectEntity::getConsSchemeId, (Object)vo.getId())).last("LIMIT 1")));
        greatDangerProject.setExpertAtteDate(new Date());
        greatDangerProject.setState(SchemeStateEnum.ONE.getCode());
        greatDangerProject.setStateName(SchemeStateEnum.ONE.getName());
        this.greatDangerProjectService.saveOrUpdate((Object)greatDangerProject, false);
        if (Objects.nonNull((Object)greatDangerProject)) {
            this.iAttachmentApi.deleteFileByParam(greatDangerProject.getId(), "BT230921000000001", "expertArgumentFile");
            this.iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT230801000000001", "expertArgumentFile", String.valueOf(greatDangerProject.getId()), "BT230921000000001", "expertArgumentFile");
        }
        return CommonResponse.success();
    }

    @RequestMapping(value={"/downloadConstructionSchemeTemplate"})
    @ResponseBody
    public void downloadConstructionSchemeTemplate(HttpServletRequest request, HttpServletResponse response) {
        ImportTemplate.initialize((HttpServletResponse)response);
        ImportTemplate.templetdownload((HttpServletRequest)request, (String)"construction-scheme-import.xlsx", (String)"\u65bd\u5de5\u65b9\u6848\u5bfc\u5165\u6a21\u677f");
    }

    @RequestMapping(value={"/excelConstructionSchemeImport"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<JSONObject> excelConstructionSchemeImport(HttpServletRequest request) {
        return this.service.excelConstructionSchemeImport(request);
    }

    @RequestMapping(value={"/saveImportExcelConstructionScheme"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<Void> saveImportExcelConstructionScheme(@RequestBody List<ConstructionSchemeImportVO> importVos) {
        if (ListUtil.isEmpty(importVos)) {
            return CommonResponse.error((String)"\u5bfc\u5165\u7684\u6570\u636e\u4e3a\u7a7a\uff01");
        }
        ArrayList list = Lists.newArrayList();
        importVos.forEach(importVO -> {
            String startDate = importVO.getConsTimeFrameList().get(0) + "T16:00:00.000Z";
            String endDate = importVO.getConsTimeFrameList().get(1) + "T16:00:00.000Z";
            importVO.setConsTimeFrame(startDate + "~" + endDate);
            ConstructionSchemeEntity entity = (ConstructionSchemeEntity)((Object)((Object)BeanMapper.map((Object)importVO, ConstructionSchemeEntity.class)));
            entity.setId(IdWorker.getId());
            list.add(entity);
        });
        this.service.saveBatch(list, list.size());
        return CommonResponse.success((String)"\u4fdd\u5b58\u6210\u529f\uff01");
    }
}

