/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.ProjectDisclosureEntity;
import com.ejianc.ztpc.mapper.ConSchemePlanMapper;
import com.ejianc.ztpc.mapper.ProjectDisclosureMapper;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.service.IProjectDisclosureService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.util.EJCDateUtil;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.vo.ProjectDisclosureImportVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="projectDisclosureService")
public class ProjectDisclosureServiceImpl
extends BaseServiceImpl<ProjectDisclosureMapper, ProjectDisclosureEntity>
implements IProjectDisclosureService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ProjectDisclosureMapper mapper;
    @Autowired
    private ConSchemePlanMapper conSchemePlanMapper;
    @Autowired
    private IConstructionSchemeService constructionSchemeService;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;

    @Override
    public CommonResponse<JSONObject> excelProjectDisclosureImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        ArrayList<ProjectDisclosureImportVO> successList = new ArrayList<ProjectDisclosureImportVO>();
        ArrayList<ProjectDisclosureImportVO> errorList = new ArrayList<ProjectDisclosureImportVO>();
        HashMap<String, String> dictionaryQueryMap = new HashMap<String, String>();
        for (Map.Entry entity : fileMap.entrySet()) {
            mf = (MultipartFile)entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        List result = ExcelReader.readExcel(mf);
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u5377\u518c\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.conSchemePlanMapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            List deptList = Lists.newArrayList();
            CommonResponse allDeptCommonResponse = this.iExternalApi.queryAllDept();
            if (allDeptCommonResponse.isSuccess() && ToolUtil.isNotEmpty(allDeptCommonResponse.getData())) {
                deptList = (List)allDeptCommonResponse.getData();
            }
            Map testDept = deptList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            List employeeList = Lists.newArrayList();
            CommonResponse employeeResponse = this.iExternalApi.getMapAllEmployee();
            if (employeeResponse.isSuccess() && ListUtil.isNotEmpty((List)((List)employeeResponse.getData()))) {
                employeeList = (List)employeeResponse.getData();
            }
            Map employee = employeeList.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            CommonResponse ctDisclosureType = this.iDefdocApi.getDefDocByDefCode("ct_disclosure_type");
            for (int i = 0; i < result.size(); ++i) {
                String locationCodeName;
                String remark;
                String disclosureDateStr;
                String place;
                String auditUserName;
                String buildLeaderName;
                String buildUnitName;
                String byDisclosureDeptName;
                String mgrpName;
                String disclosureTypeName;
                boolean flag = true;
                List datas = (List)result.get(i);
                StringBuilder errorMessage = new StringBuilder("");
                ProjectDisclosureImportVO vo = new ProjectDisclosureImportVO();
                vo.setId(IdWorker.getId());
                vo.setRedactUser(InvocationInfoProxy.getUserid());
                vo.setRedactDate(new Date());
                String projectName = (String)datas.get(0);
                Map projectNameMap = (Map)projDataMap.get(projectName);
                if (StringUtils.isBlank((CharSequence)projectName) || MapUtils.isEmpty((Map)projectNameMap)) {
                    errorMessage.append("[\u5de5\u7a0b\u540d\u79f0]").append(projectName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                    flag = false;
                } else {
                    vo.setProjectName((String)projectNameMap.get("name"));
                    vo.setProjectCode((String)projectNameMap.get("code"));
                    Object id = projectNameMap.get("id");
                    if (id instanceof String) {
                        vo.setProjectId(Long.parseLong((String)id));
                    } else {
                        vo.setProjectId((Long)id);
                    }
                    Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                    if (engineeringTypeId instanceof String) {
                        vo.setEngineeringTypeId(Long.parseLong((String)engineeringTypeId));
                    } else {
                        vo.setEngineeringTypeId((Long)engineeringTypeId);
                    }
                    Object projectLeave = projectNameMap.get("project_rank");
                    if (projectLeave instanceof String) {
                        vo.setProjectLeave(Long.parseLong((String)projectLeave));
                    } else {
                        vo.setProjectLeave((Long)projectLeave);
                    }
                }
                String consSchemeIdName = (String)datas.get(1);
                ConstructionSchemeEntity constructionSchemeEntity = (ConstructionSchemeEntity)((Object)this.constructionSchemeService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ConstructionSchemeEntity::getProjectId, (Object)vo.getProjectId())).eq(BaseEntity::getDr, (Object)0)).eq(ConstructionSchemeEntity::getConsSchemeName, (Object)consSchemeIdName)).last(" LIMIT 1 ")));
                if (ToolUtil.isEmpty(consSchemeIdName)) {
                    errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                } else if (constructionSchemeEntity == null) {
                    errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u540d\u79f0]:").append(consSchemeIdName).append("\u53c2\u7167\u83b7\u53d6\u5931\u8d25;");
                    flag = false;
                } else {
                    vo.setConsSchemeId(constructionSchemeEntity.getId());
                    vo.setConsSchemeCode(constructionSchemeEntity.getCode());
                    vo.setConsSchemeName(constructionSchemeEntity.getConsSchemeName());
                    vo.setConsSchemeFileVersion(constructionSchemeEntity.getFileVersion());
                }
                String disclosureName = (String)datas.get(2);
                if (ToolUtil.isEmpty(disclosureName)) {
                    errorMessage.append("[\u4ea4\u5e95\u540d\u79f0]\u4e3a\u7a7a;");
                    flag = false;
                } else {
                    vo.setDisclosureName(disclosureName);
                }
                String internalCode = (String)datas.get(3);
                if (ToolUtil.isEmpty(internalCode)) {
                    errorMessage.append("[\u5185\u90e8\u7f16\u7801]\u4e3a\u7a7a;");
                    flag = false;
                } else {
                    vo.setInternalCode(internalCode);
                }
                String outsideCode = (String)datas.get(4);
                if (ToolUtil.isNotEmpty(outsideCode)) {
                    vo.setOutsideCode(outsideCode);
                }
                if (ToolUtil.isEmpty(disclosureTypeName = (String)datas.get(5))) {
                    errorMessage.append("[\u4ea4\u5e95\u7c7b\u578b]\u4e3a\u7a7a;");
                    flag = false;
                } else if (!ctDisclosureType.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)ctDisclosureType.getData()))) {
                    errorMessage.append("[\u4ea4\u5e95\u7c7b\u578b]").append(disclosureTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)ctDisclosureType.getData()).stream().filter(a -> disclosureTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    if (defdocDetailId == null) {
                        errorMessage.append("[\u4ea4\u5e95\u7c7b\u578b]:\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u7167;");
                        flag = false;
                    } else {
                        vo.setDisclosureType(defdocDetailId);
                    }
                }
                String disclosureVersion = (String)datas.get(6);
                if (ToolUtil.isEmpty(disclosureVersion)) {
                    errorMessage.append("[\u7248\u672c]\u4e3a\u7a7a;");
                    flag = false;
                } else {
                    vo.setDisclosureVersion(disclosureVersion);
                }
                String specialtyName = (String)datas.get(7);
                if (ToolUtil.isNotEmpty(specialtyName)) {
                    List data;
                    dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "specialty");
                    CommonResponse specialtyCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (specialtyCommonResponse.isSuccess() && (data = (List)specialtyCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> specialtyName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u4e13\u4e1a]").append(specialtyName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            vo.setSpecialty(dataDictionaryVO.getId());
                        }
                    }
                }
                if (ToolUtil.isNotEmpty(mgrpName = (String)datas.get(8))) {
                    List data;
                    dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "mgrp");
                    CommonResponse mgrpCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (mgrpCommonResponse.isSuccess() && (data = (List)mgrpCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u673a\u7ec4]").append(mgrpName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            vo.setMgrp(dataDictionaryVO.getId());
                        }
                    }
                }
                if (!ToolUtil.isEmpty(byDisclosureDeptName = (String)datas.get(9))) {
                    Map stringObjectMap = (Map)testDept.get(byDisclosureDeptName);
                    if (ToolUtil.isNotEmpty(stringObjectMap)) {
                        Object id = stringObjectMap.get("id");
                        if (id != null) {
                            vo.setByDisclosureDept(Long.parseLong(stringObjectMap.get("id").toString()));
                        } else {
                            errorMessage.append("[\u88ab\u4ea4\u5e95\u90e8\u95e8/\u73ed\u7ec4]\u53c2\u6570\u9519\u8bef;");
                            flag = false;
                        }
                    } else {
                        errorMessage.append("[\u88ab\u4ea4\u5e95\u90e8\u95e8/\u73ed\u7ec4]" + byDisclosureDeptName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    }
                }
                if (ToolUtil.isNotEmpty(buildUnitName = (String)datas.get(10))) {
                    CommonResponse buildUnit = this.iOrgApi.findByNameAndTenantId(buildUnitName, InvocationInfoProxy.getTenantid());
                    if (buildUnit.isSuccess() && ToolUtil.isNotEmpty(buildUnit.getData())) {
                        vo.setBuildUnit(((OrgVO)buildUnit.getData()).getId());
                    } else {
                        errorMessage.append("[\u65bd\u5de5\u5355\u4f4d]" + buildUnitName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    }
                }
                if (ToolUtil.isNotEmpty(buildLeaderName = (String)datas.get(11))) {
                    Map stringObjectMap = (Map)employee.get(buildLeaderName);
                    if (stringObjectMap == null) {
                        errorMessage.append("[\u65bd\u5de5\u8d1f\u8d23\u4eba]" + buildLeaderName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        try {
                            vo.setBuildLeader(Long.parseLong(stringObjectMap.get("id").toString()));
                        }
                        catch (Exception e3) {
                            this.logger.info(e3.getMessage() + ";" + stringObjectMap.toString() + ";");
                            errorMessage.append("[\u65bd\u5de5\u8d1f\u8d23\u4eba]" + buildLeaderName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        }
                    }
                }
                if (ToolUtil.isEmpty(auditUserName = (String)datas.get(12))) {
                    errorMessage.append("[\u5ba1\u6838\u4eba]\u4e3a\u7a7a;");
                    flag = false;
                } else {
                    Map stringObjectMap = (Map)employee.get(auditUserName);
                    if (stringObjectMap == null) {
                        errorMessage.append("[\u5ba1\u6838\u4eba]" + auditUserName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        try {
                            vo.setAuditUser(Long.parseLong(stringObjectMap.get("id").toString()));
                        }
                        catch (Exception e4) {
                            this.logger.info(e4.getMessage() + ";" + stringObjectMap.toString() + ";");
                            errorMessage.append("[\u5ba1\u6838\u4eba]" + auditUserName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        }
                    }
                }
                String auditDateStr = (String)datas.get(13);
                if (ToolUtil.isNotEmpty(auditDateStr)) {
                    Date parse = EJCDateUtil.parseDate(auditDateStr, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        vo.setAuditDate(parse);
                    } else {
                        errorMessage.append("[\u5ba1\u6838\u65e5\u671f]" + auditDateStr + ":\u683c\u5f0f\u9519\u8bef");
                        flag = false;
                    }
                } else {
                    errorMessage.append("[\u5ba1\u6838\u65e5\u671f]\u4e3a\u7a7a;");
                    flag = false;
                }
                String disclosureUserName = (String)datas.get(14);
                if (!ToolUtil.isEmpty(disclosureUserName)) {
                    Map stringObjectMap = (Map)employee.get(disclosureUserName);
                    if (stringObjectMap == null) {
                        errorMessage.append("[\u4ea4\u5e95\u4eba]" + disclosureUserName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        try {
                            vo.setDisclosureUser(Long.parseLong(stringObjectMap.get("id").toString()));
                        }
                        catch (Exception e5) {
                            this.logger.info(e5.getMessage() + ";" + stringObjectMap.toString() + ";");
                            errorMessage.append("[\u4ea4\u5e95\u4eba]" + disclosureUserName + ":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        }
                    }
                }
                if (ToolUtil.isNotEmpty(place = (String)datas.get(15))) {
                    vo.setPlace(place);
                }
                if (ToolUtil.isNotEmpty(disclosureDateStr = (String)datas.get(16))) {
                    Date parse = EJCDateUtil.parseDate(disclosureDateStr, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        vo.setDisclosureDate(parse);
                    } else {
                        errorMessage.append("[\u4ea4\u5e95\u65f6\u95f4]" + disclosureDateStr + ":\u683c\u5f0f\u9519\u8bef");
                        flag = false;
                    }
                }
                if (ToolUtil.isNotEmpty(remark = (String)datas.get(17))) {
                    vo.setRemark(remark);
                }
                if (ToolUtil.isNotEmpty(locationCodeName = (String)datas.get(18))) {
                    Map data;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("categoryName", locationCodeName);
                    CommonResponse mapCommonResponse = this.billCodeRuleApi.materialClassificationTree(map);
                    if (mapCommonResponse.isSuccess() && ToolUtil.isNotEmpty(data = (Map)mapCommonResponse.getData())) {
                        Long id = (Long)data.get("name");
                        vo.setLocationCode(id);
                    }
                }
                vo.setRowIndex(i + 2);
                Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(vo.getProjectId()));
                CommonResponse orgVO = this.iOrgApi.getOneById((Long)stringStringMap.get("orgId"));
                if (!orgVO.isSuccess()) {
                    errorMessage.append("[\u9879\u76ee\u65e0\u5bf9\u5e94\u7ec4\u7ec7]");
                }
                vo.setOrgId((Long)stringStringMap.get("orgId"));
                vo.setOrgCode(((OrgVO)orgVO.getData()).getCode());
                vo.setOrgName(((OrgVO)orgVO.getData()).getName());
                vo.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                vo.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                vo.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                if (flag) {
                    successList.add(vo);
                    continue;
                }
                vo.setErrorMessage(errorMessage.toString());
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(ProjectDisclosureImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success((Object)json);
    }
}

