package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.ejianc.foundation.file.api.IAttachmentApi;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.billState.param.CommonBusinessParam;
import com.ejianc.framework.skeleton.billState.service.ICommonBusinessService;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.GreatDangerProjectEntity;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.controller.GreatDangerProjectController;
import com.ejianc.ztpc.enumUtils.ConOrgDesignStateEnum;
import com.ejianc.ztpc.enumUtils.FlowStateEnum;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.service.IGreatDangerProjectService;
import com.ejianc.ztpc.service.IOpinionInfoService;
import com.ejianc.ztpc.vo.GreatDangerProjectVO;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.*;

@Service("constructionScheme")
public class ConstructionSchemeBpmServiceImpl implements ICommonBusinessService {
    /**
     * 日志
     */
    private final Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IConstructionSchemeService constructionSchemeService;
    @Autowired
    private IConSchemePlanService conSchemePlanService;
    @Autowired
    private GreatDangerProjectController greatDangerProjectController;
    @Autowired
    private IGreatDangerProjectService greatDangerProjectService;
    @Autowired
    private IAttachmentApi iAttachmentApi;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private IOpinionInfoService opinionInfoService;
    @Autowired
    private IUserApi userApi;


    /**
     * 提交前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    ;

    /**
     * 提交完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterSubmitProcessor(Long billId, Integer state, String billTypeCode) {
        if (logger.isInfoEnabled()) {
            logger.info("afterSubmitProcessor，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        }
        ConstructionSchemeEntity entity = constructionSchemeService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }

        /*
         * 判断该施工方案编制计划是否使用
         */
        ConSchemePlanEntity conOrgDesignPlanEntity = conSchemePlanService.getOne(
                new QueryWrapper<ConSchemePlanEntity>()
                        .lambda()
                        .eq(ConSchemePlanEntity::getDr, 0)
                        .eq(ConSchemePlanEntity::getId, entity.getConsSchemeId())
                        .eq(ConSchemePlanEntity::getExecuteState, ConOrgDesignStateEnum.THREE.getCode())
                        .last("LIMIT 1")
        );
        if (Objects.nonNull(conOrgDesignPlanEntity)) {
            return CommonResponse.error("该施工方案编制计划已使用！");
        }
        /*
         * 施工方案编制计划清单-更改执行状态为“正在编制”
         */
        conSchemePlanService.update(
                new UpdateWrapper<ConSchemePlanEntity>()
                        .lambda()
                        .set(ConSchemePlanEntity::getExecuteState, ConOrgDesignStateEnum.ONE.getCode())
                        .set(ConSchemePlanEntity::getExecuteStateName, ConOrgDesignStateEnum.ONE.getName())
                        .eq(ConSchemePlanEntity::getDr, 0)
                        .eq(ConSchemePlanEntity::getId, entity.getConsSchemeId())
        );
//        /*
//         * 施工方案-更改执行状态为“正在编制”
//         */
//        constructionSchemeService.update(
//                new UpdateWrapper<ConstructionSchemeEntity>()
//                        .lambda()
//                        .set(ConstructionSchemeEntity::getExecuteState, ConOrgDesignStateEnum.ONE.getCode())
//                        .set(ConstructionSchemeEntity::getExecuteStateName, ConOrgDesignStateEnum.ONE.getName())
//                        .eq(ConstructionSchemeEntity::getDr, 0)
//                        .eq(ConstructionSchemeEntity::getId, entity.getId())
//        );
        CommonResponse<DefdocDetailVO> consSchemeTypeDoc = iDefdocApi.getDefDocById(entity.getConsSchemeType());
        if (consSchemeTypeDoc.isSuccess() && Objects.nonNull(consSchemeTypeDoc.getData()) &&
                ("A".equals(consSchemeTypeDoc.getData().getCode()) || "B".equals(consSchemeTypeDoc.getData().getCode()))) {
            /*
             * 推送危大工程
             */
            GreatDangerProjectEntity oldGreatDangerProject = greatDangerProjectService.getOne(
                    new QueryWrapper<GreatDangerProjectEntity>()
                            .lambda()
                            .eq(GreatDangerProjectEntity::getDr, 0)
                            .eq(GreatDangerProjectEntity::getConsSchemeId, entity.getId())
                            .last("LIMIT 1")
            );
            if (Objects.isNull(oldGreatDangerProject)) {
                GreatDangerProjectEntity greatDangerProject = new GreatDangerProjectEntity();
                greatDangerProject.setProjectId(entity.getProjectId());
                greatDangerProject.setProjectCode(entity.getProjectCode());
                greatDangerProject.setProjectName(entity.getProjectName());
                greatDangerProject.setOrgId(entity.getOrgId());
                greatDangerProject.setOrgCode(entity.getOrgCode());
                greatDangerProject.setOrgName(entity.getOrgName());
                greatDangerProject.setParentOrgId(entity.getParentOrgId());
                greatDangerProject.setParentOrgCode(entity.getParentOrgCode());
                greatDangerProject.setParentOrgName(entity.getParentOrgName());
                greatDangerProject.setEngineeringTypeId(entity.getEngineeringTypeId());
                greatDangerProject.setProjectLeave(entity.getProjectLeave());
                greatDangerProject.setConsSchemeId(entity.getId());
                greatDangerProject.setConsSchemeName(entity.getConsSchemeName());
                greatDangerProject.setConsSchemeType(entity.getConsSchemeType());
                CommonResponse<GreatDangerProjectVO> response = greatDangerProjectController.saveOrUpdate(BeanMapper.map(greatDangerProject, GreatDangerProjectVO.class));
                if (response.isSuccess() && Objects.nonNull(response.getData())) {
                    /*
                     * 复制施工方案中的“正文附件”到危大工程的“施工方案附件”中
                     */
                    iAttachmentApi.copyFilesFromSourceBillToTargetBill(String.valueOf(entity.getId()), "BT230801000000001", "textAttachment",
                            String.valueOf(response.getData().getId()), "BT230921000000001", "constructionSchemeFile");
                }
            }
        }
        constructionSchemeService.update(new UpdateWrapper<ConstructionSchemeEntity>().lambda()
                .set(ConstructionSchemeEntity::getFlowState, FlowStateEnum.ONE.getCode())
                .set(ConstructionSchemeEntity::getFlowStateName,FlowStateEnum.ONE.getName())
                .eq(ConstructionSchemeEntity::getId,billId));
        return CommonResponse.success();
    }

    /**
     * 有审批流的撤回前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeHasBpmBack(Long billId, Integer state, String billTypeCode) {
        return CommonResponse.success();
    }

    ;

    /**
     * 有审批流的撤回后回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterHasBpmBack(Long billId, Integer state, String billTypeCode) {
        if (logger.isInfoEnabled()) {
            logger.info("afterHasBpmBack，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        }
        ConstructionSchemeEntity entity = constructionSchemeService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }
        /*
         * 施工方案编制计划清单-更改执行状态为“正在编制”
         */
        conSchemePlanService.update(
                new UpdateWrapper<ConSchemePlanEntity>()
                        .lambda()
                        .set(ConSchemePlanEntity::getExecuteState, ConOrgDesignStateEnum.ONE.getCode())
                        .set(ConSchemePlanEntity::getExecuteStateName, ConOrgDesignStateEnum.ONE.getName())
                        .eq(ConSchemePlanEntity::getDr, 0)
                        .eq(ConSchemePlanEntity::getId, entity.getConsSchemeId())
        );
//        /*
//         * 施工方案-更改执行状态为“正在编制”
//         */
//        constructionSchemeService.update(
//                new UpdateWrapper<ConstructionSchemeEntity>()
//                        .lambda()
//                        .set(ConstructionSchemeEntity::getExecuteState, ConOrgDesignStateEnum.ONE.getCode())
//                        .set(ConstructionSchemeEntity::getExecuteStateName, ConOrgDesignStateEnum.ONE.getName())
//                        .eq(ConstructionSchemeEntity::getDr, 0)
//                        .eq(ConstructionSchemeEntity::getId, entity.getId())
//        );
        constructionSchemeService.update(new UpdateWrapper<ConstructionSchemeEntity>().lambda()
                .set(ConstructionSchemeEntity::getFlowState, FlowStateEnum.FOUR.getCode())
                .set(ConstructionSchemeEntity::getFlowStateName,FlowStateEnum.FOUR.getName())
                .eq(ConstructionSchemeEntity::getId,billId));
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeInApprovalBack(Long billId, Integer state, String billTypeCode, String sign) {
        return CommonResponse.success();
    }

    ;

    /**
     * 审批节点审批中时节点审批后回调
     *
     * @param billId       //单据id
     * @param state        //单据状态
     * @param billTypeCode //单据类型code
     * @param taskId       //该流程id
     * @param isEnd        //该节点是否结束
     * @return
     */
    @Override
    public CommonResponse<String> afterInApprovalBack(Long billId, Integer state, String billTypeCode, String taskId, Boolean isEnd, String sign, Map<String, Object> other) {
        if (logger.isInfoEnabled()) {
            logger.info("afterInApprovalBack，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode +
                    "   taskId:" + taskId + "   isEnd:" + isEnd + "   sign:" + sign + "   other:" + JSONObject.toJSONString(other));
        }
        ConstructionSchemeEntity entity = constructionSchemeService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }
        if ("fqr_node".equals(sign)) {
            /*
             * 施工方案设计清单-更改状态为“已编制”
             */
            conSchemePlanService.update(
                    new UpdateWrapper<ConSchemePlanEntity>()
                            .lambda()
                            .set(ConSchemePlanEntity::getExecuteState, ConOrgDesignStateEnum.TWO.getCode())
                            .set(ConSchemePlanEntity::getExecuteStateName, ConOrgDesignStateEnum.TWO.getName())
                            .eq(ConSchemePlanEntity::getDr, 0)
                            .eq(ConSchemePlanEntity::getId, entity.getConsSchemeId())
            );
//            /*
//             * 施工方案-更改状态为“已编制”
//             */
//            constructionSchemeService.update(
//                    new UpdateWrapper<ConstructionSchemeEntity>()
//                            .lambda()
//                            .set(ConstructionSchemeEntity::getExecuteState, ConOrgDesignStateEnum.TWO.getCode())
//                            .set(ConstructionSchemeEntity::getExecuteStateName, ConOrgDesignStateEnum.TWO.getName())
//                            .eq(ConstructionSchemeEntity::getDr, 0)
//                            .eq(ConstructionSchemeEntity::getId, entity.getId())
//            );
        }
        constructionSchemeService.update(new UpdateWrapper<ConstructionSchemeEntity>().lambda()
                .set(ConstructionSchemeEntity::getFlowState, FlowStateEnum.TWO.getCode())
                .set(ConstructionSchemeEntity::getFlowStateName,FlowStateEnum.TWO.getName())
                .eq(ConstructionSchemeEntity::getId,billId));
        return CommonResponse.success();
    }

    /**
     * 终审审核前回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 终审审核完回调
     *
     * @param
     * @return
     */
    @Override
    public CommonResponse<String> afterApprovalProcessor(Long billId, Integer state, String billTypeCode) {
        if (logger.isInfoEnabled()) {
            logger.info("afterApprovalProcessor，开始回写状态，billId:" + billId + "    state:" + state + "   billTypeCode:" + billTypeCode);
        }
        ConstructionSchemeEntity entity = constructionSchemeService.selectById(billId);
        if (Objects.isNull(entity)) {
            return CommonResponse.error("单据信息未找到！");
        }
        /*
         * 施工方案清单-更改状态为“批准生效”
         */
        conSchemePlanService.update(
                new UpdateWrapper<ConSchemePlanEntity>()
                        .lambda()
                        .set(ConSchemePlanEntity::getExecuteState, ConOrgDesignStateEnum.THREE.getCode())
                        .set(ConSchemePlanEntity::getExecuteStateName, ConOrgDesignStateEnum.THREE.getName())
                        .eq(ConSchemePlanEntity::getDr, 0)
                        .eq(ConSchemePlanEntity::getId, entity.getConsSchemeId())
        );
//        /*
//         * 施工方案-更改状态为“批准生效”
//         */
//        constructionSchemeService.update(
//                new UpdateWrapper<ConstructionSchemeEntity>()
//                        .lambda()
//                        .set(ConstructionSchemeEntity::getExecuteState, ConOrgDesignStateEnum.THREE.getCode())
//                        .set(ConstructionSchemeEntity::getExecuteStateName, ConOrgDesignStateEnum.THREE.getName())
//                        .set(ConstructionSchemeEntity::getFileState, "Y")
//                        .eq(ConstructionSchemeEntity::getDr, 0)
//                        .eq(ConstructionSchemeEntity::getId, entity.getId())
//        );
        /*
         * 更新旧版数据的文件状态为”无效“
         */
        ConstructionSchemeEntity oldEntity = constructionSchemeService.getOne(
                new QueryWrapper<ConstructionSchemeEntity>()
                        .lambda()
                        .eq(ConstructionSchemeEntity::getDr, 0)
                        .eq(ConstructionSchemeEntity::getConsSchemeId, entity.getConsSchemeId())
                        .ne(ConstructionSchemeEntity::getId, entity.getId())
                        .orderByDesc(ConstructionSchemeEntity::getCreateTime)
                        .last("LIMIT 1")
        );
        if (Objects.nonNull(oldEntity)) {
            constructionSchemeService.update(
                    new UpdateWrapper<ConstructionSchemeEntity>()
                            .lambda()
                            .set(ConstructionSchemeEntity::getFileState, "N")
                            .eq(ConstructionSchemeEntity::getId, oldEntity.getId())
            );
        }
        /*
         * 施工方案-更改"批准权限"为当前操作人,并修改"文件状态"为 有效
         */
        constructionSchemeService.update(
                new UpdateWrapper<ConstructionSchemeEntity>()
                        .lambda()
                        .set(ConstructionSchemeEntity::getApprovalPower, InvocationInfoProxy.getUserid())
                        .set(ConstructionSchemeEntity::getFileState, "Y")
                        .set(ConstructionSchemeEntity::getFlowState,FlowStateEnum.THREE.getCode())
                        .set(ConstructionSchemeEntity::getFlowStateName,FlowStateEnum.THREE.getName())
                        .eq(ConstructionSchemeEntity::getDr, 0)
                        .eq(ConstructionSchemeEntity::getId, entity.getId())
        );

        return CommonResponse.success();
    }

    /**
     * 弃审前事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> beforeAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        return CommonResponse.success();
    }

    /**
     * 弃审后事件回调
     *
     * @param billId
     * @param state
     * @return
     */
    @Override
    public CommonResponse<String> afterAbstainingProcessor(Long billId, Integer state, String billTypeCode) {
        //TODO
        constructionSchemeService.update(new UpdateWrapper<ConstructionSchemeEntity>().lambda()
                .set(ConstructionSchemeEntity::getFlowState, FlowStateEnum.ZERO.getCode())
                .set(ConstructionSchemeEntity::getFlowStateName,FlowStateEnum.ZERO.getName())
                .eq(ConstructionSchemeEntity::getId,billId));
        return CommonResponse.success();
    }

    /**
     *
     * 审批--新的审批人员时回调
     *
     *
     * @param billId          单据id
     * @param billTypecode    单据类型编码
     *                        -------当前节点------
     * @param taskKey         审批节点key
     * @param taskName        审批节点名称
     * @param sign            节点标志
     *                        --------当前审批人的节点---------/*****
     * @param approveUserList 审批人
     *         taskKey        审批节点key
     *         taskName       审批节点名称
     *         sign           节点标志
     *         approveUserList 审批人员(List<string>)
     * @return
     */
    @Override
    public CommonResponse<String> approveUserList(CommonBusinessParam businessParam) {
        /*
        {"billId":843508814631170056,
        "billTypeCode":"BT230801000000001",
        "metadataId":738854681245138977,
        "newApproveInfo":[
        {"taskKey":"ApproveUserTask1696838430000830",
        "approveUserList":["1247777316689256450"],
        "sign":"fqr_node",
        "taskName":"发起人（修订\\升版）"}
        ],
        "sign":"xmgl_node",
        "taskKey":"ApproveUserTask1696838334000493",
        "taskName":"项目部门会审"}
         */
        logger.info("approveUserList回调"+JSONObject.toJSONString(businessParam));
        Long billId = businessParam.getBillId();
        JSONArray newApproveInfo = businessParam.getNewApproveInfo();
        if (newApproveInfo != null && newApproveInfo.size() > 0){
            JSONObject jsonObject = newApproveInfo.getJSONObject(0);
            JSONArray jsonArray = jsonObject.getJSONArray("approveUserList");//人员信息
            CommonResponse<List<UserVO>> userList = userApi.queryListByIds(jsonArray.toArray(new String[0]));
            if (userList.isSuccess() && userList.getData() != null && userList.getData().size() > 0){
                List<UserVO> data = userList.getData();
                List<OpinionInfoEntity> list = new ArrayList<>();
                for (UserVO userVO : data) {
                    OpinionInfoEntity opinionInfoEntity = new OpinionInfoEntity();
                    opinionInfoEntity.setId(IdWorker.getId());
                    opinionInfoEntity.setProposeUserId(userVO.getId());
                    opinionInfoEntity.setProposeUserName(userVO.getUserName());
                    opinionInfoEntity.setMobile(userVO.getUserMobile());
                    opinionInfoEntity.setPid(billId);
                    list.add(opinionInfoEntity);
                }
                opinionInfoService.saveBatch(list);
            }
        }
        return CommonResponse.success();
    }
}
