package com.ejianc.ztpc.bean;

import com.baomidou.mybatisplus.annotation.TableField;
import com.baomidou.mybatisplus.annotation.TableName;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.annotation.SubEntity;

import java.util.Date;
import java.util.List;

/**
 * 图纸会检表
 *
 * @author generator
 */
@TableName("ct_drawing_check")
public class DrawingCheckEntity extends BaseEntity {
    private static final long serialVersionUID = 1L;

    @TableField(value = "code")
    private String code; // 编码
    @TableField(value = "bill_state")
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    @TableField(value = "project_id")
    private Long projectId; // 项目ID
    @TableField(value = "project_code")
    private String projectCode; // 项目编码
    @TableField(value = "project_name")
    private String projectName; // 项目名称
    @TableField(value = "org_id")
    private Long orgId; // 项目组织ID
    @TableField(value = "org_code")
    private String orgCode; // 项目组织编码
    @TableField(value = "org_name")
    private String orgName; // 项目组织名称
    @TableField(value = "parent_org_id")
    private Long parentOrgId; // 父级组织ID
    @TableField(value = "parent_org_code")
    private String parentOrgCode; // 父级组织编码
    @TableField(value = "parent_org_name")
    private String parentOrgName; // 父级组织名称
    @TableField(value = "compere")
    private Long compere; // 主持人
    @TableField(value = "mgrp")
    private Long mgrp; // 机组--字典mgrp
    @TableField(value = "sys")
    private Long sys; // 系统--字典sys
    @TableField(value = "specialty")
    private Long specialty; // 专业--字典specialty
    @TableField(value = "construction_opinion")
    private String constructionOpinion; // 施工图纸会审意见
    @TableField(value = "joint_trial_code")
    private String jointTrialCode; // 会审编码
    @TableField(value = "joint_trial_place")
    private String jointTrialPlace; // 会审地点
    @TableField(value = "joint_trial_date")
    private Date jointTrialDate; // 会审日期
    @TableField(value = "joint_trial_type")
    private Long jointTrialType; // 会审类别--字典ct_joint_trial_type
    @TableField(value = "joint_trial_opinion")
    private String jointTrialOpinion; // 会审意见闭环
    @TableField(value="effectiveness")
    private String effectiveness; // 有效性（Y：有效，N：无效）
    @TableField(value = "outside_code")
    private String outsideCode;//外部编码
    @TableField(value = "location_code")
    private Long locationCode;//区域定位码

    @TableField(exist = false)
    @SubEntity(serviceName = "checkDrawInfoService")
    private List<CheckDrawInfoEntity> checkDrawInfoList; // 图纸会检-图纸信息
    @TableField(exist = false)
    @SubEntity(serviceName = "checkParticipantService")
    private List<CheckParticipantEntity> checkParticipantList; // 图纸会检-参加人

    public String getCode() {
        return code;
    }

    public void setCode(String code) {
        this.code = code;
    }

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    public Long getProjectId() {
        return projectId;
    }

    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }

    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }

    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    public Long getOrgId() {
        return orgId;
    }

    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }

    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }

    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    public Long getParentOrgId() {
        return parentOrgId;
    }

    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }

    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }

    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }

    public Long getCompere() {
        return compere;
    }

    public void setCompere(Long compere) {
        this.compere = compere;
    }

    public Long getMgrp() {
        return mgrp;
    }

    public void setMgrp(Long mgrp) {
        this.mgrp = mgrp;
    }

    public Long getSys() {
        return sys;
    }

    public void setSys(Long sys) {
        this.sys = sys;
    }

    public Long getSpecialty() {
        return specialty;
    }

    public void setSpecialty(Long specialty) {
        this.specialty = specialty;
    }

    public String getConstructionOpinion() {
        return constructionOpinion;
    }

    public void setConstructionOpinion(String constructionOpinion) {
        this.constructionOpinion = constructionOpinion;
    }

    public String getJointTrialCode() {
        return jointTrialCode;
    }

    public void setJointTrialCode(String jointTrialCode) {
        this.jointTrialCode = jointTrialCode;
    }

    public String getJointTrialPlace() {
        return jointTrialPlace;
    }

    public void setJointTrialPlace(String jointTrialPlace) {
        this.jointTrialPlace = jointTrialPlace;
    }

    public Date getJointTrialDate() {
        return jointTrialDate;
    }

    public void setJointTrialDate(Date jointTrialDate) {
        this.jointTrialDate = jointTrialDate;
    }

    public Long getJointTrialType() {
        return jointTrialType;
    }

    public void setJointTrialType(Long jointTrialType) {
        this.jointTrialType = jointTrialType;
    }

    public String getJointTrialOpinion() {
        return jointTrialOpinion;
    }

    public void setJointTrialOpinion(String jointTrialOpinion) {
        this.jointTrialOpinion = jointTrialOpinion;
    }

    public List<CheckDrawInfoEntity> getCheckDrawInfoList() {
        return checkDrawInfoList;
    }

    public void setCheckDrawInfoList(List<CheckDrawInfoEntity> checkDrawInfoList) {
        this.checkDrawInfoList = checkDrawInfoList;
    }

    public List<CheckParticipantEntity> getCheckParticipantList() {
        return checkParticipantList;
    }

    public void setCheckParticipantList(List<CheckParticipantEntity> checkParticipantList) {
        this.checkParticipantList = checkParticipantList;
    }

    public String getEffectiveness() {
        return effectiveness;
    }

    public void setEffectiveness(String effectiveness) {
        this.effectiveness = effectiveness;
    }

    public String getOutsideCode() {
        return outsideCode;
    }

    public void setOutsideCode(String outsideCode) {
        this.outsideCode = outsideCode;
    }

    public Long getLocationCode() {
        return locationCode;
    }

    public void setLocationCode(Long locationCode) {
        this.locationCode = locationCode;
    }
}
