package com.ejianc.ztpc.vo;

import java.util.Date;
import java.math.*;
import java.util.List;
import java.util.ArrayList;
import java.io.Serializable;

import com.ejianc.framework.skeleton.refer.annotation.ReferDeserialTransfer;
import com.ejianc.framework.skeleton.refer.annotation.ReferSerialTransfer;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.fasterxml.jackson.annotation.JsonFormat;


/**
 * 工程采购策划
 * 
 * @author generator
 * 
 */
public class EngineeringProcurementPlanVO extends BaseVO {
    private static final long serialVersionUID = 1L;
    
    private Integer billState; // 单据状态：0自由态，1已提交，2审批中，3审批通过，4驳回，5提交后有人审批中
    private Long projectId; // 项目ID
    private String projectCode; // 项目编码
    private String projectName; // 项目名称
    private Long orgId; // 项目组织ID
    private String orgCode; // 项目组织编码
    private String orgName; // 项目组织名称
    private Long parentOrgId; // 父级组织ID
    private String parentOrgCode; // 父级组织编码
    private String parentOrgName; // 父级组织名称
    private String billCode; // 文件编码
    private Long engineeringTypeId; // 工程类别
    private String fileName; // 文件名称
    private Long projectLeave; // 项目分级(自定义档案)
    private String supervisor; // 监理单位
    private BigDecimal contractTaxMny; // 合同(签订)金额
    private String contractName; // 合同名称
    private Long contractId; // 合同id
    private String memo; // 工程范围
    private String textAttachment; // 正文附件
    private Long textAttachmentId; // 正文附件id
    private Long chiefEngineerId; // 项目总工
    private String chiefEngineer; // 项目总工名称
    private String designer; // 设计单位
    private Long projectManagementId; // 项目经理id
    private String projectManagementName; // 项目经理
    private Long constructId; // 建设单位id
    private String constructName; // 建设单位
    private String area; // 地区
    private String areaName; // 地区
    private String address; // 地址
    private BigDecimal contractMny; // 合同(签订)金额(不含税)
    private String createUserName; // 创建人名称
    private Long submitType; // 文件报审类型
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planStartDate; // 计划开工日期
    @JsonFormat(pattern = "yyyy-MM-dd", timezone = "GMT+8")
    private Date planEndDate; // 计划竣工日期
    private Integer penetratingProject;// 是否穿透式项目(0否1是)
    private Long subOrgId;// 分子公司

    private List<OpinionInfoVO> opinionInfoList; // 意见栏
    

    public Integer getBillState() {
        return billState;
    }

    public void setBillState(Integer billState) {
        this.billState = billState;
    }

    @ReferSerialTransfer(referCode = "project-set")
    public Long getProjectId() {
        return projectId;
    }

    @ReferDeserialTransfer
    public void setProjectId(Long projectId) {
        this.projectId = projectId;
    }
    public String getProjectCode() {
        return projectCode;
    }

    public void setProjectCode(String projectCode) {
        this.projectCode = projectCode;
    }
    public String getProjectName() {
        return projectName;
    }

    public void setProjectName(String projectName) {
        this.projectName = projectName;
    }

    @ReferSerialTransfer(referCode = "idm-org")
    public Long getOrgId() {
        return orgId;
    }

    @ReferDeserialTransfer
    public void setOrgId(Long orgId) {
        this.orgId = orgId;
    }
    public String getOrgCode() {
        return orgCode;
    }

    public void setOrgCode(String orgCode) {
        this.orgCode = orgCode;
    }
    public String getOrgName() {
        return orgName;
    }

    public void setOrgName(String orgName) {
        this.orgName = orgName;
    }

    @ReferSerialTransfer(referCode="idm-org")
    public Long getParentOrgId() {
        return parentOrgId;
    }

    @ReferDeserialTransfer
    public void setParentOrgId(Long parentOrgId) {
        this.parentOrgId = parentOrgId;
    }
    public String getParentOrgCode() {
        return parentOrgCode;
    }

    public void setParentOrgCode(String parentOrgCode) {
        this.parentOrgCode = parentOrgCode;
    }
    public String getParentOrgName() {
        return parentOrgName;
    }

    public void setParentOrgName(String parentOrgName) {
        this.parentOrgName = parentOrgName;
    }
    public String getBillCode() {
        return billCode;
    }

    public void setBillCode(String billCode) {
        this.billCode = billCode;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getEngineeringTypeId() {
        return engineeringTypeId;
    }

    @ReferDeserialTransfer
    public void setEngineeringTypeId(Long engineeringTypeId) {
        this.engineeringTypeId = engineeringTypeId;
    }
    public String getFileName() {
        return fileName;
    }

    public void setFileName(String fileName) {
        this.fileName = fileName;
    }

    @ReferSerialTransfer(referCode="support-defdoc")
    public Long getProjectLeave() {
        return projectLeave;
    }

    @ReferDeserialTransfer
    public void setProjectLeave(Long projectLeave) {
        this.projectLeave = projectLeave;
    }
    public String getSupervisor() {
        return supervisor;
    }

    public void setSupervisor(String supervisor) {
        this.supervisor = supervisor;
    }
    public BigDecimal getContractTaxMny() {
        return contractTaxMny;
    }

    public void setContractTaxMny(BigDecimal contractTaxMny) {
        this.contractTaxMny = contractTaxMny;
    }
    public String getContractName() {
        return contractName;
    }

    public void setContractName(String contractName) {
        this.contractName = contractName;
    }

    @ReferSerialTransfer(referCode="pro-income-contract")
    public Long getContractId() {
        return contractId;
    }

    @ReferDeserialTransfer
    public void setContractId(Long contractId) {
        this.contractId = contractId;
    }
    public String getMemo() {
        return memo;
    }

    public void setMemo(String memo) {
        this.memo = memo;
    }
    public String getTextAttachment() {
        return textAttachment;
    }

    public void setTextAttachment(String textAttachment) {
        this.textAttachment = textAttachment;
    }
    public Long getTextAttachmentId() {
        return textAttachmentId;
    }

    public void setTextAttachmentId(Long textAttachmentId) {
        this.textAttachmentId = textAttachmentId;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getChiefEngineerId() {
        return chiefEngineerId;
    }

    @ReferDeserialTransfer
    public void setChiefEngineerId(Long chiefEngineerId) {
        this.chiefEngineerId = chiefEngineerId;
    }


    public String getChiefEngineer() {
        return chiefEngineer;
    }


    public void setChiefEngineer(String chiefEngineer) {
        this.chiefEngineer = chiefEngineer;
    }
    public String getDesigner() {
        return designer;
    }

    public void setDesigner(String designer) {
        this.designer = designer;
    }

    @ReferSerialTransfer(referCode="idm-employee")
    public Long getProjectManagementId() {
        return projectManagementId;
    }

    @ReferDeserialTransfer
    public void setProjectManagementId(Long projectManagementId) {
        this.projectManagementId = projectManagementId;
    }
    public String getProjectManagementName() {
        return projectManagementName;
    }

    public void setProjectManagementName(String projectManagementName) {
        this.projectManagementName = projectManagementName;
    }

    @ReferSerialTransfer(referCode="support-customer,support-supplier")
    public Long getConstructId() {
        return constructId;
    }

    @ReferDeserialTransfer
    public void setConstructId(Long constructId) {
        this.constructId = constructId;
    }
    public String getConstructName() {
        return constructName;
    }

    public void setConstructName(String constructName) {
        this.constructName = constructName;
    }
    public String getArea() {
        return area;
    }

    public void setArea(String area) {
        this.area = area;
    }
    public String getAreaName() {
        return areaName;
    }

    public void setAreaName(String areaName) {
        this.areaName = areaName;
    }
    public String getAddress() {
        return address;
    }

    public void setAddress(String address) {
        this.address = address;
    }
    public BigDecimal getContractMny() {
        return contractMny;
    }

    public void setContractMny(BigDecimal contractMny) {
        this.contractMny = contractMny;
    }
    public String getCreateUserName() {
        return createUserName;
    }

    public void setCreateUserName(String createUserName) {
        this.createUserName = createUserName;
    }

    @ReferSerialTransfer(referCode = "support-defdoc")
    public Long getSubmitType() {
        return submitType;
    }

    @ReferDeserialTransfer
    public void setSubmitType(Long submitType) {
        this.submitType = submitType;
    }
    public Date getPlanStartDate() {
        return planStartDate;
    }

    public void setPlanStartDate(Date planStartDate) {
        this.planStartDate = planStartDate;
    }
    public Date getPlanEndDate() {
        return planEndDate;
    }

    public void setPlanEndDate(Date planEndDate) {
        this.planEndDate = planEndDate;
    }

    public List<OpinionInfoVO> getOpinionInfoList() {
        return opinionInfoList;
    }

    public void setOpinionInfoList(List<OpinionInfoVO> opinionInfoList) {
        this.opinionInfoList = opinionInfoList;
    }

    public Integer getPenetratingProject() {
        return penetratingProject;
    }

    public void setPenetratingProject(Integer penetratingProject) {
        this.penetratingProject = penetratingProject;
    }
    @ReferSerialTransfer(referCode = "idm-org")
    public Long getSubOrgId() {
        return subOrgId;
    }
    @ReferDeserialTransfer
    public void setSubOrgId(Long subOrgId) {
        this.subOrgId = subOrgId;
    }
}
