/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.util;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.converters.WriteConverterContext;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.data.WriteCellData;
import com.alibaba.excel.write.metadata.style.WriteCellStyle;
import com.ejianc.ztpc.dto.BpmApproveHistoryInfoListDTO;
import java.util.List;
import org.apache.poi.ss.usermodel.HorizontalAlignment;

public class BpmApproveHistoryListConverter
implements Converter<List<BpmApproveHistoryInfoListDTO>> {
    public Class<?> supportJavaTypeKey() {
        return List.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public WriteCellData<?> convertToExcelData(WriteConverterContext<List<BpmApproveHistoryInfoListDTO>> context) {
        List list = (List)context.getValue();
        if (list == null || list.isEmpty()) {
            return new WriteCellData("\u65e0\u5ba1\u6279\u8bb0\u5f55");
        }
        int count = 0;
        int size = list.size();
        StringBuilder sb = new StringBuilder(512);
        int NODE_WIDTH = 14;
        int APPROVER_WIDTH = 16;
        int TIME_WIDTH = 20;
        for (int i = 0; i < size; ++i) {
            BpmApproveHistoryInfoListDTO item = (BpmApproveHistoryInfoListDTO)list.get(i);
            String approveNode = BpmApproveHistoryListConverter.padRight(this.safeGet(item.getApproveNode(), ""), 14);
            String approver = BpmApproveHistoryListConverter.padRight(this.safeGet(item.getApprover(), ""), 16);
            String processTime = BpmApproveHistoryListConverter.padRight(this.safeGet(item.getProcessTime(), "\u65e0"), 20);
            String approveInfo = this.safeGet(item.getApproveInfo(), "\u65e0");
            if ("\u5355\u636e\u63d0\u4ea4".equals(item.getApproveNode())) {
                sb.append(String.format("\u7b2c%-3d\u6b21\u5ba1\u6279------\n", ++count));
            }
            sb.append(String.format("\u5ba1\u6279\u8282\u70b9\uff1a%s \u5ba1\u6279\u4eba\uff1a%s \u5ba1\u6279\u65f6\u95f4\uff1a%s \u5ba1\u6279\u610f\u89c1\uff1a%s\n", approveNode, approver, processTime, approveInfo));
        }
        WriteCellStyle style = new WriteCellStyle();
        style.setWrapped(Boolean.valueOf(true));
        style.setHorizontalAlignment(HorizontalAlignment.LEFT);
        WriteCellData cellData = new WriteCellData(sb.toString());
        cellData.setWriteCellStyle(style);
        return cellData;
    }

    private static int getDisplayWidth(String str) {
        return str.chars().map(c -> c > 127 ? 2 : 1).sum();
    }

    private static String repeat(String str, int times) {
        if (times <= 0) {
            return "";
        }
        return new String(new char[times]).replace("\u0000", str);
    }

    private static String padRight(String str, int targetWidth) {
        int displayWidth = BpmApproveHistoryListConverter.getDisplayWidth(str);
        if (displayWidth >= targetWidth) {
            return str;
        }
        return str + BpmApproveHistoryListConverter.repeat(" ", targetWidth - displayWidth);
    }

    private String safeGet(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }
}

