package com.ejianc.ztpc.enumUtils;

import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.ztpc.bean.*;
import lombok.AllArgsConstructor;
import lombok.Getter;

import java.util.Arrays;

@Getter
@AllArgsConstructor
public enum PageTypeEnum {
    //todo 校验所有对应service
    CONSTRUCTION_SCHEME("constructionScheme", "constructionSchemeService", "施工方案页面", ConstructionSchemeEntity.class),
    PROJECT_MANAGE_PLAN("projectManagePlan", "projectManagePlanService", "项目管理策划页面", ProjectManagePlanEntity.class),
    CONSTRUCTION_PLAN("constructionPlan", "constructionPlanService", "施工总平策划页面", ConstructionPlanEntity.class),
    PROJECT_IMPLEMENT_PLAN("projectImplementPlan", "projectImplementPlanService", "项目实施计划页面", ProjectImplementPlanEntity.class),
    CON_ORG_DESIGN_PLAN("conOrgDesignPlan", "conOrgDesignPlanService", "施工组织设计清单页面", ConOrgDesignPlanEntity.class),
    CT_CON_ORG_DESIGN("ctConOrgDesign", "ctConOrgDesignService", "施工组织设计页面", CtConOrgDesignEntity.class),
    PROJECT_ENDING("projectEnding", "projectEndingService", "收尾管理页面", ProjectEndingEntity.class);
    private final String type;         // 页面类型标识
    private final String serviceName;
    private final String desc;
    private final Class entityClass;

    public static PageTypeEnum getByType(String type) {
        return Arrays.stream(values())
                .filter(e -> e.type.equals(type))
                .findFirst()
                .orElseThrow(() -> new BusinessException("不支持的页面类型"));
    }
}
