package com.ejianc.ztpc.util;

import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.springframework.beans.factory.annotation.Autowired;

import javax.servlet.http.HttpServletResponse;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

public class DocOpinionExportUtil<T> {

    private DocOpinionExportUtil(){}

    public static DocOpinionExportUtil docOpinionExportUtil = new DocOpinionExportUtil();

    public static DocOpinionExportUtil getDocOpinionExportUtil(){
        return docOpinionExportUtil;
    }


    public void exportDoc(T entity, HttpServletResponse response, List<Long> ids, String resource,IBpmApi bpmApi,String name,Long id) {
        Map<String, Object> wordMap = null;
        wordMap = toWordMap(entity, ids , bpmApi,name ,id);
        try {
            try (
                    InputStream resourceAsStream = getClass().getResourceAsStream(resource);
            ) {
                XWPFDocument document = new MyXWPFDocument(resourceAsStream);
                WordExportUtil.exportWord07(document, wordMap);
                ByteArrayOutputStream out = new ByteArrayOutputStream();
                try {
                    document.write(out);
                    out.close();

                } catch (IOException e) {
                    e.printStackTrace();
                }

                // 获取二进制数据
                byte[] fileData = out.toByteArray();

                // 设置HTTP响应头，告诉前端返回的是一个Word文档
                response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
                String fileName = "审核意见汇总(" + getValue(entity,name) + ").docx";
                response.setHeader("Content-Disposition", "attachment; filename=" + fileName);

                // 将字节数组写入到response的输出流中
                try (ByteArrayInputStream bais = new ByteArrayInputStream(fileData)) {
                    byte[] buffer = new byte[1024];
                    int bytesRead;
                    while ((bytesRead = bais.read(buffer)) != -1) {
                        response.getOutputStream().write(buffer, 0, bytesRead);
                    }
                    response.flushBuffer();
                } catch (IOException e) {
                    e.printStackTrace();
                    // 处理异常，确保资源被正确关闭等
                    // 这里你可能需要返回一个错误响应给前端
                }

            }
        } catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> toWordMap(T entity, List<Long> ids,IBpmApi bpmApi,String name,Long id) {
        String projectName = getValue(entity, "projectName").toString();
        String nameValue = getValue(entity, name).toString();
        String opinionInfoList = JSON.toJSONString(getValue(entity, "opinionInfoList"));
        List<OpinionInfoEntity> list = new ArrayList<>();
        if (StringUtils.isNotEmpty(opinionInfoList)){
            JSONArray jsonArray = JSONArray.parseArray(opinionInfoList);
            list = BeanMapper.mapList(jsonArray, OpinionInfoEntity.class);
        }
        CommonResponse<List<BpmApproveHistoryInfo>> response = bpmApi.queryHistoryById(id);
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        Map<String, Object> map = new HashMap<>();
        map.put("projectName", projectName);
        map.put("name", nameValue);
        List<Map<String, Object>> listSubs = new ArrayList<>();
        if (list != null) {
            if (list.size() != 0) {
                for (int i = 0; i < list.size(); i++) {
                    if (ids.contains(list.get(i).getId())) {
                        Map<String, Object> map1 = new HashMap();
                        OpinionInfoEntity info = list.get(i);
                        map1.put("relativeChapter", info.getRelativeChapter());
                        map1.put("originalContent", info.getOriginalContent());
                        map1.put("editOpinion", info.getEditOpinion());
                        map1.put("reminderContentId", info.getReminderContentId() == null ? null : info.getReminderContentId() == 0 ? "必改项" : "建议项");
                        map1.put("whetherAccept", StringUtils.isEmpty(info.getWhetherAccept()) ? "" : "Y".equals(info.getWhetherAccept()) ? "是" : "否");
                        map1.put("proposeUserName", info.getProposeUserName());
                        Integer conclusionId = info.getCertificationConclusionId();
                        map1.put("certificationConclusionId",
                                conclusionId == null ? "" : conclusionId.equals(0) ? "通过" : conclusionId.equals(2) ? "修改后通过" : "不通过"
                        );
                        map1.put("index", i + 1);
                        listSubs.add(map1);
                    }
                }
            }
        }

        List<Map<String, Object>> approverList = new ArrayList<>();
        for (int i = 0; i < response.getData().size(); i++) {
            Map<String, Object> historyMap = new HashMap<>();
            BpmApproveHistoryInfo historyInfo = response.getData().get(i);
            historyMap.put("approver", historyInfo.getApprover());
            historyMap.put("index", i + 1);
            historyMap.put("approveInfo", historyInfo.getApproveInfo());
            historyMap.put("approvalOutcome", historyInfo.getApprovalOutcome());
            approverList.add(historyMap);
        }
        map.put("approverList", approverList);

        map.put("list", listSubs);

        for (String s : map.keySet()) {
            map.putIfAbsent(s, "");
        }

        return map;
    }

    private Object getValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), (Class[]) null);
            try {
                return  m.invoke(t, (Object[]) null);
            } catch (IllegalAccessException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法需要设置成public属性！");
            } catch (InvocationTargetException e) {
                throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】的get方法调用失败！");
            }
        } catch (NoSuchMethodException e) {
            throw new BusinessException("类【" + mainClass + "】的字段【" + code + "】未设置get方法！");
        }
    }
}
