package com.ejianc.ztpc.enumUtils;

import java.util.EnumSet;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;

public enum FlowStateEnum {
    ZERO("0","自由态"),
    ONE("1","已提交"),
    TWO("2","审批中"),
    THREE("3","审批通过"),
    FOUR("4","驳回"),
    FIVE("5","提交后有人审批中"),
    SIX("6","作废");
    private final String code;
    private final String name;
    private static final Map<String, SchemeStateEnum> enumMap;
    private static final Map<String, SchemeStateEnum> enumNameMap;

    private FlowStateEnum(String code, String name) {
        this.code = code;
        this.name = name;
    }

    public String getCode() {
        return code;
    }

    public String getName() {
        return name;
    }

    public static SchemeStateEnum getEnumByCode(String code) {
        return enumMap.get(code);
    }

    public static SchemeStateEnum getEnumByName(String name) {
        return enumNameMap.get(name);
    }

    static {
        enumMap = EnumSet.allOf(SchemeStateEnum.class).stream().collect(Collectors.toMap(SchemeStateEnum::getCode, Function.identity(), (k1, k2) -> k2));
        enumNameMap = EnumSet.allOf(SchemeStateEnum.class).stream().collect(Collectors.toMap(SchemeStateEnum::getName, Function.identity(), (k1, k2) -> k2));
    }

}
