/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.util;

import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONArray;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;

public class DocOpinionExportUtil<T> {
    public static DocOpinionExportUtil docOpinionExportUtil = new DocOpinionExportUtil();

    private DocOpinionExportUtil() {
    }

    public static DocOpinionExportUtil getDocOpinionExportUtil() {
        return docOpinionExportUtil;
    }

    public void exportDoc(T entity, HttpServletResponse response, List<Long> ids, String resource, IBpmApi bpmApi, String name, Long id) {
        Map<String, Object> wordMap = null;
        wordMap = this.toWordMap(entity, ids, bpmApi, name, id);
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream(resource);){
            MyXWPFDocument document = new MyXWPFDocument(resourceAsStream);
            WordExportUtil.exportWord07((XWPFDocument)document, wordMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                document.write((OutputStream)out);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] fileData = out.toByteArray();
            response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            String fileName = "\u5ba1\u6838\u610f\u89c1\u6c47\u603b(" + this.getValue(entity, name) + ").docx";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(fileData);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = bais.read(buffer)) != -1) {
                    response.getOutputStream().write(buffer, 0, bytesRead);
                }
                response.flushBuffer();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    public Map<String, Object> toWordMap(T entity, List<Long> ids, IBpmApi bpmApi, String name, Long id) {
        CommonResponse response;
        String projectName = this.getValue(entity, "projectName").toString();
        String nameValue = this.getValue(entity, name).toString();
        String opinionInfoList = JSON.toJSONString((Object)this.getValue(entity, "opinionInfoList"));
        List list = new ArrayList();
        if (StringUtils.isNotEmpty((CharSequence)opinionInfoList)) {
            JSONArray jsonArray = JSONArray.parseArray((String)opinionInfoList);
            list = BeanMapper.mapList((Iterable)jsonArray, OpinionInfoEntity.class);
        }
        if (!(response = bpmApi.queryHistoryById(id)).isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", projectName);
        map.put("name", nameValue);
        ArrayList listSubs = new ArrayList();
        if (list != null && list.size() != 0) {
            for (int i = 0; i < list.size(); ++i) {
                if (!ids.contains(((OpinionInfoEntity)((Object)list.get(i))).getId())) continue;
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                OpinionInfoEntity info = (OpinionInfoEntity)((Object)list.get(i));
                map1.put("relativeChapter", info.getRelativeChapter());
                map1.put("originalContent", info.getOriginalContent());
                map1.put("editOpinion", info.getEditOpinion());
                map1.put("reminderContentId", info.getReminderContentId() == null ? null : (info.getReminderContentId() == 0 ? "\u5fc5\u6539\u9879" : "\u5efa\u8bae\u9879"));
                map1.put("whetherAccept", StringUtils.isEmpty((CharSequence)info.getWhetherAccept()) ? "" : ("Y".equals(info.getWhetherAccept()) ? "\u662f" : "\u5426"));
                map1.put("proposeUserName", info.getProposeUserName());
                Integer conclusionId = info.getCertificationConclusionId();
                map1.put("certificationConclusionId", conclusionId == null ? "" : (conclusionId.equals(0) ? "\u901a\u8fc7" : (conclusionId.equals(2) ? "\u4fee\u6539\u540e\u901a\u8fc7" : "\u4e0d\u901a\u8fc7")));
                map1.put("index", i + 1);
                listSubs.add(map1);
            }
        }
        ArrayList approverList = new ArrayList();
        for (int i = 0; i < ((List)response.getData()).size(); ++i) {
            HashMap<String, Object> historyMap = new HashMap<String, Object>();
            BpmApproveHistoryInfo historyInfo = (BpmApproveHistoryInfo)((List)response.getData()).get(i);
            historyMap.put("approver", historyInfo.getApprover());
            historyMap.put("index", i + 1);
            historyMap.put("approveInfo", historyInfo.getApproveInfo());
            historyMap.put("approvalOutcome", historyInfo.getApprovalOutcome());
            approverList.add(historyMap);
        }
        map.put("approverList", approverList);
        map.put("list", listSubs);
        for (String s : map.keySet()) {
            map.putIfAbsent(s, "");
        }
        return map;
    }

    private Object getValue(T t, String code) {
        Class<?> mainClass = t.getClass();
        try {
            Method m = mainClass.getDeclaredMethod("get" + code.substring(0, 1).toUpperCase() + code.substring(1), null);
            try {
                return m.invoke(t, (Object[])null);
            }
            catch (IllegalAccessException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u9700\u8981\u8bbe\u7f6e\u6210public\u5c5e\u6027\uff01");
            }
            catch (InvocationTargetException e) {
                throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u7684get\u65b9\u6cd5\u8c03\u7528\u5931\u8d25\uff01");
            }
        }
        catch (NoSuchMethodException e) {
            throw new BusinessException("\u7c7b\u3010" + mainClass + "\u3011\u7684\u5b57\u6bb5\u3010" + code + "\u3011\u672a\u8bbe\u7f6eget\u65b9\u6cd5\uff01");
        }
    }
}

