package com.ejianc.ztpc.aspect;

import com.alibaba.fastjson.JSON;
import lombok.extern.slf4j.Slf4j;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.springframework.stereotype.Component;

/**
 * 用于记录控制层接口的入参出参
 */
@Aspect
@Component
@Slf4j
public class LogAspect {

    @Pointcut("execution(public * com.ejianc.ztpc.controller..*Controller.*(..)) " +
            "&& (@annotation(org.springframework.web.bind.annotation.RequestMapping))")
    public void privilege() {
    }

    /**
     * 环绕通知
     * @param pjd
     * @return
     * @throws Throwable
     */
    @Around("privilege()")
    public Object around(ProceedingJoinPoint pjd) throws Throwable {
        long startTime = System.currentTimeMillis();

        // 类名
        String className = pjd.getTarget().getClass().getName();
        // 获取执行的方法名称
        String methodName = pjd.getSignature().getName();

        Object[] args = pjd.getArgs();
        if (args.length > 0) {
            try {
                // 针对 MultipartFile 类型参数特殊处理
                String params;
                if (args[0] instanceof org.springframework.web.multipart.MultipartFile) {
                    params = "(MultipartFile)";
                } else if (args[0] instanceof org.springframework.web.multipart.MultipartFile[]) {
                    params = "(MultipartFile[])";
                } else {
                    params = JSON.toJSONString(args[0]);
                }
                //打印请求参数参数
                log.info("{}.{}()【请求入参】：{}", className, methodName, params);
            } catch (Exception e) {
                log.info("{}.{}()【请求入参打印失败】：{}", className, methodName, e);
            }
        } else {
            log.info("{}.{}()【请求无参数】", className, methodName);
        }

        Object result = pjd.proceed();        // 打印返回结果
//        try {
//            String s = JSON.toJSONString(result);
//            log.info("{}.{}()【请求返回结果为】：{}", className, methodName, s);
//        } catch (Exception e) {
//            log.info("{}.{}()【方法返回结果打印失败】：{}", className, methodName, e);
//        }

        // 获取执行完的时间
        long time = System.currentTimeMillis() - startTime;
        log.info("{}.{}()【执行时长为】：{}{}", className, methodName, time, " ms");
        return result;
    }

}


