package com.ejianc.ztpc.service.impl;

import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.vo.DrawingCheckImportVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.ztpc.mapper.DrawingCheckMapper;
import com.ejianc.ztpc.bean.DrawingCheckEntity;
import com.ejianc.ztpc.service.IDrawingCheckService;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

import javax.servlet.http.HttpServletRequest;
import java.util.*;
import java.util.function.Function;
import java.util.stream.Collectors;

/**
 * 图纸会检表
 * 
 * @author generator
 * 
 */
@Service("drawingCheckService")
public class DrawingCheckServiceImpl extends BaseServiceImpl<DrawingCheckMapper, DrawingCheckEntity> implements IDrawingCheckService{
    /*
     * 日志
     */
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private DrawingCheckMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;

    @Override
    public CommonResponse<JSONObject> excelDrawingCheckImport(HttpServletRequest request) {
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest) request;
        Map<String, MultipartFile> fileMap = multipartRequest.getFileMap();
        boolean isFailed = false;
        MultipartFile mf = null;
        List<DrawingCheckImportVO> successList = new ArrayList<>();
        List<DrawingCheckImportVO> errorList = new ArrayList<>();
        Map dictionaryQueryMap = new HashMap();
        //人
        List<Map<String, Object>> employeeList = Lists.newArrayList();
        CommonResponse<List<Map<String, Object>>> employeeResponse = iExternalApi.getMapAllEmployee();
        if (employeeResponse.isSuccess()&& ListUtil.isNotEmpty(employeeResponse.getData())) {
            employeeList = employeeResponse.getData();
        }
        Map<String, Map<String,Object>> employee = employeeList.stream().collect(
                Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
        );
        for (Map.Entry<String, MultipartFile> entity : fileMap.entrySet()) {
            mf = entity.getValue();
            String originalFileName = mf.getOriginalFilename();
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            String extName = FileUtils.getFileExt(originalFileName, false);
            if (!"xls".equals(extName) && !"xlsx".equals(extName)) {
                isFailed = true;
                break;
            }
        }
        if (isFailed) {
            return CommonResponse.error("文件格式不合法");
        } else {
            List<List<String>> result = ExcelReader.readExcel(mf);
            Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
            if (size != 1) {
                return CommonResponse.error("文件页签不完整，请下载最新模板！");
            } else {
                if (result != null && result.size() > 0) {
                    if (result.size() > 10000) {
                        return CommonResponse.error("导入信息超过10000条，请分批上传！");
                    }
                    Map<String, Map<String, Object>> projDataMapAll = mapper.queryMapProjAll().stream().collect(
                            Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2)
                    );
                    List<Map<String, Object>> mapProjLocal = Lists.newArrayList();
                    CommonResponse<List<Map<String, Object>>> response = iExternalApi.getMapProjLocal();
                    if (response.isSuccess()) {
                        mapProjLocal = response.getData();
                    }
                    Map<String, Map<String,Object>> projDataMap = mapProjLocal.stream().collect(
                            Collectors.toMap(e->String.valueOf(e.get("name")), Function.identity(),(e1,e2)->e2)
                    );

                    for (int i = 0; i < result.size(); i++) {
                        boolean flag = true;
                        List<String> datas = result.get(i);
                        StringBuilder errorMessage = new StringBuilder("");
                        DrawingCheckImportVO vo = new DrawingCheckImportVO();
                        vo.setId(IdWorker.getId());

                        // 工程名称
                        String projectName = datas.get(0);
                        Map<String, Object> projectNameMap = projDataMap.get(projectName);
                        if (StringUtils.isBlank(projectName) || MapUtils.isEmpty(projectNameMap)) {
                            errorMessage.append("[项目名称]").append(projectName).append(":错误参照无法获取;");
                            flag = false;
                        } else {
                            vo.setProjectName((String) projectNameMap.get("name"));
                            vo.setProjectCode((String) projectNameMap.get("code"));
                            Object id = projectNameMap.get("id");
                            if (id instanceof String) {
                                vo.setProjectId(Long.parseLong((String) id));
                            } else {
                                vo.setProjectId((Long) id);
                            }
                        }
                        //1 主持人compere-选择
                        String compere = datas.get(1);
                        if (ToolUtil.isNotEmpty(compere)){
                            Map<String, Object> stringObjectMap = employee.get(compere);
                            if (stringObjectMap == null){
                                errorMessage.append("[主持人]" + compere + ":错误参照无法获取;");
                                flag = false;
                            }else {
                                try {
                                    vo.setCompere(Long.parseLong(stringObjectMap.get("id").toString()));
                                }catch (Exception e){
                                    logger.info(e.getMessage()+";"+stringObjectMap.toString()+";");
                                    errorMessage.append("[主持人]" + compere + ":错误参照无法获取;");
                                    flag = false;
                                }
                            }
                        }
                        //2 会审编码joint_trial_code
                        String jointTrialCode = datas.get(2);
                        if (StringUtils.isBlank(jointTrialCode)) {
//                            errorMessage.append("[会审编码]为空;");
//                            flag = false;
                        } else {
                            vo.setJointTrialCode(jointTrialCode);
                        }
                        //3 会审地点joint_trial_place
                        String jointTrialPlace = datas.get(3);
                        if (StringUtils.isBlank(jointTrialPlace)) {
                            errorMessage.append("[会审地点]为空;");
                            flag = false;
                        } else {
                            vo.setJointTrialPlace(jointTrialPlace);
                        }
                        //4 会审日期joint_trial_date
                        String jointTrialDate = datas.get(4);
                        if (StringUtils.isBlank(jointTrialDate)) {
//                            errorMessage.append("[会审日期]为空;");
//                            flag = false;
                        } else {
                            try {
                                vo.setJointTrialDate(DateUtils.parseDate(jointTrialDate, "yyyy-MM-dd"));
                            } catch (Exception e) {
                                errorMessage.append("[会审日期]日期格式错误;");
                                flag = false;
                                if (logger.isErrorEnabled()) {
                                    logger.error("图纸会表 导入-校验数据 失败！会审日期的日期格式错误");
                                }
                            }
                        }
                        //5 机组mgrp-选择(字典mgrp)
                        String mgrpName = datas.get(5);
                        if (ToolUtil.isNotEmpty(mgrpName)) {
                            dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                            dictionaryQueryMap.put("categoryCode", "mgrp");
                            CommonResponse<List<DataDictionaryVO>> mgrpCommonResponse = billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                            if (mgrpCommonResponse.isSuccess()) {
                                List<DataDictionaryVO> data = mgrpCommonResponse.getData();
                                if (data != null) {
                                    DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                    if (dataDictionaryVO == null) {
                                        errorMessage.append("[机组]").append(mgrpName).append(":错误参照无法获取;");
                                        flag = false;
                                    } else {
                                        vo.setMgrp(dataDictionaryVO.getId());
                                    }
                                }
                            }
                        }
                        //6 系统sys-选择(字典sys)
                        String sysName = datas.get(6);
                        if (ToolUtil.isNotEmpty(sysName)) {
                            dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                            dictionaryQueryMap.put("categoryCode", "sys");
                            CommonResponse<List<DataDictionaryVO>> sysCommonResponse = billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                            if (sysCommonResponse.isSuccess()) {
                                List<DataDictionaryVO> data = sysCommonResponse.getData();
                                if (data != null) {
                                    DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> sysName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                    if (dataDictionaryVO == null) {
                                        errorMessage.append("[系统]").append(sysName).append(":错误参照无法获取;");
                                        flag = false;
                                    } else {
                                        vo.setSys(dataDictionaryVO.getId());
                                    }
                                }
                            }
                        }
                        //7 专业specialty-选择(字典specialty)
                        String specialtyName = datas.get(7);
                        if (StringUtils.isBlank(specialtyName)) {
                            errorMessage.append("[专业]为空;");
                            flag = false;
                        }
                        if (ToolUtil.isNotEmpty(specialtyName)) {
                            dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                            dictionaryQueryMap.put("categoryCode", "specialty");
                            CommonResponse<List<DataDictionaryVO>> specialtyCommonResponse = billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                            if (specialtyCommonResponse.isSuccess()) {
                                List<DataDictionaryVO> data = specialtyCommonResponse.getData();
                                if (data != null) {
                                    DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> specialtyName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                    if (dataDictionaryVO == null) {
                                        errorMessage.append("[专业]").append(specialtyName).append(":错误参照无法获取;");
                                        flag = false;
                                    } else {
                                        vo.setSpecialty(dataDictionaryVO.getId());
                                    }
                                }
                            }
                        }
                        //8 会审类别joint_trial_type-下拉(字典ct_joint_trial_type)
                        String jointTrialTypeName = datas.get(8);
                        if (ToolUtil.isNotEmpty(jointTrialTypeName)) {
                            dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                            dictionaryQueryMap.put("categoryCode", "ct_joint_trial_type");
                            CommonResponse<List<DataDictionaryVO>> jointTrialTypeCommonResponse = billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                            if (jointTrialTypeCommonResponse.isSuccess()) {
                                List<DataDictionaryVO> data = jointTrialTypeCommonResponse.getData();
                                if (data != null) {
                                    DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> jointTrialTypeName.equals(a.getDictionaryName())).findFirst().orElse(null);
                                    if (dataDictionaryVO == null) {
                                        errorMessage.append("[会审类别]").append(jointTrialTypeName).append(":错误参照无法获取;");
                                        flag = false;
                                    } else {
                                        vo.setJointTrialType(dataDictionaryVO.getId());
                                    }
                                }
                            }
                        }
                        //9 施工图纸会审意见construction_opinion
                        String constructionOpinion = datas.get(9);
                        if (StringUtils.isBlank(constructionOpinion)) {
                            errorMessage.append("[施工图纸会审意见]为空;");
                            flag = false;
                        } else {
                            vo.setConstructionOpinion(constructionOpinion);
                        }
                        //10 会审意见闭环joint_trial_opinion
                        String jointTrialOpinion = datas.get(10);
                        if (StringUtils.isBlank(jointTrialOpinion)) {
                            errorMessage.append("[会审意见闭环]为空;");
                            flag = false;
                        } else {
                            vo.setJointTrialOpinion(jointTrialOpinion);
                        }

                        //外部编码
                        String outsideCode = datas.get(11);
                        if (ToolUtil.isNotEmpty(outsideCode)){
                            vo.setOutsideCode(outsideCode);
                        }

                        //区域定位码
                        String locationCodeName = datas.get(12);
                        if (ToolUtil.isNotEmpty(locationCodeName)){
                            Map<String, String> map = new HashMap<>();
                            map.put("categoryName", locationCodeName);
                            CommonResponse<Map<String, Long>> mapCommonResponse = billCodeRuleApi.materialClassificationTree(map);
                            if (mapCommonResponse.isSuccess()) {
                                Map<String, Long> data = mapCommonResponse.getData();
                                if (ToolUtil.isNotEmpty(data)) {
                                    Long id = data.get("name");
                                    vo.setLocationCode(id);
                                }
                            }
                        }

                        // 编制部门
//                        vo.setRedactDept(sessionManager.getUserContext().getDeptId());
                        vo.setRowIndex((i + 2));
                        Map<String, Object> stringStringMap = projDataMapAll.get(String.valueOf(vo.getProjectId()));
//                        System.out.println("stringStringMap:"+stringStringMap);
                        CommonResponse<OrgVO> orgVO = iOrgApi.getOneById((Long) stringStringMap.get("orgId"));
                        if (!orgVO.isSuccess()) {
                            errorMessage.append("[项目无对应组织]");
                        }
                        vo.setOrgId((Long) stringStringMap.get("orgId"));
                        vo.setOrgCode(orgVO.getData().getCode());
                        vo.setOrgName(orgVO.getData().getName());
                        vo.setParentOrgId((Long) stringStringMap.get("parentOrgId"));
                        vo.setParentOrgCode((String) stringStringMap.get("parentOrgCode"));
                        vo.setParentOrgName((String) stringStringMap.get("parentOrgName"));
                        if (flag) {
                            successList.add(vo);
                        } else {
                            vo.setErrorMessage(errorMessage.toString());
                            errorList.add(vo);
                        }
                    }
                }
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(DrawingCheckImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success(json);
    }

}
