package com.ejianc.ztpc.util;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.ejianc.ztpc.dto.BpmApproveHistoryInfoListDTO;

import java.util.ArrayList;
import java.util.List;

public class BpmApproveHistoryListConverter implements Converter<List<BpmApproveHistoryInfoListDTO>> {

    @Override
    public Class supportJavaTypeKey() {
        // 支持List接口及其所有实现类
        return List.class;
    }

    @Override
    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    /**
     * 这个方法在EasyExcel 2.1.6中用于Java对象转Excel
     */
    @Override
    public CellData convertToExcelData(List<BpmApproveHistoryInfoListDTO> list, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        // 显式处理null情况
        if (list == null) {
            return new CellData("无审批记录");
        }
        
        // 显式处理空列表情况
        if (list.isEmpty()) {
            return new CellData("无审批记录");
        }

        int count = 0;
        int size = list.size();
        StringBuilder sb = new StringBuilder(512);

        final int NODE_WIDTH = 14;
        final int APPROVER_WIDTH = 16;
        final int TIME_WIDTH = 20;

        for (int i = 0; i < size; i++) {
            BpmApproveHistoryInfoListDTO item = list.get(i);
            // 防止item为null
            if (item == null) continue;

            String approveNode = padRight(safeGet(item.getApproveNode(), ""), NODE_WIDTH);
            String approver = padRight(safeGet(item.getApprover(), ""), APPROVER_WIDTH);
            String processTime = padRight(safeGet(item.getProcessTime(), "无"), TIME_WIDTH);
            String approveInfo = safeGet(item.getApproveInfo(), "无");

            if ("单据提交".equals(item.getApproveNode())) {
                sb.append(String.format("第%-3d次审批------\n", ++count));
            }
            sb.append(String.format("审批节点：%s 审批人：%s 审批时间：%s 审批意见：%s\n",
                    approveNode, approver, processTime, approveInfo));
        }

        // 如果最终没有内容，返回默认文本
        if (sb.length() == 0) {
            return new CellData("无审批记录");
        }

        return new CellData(sb.toString());
    }

    /**
     * 这个方法在EasyExcel 2.1.6中用于Excel读取转Java对象，我们的场景不需要，但必须实现
     */
    @Override
    public List<BpmApproveHistoryInfoListDTO> convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        // 返回空ArrayList而不是null
        return new ArrayList<>();
    }

    private static int getDisplayWidth(String str) {
        if (str == null) return 0;
        return str.chars()
                .map(c -> (c > 127) ? 2 : 1) // 中文/全角字符计2，英文计1
                .sum();
    }
    
    private static String repeat(String str, int times) {
        if (times <= 0) return "";
        return new String(new char[times]).replace("\0", str);
    }

    private static String padRight(String str, int targetWidth) {
        if (str == null) return repeat(" ", targetWidth);
        int displayWidth = getDisplayWidth(str);
        if (displayWidth >= targetWidth) return str;
        return str + repeat(" ", targetWidth - displayWidth);
    }

    private String safeGet(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }
}