/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.mapper.OpinionInfoMapper;
import com.ejianc.ztpc.service.IOpinionInfoService;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.lang3.StringUtils;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service(value="opinionInfoService")
public class OpinionInfoServiceImpl
extends BaseServiceImpl<OpinionInfoMapper, OpinionInfoEntity>
implements IOpinionInfoService {
    @Autowired
    private IBpmApi bpmApi;

    @Override
    public Map<String, Object> toWordMap(ConstructionSchemeEntity entity, List<Long> ids) {
        CommonResponse response = this.bpmApi.queryHistoryById(entity.getId());
        if (!response.isSuccess()) {
            throw new BusinessException(response.getMsg());
        }
        HashMap<String, Object> map = new HashMap<String, Object>();
        map.put("projectName", entity.getProjectName());
        map.put("consSchemeName", entity.getConsSchemeName());
        ArrayList listSubs = new ArrayList();
        if (entity.getOpinionInfoList() != null && entity.getOpinionInfoList().size() != 0) {
            for (int i = 0; i < entity.getOpinionInfoList().size(); ++i) {
                if (!ids.contains(entity.getOpinionInfoList().get(i).getId())) continue;
                HashMap<String, Object> map1 = new HashMap<String, Object>();
                OpinionInfoEntity info = entity.getOpinionInfoList().get(i);
                map1.put("relativeChapter", info.getRelativeChapter());
                map1.put("originalContent", info.getOriginalContent());
                map1.put("editOpinion", info.getEditOpinion());
                map1.put("reminderContentId", info.getReminderContentId() == null ? null : (info.getReminderContentId() == 0 ? "\u5fc5\u6539\u9879" : "\u5efa\u8bae\u9879"));
                map1.put("whetherAccept", StringUtils.isEmpty((CharSequence)info.getWhetherAccept()) ? "" : ("Y".equals(info.getWhetherAccept()) ? "\u662f" : "\u5426"));
                map1.put("proposeUserName", info.getProposeUserName());
                Integer conclusionId = info.getCertificationConclusionId();
                map1.put("certificationConclusionId", conclusionId == null ? "" : (conclusionId.equals(0) ? "\u901a\u8fc7" : (conclusionId.equals(2) ? "\u4fee\u6539\u540e\u901a\u8fc7" : "\u4e0d\u901a\u8fc7")));
                map1.put("index", i + 1);
                listSubs.add(map1);
            }
        }
        ArrayList approverList = new ArrayList();
        for (int i = 0; i < ((List)response.getData()).size(); ++i) {
            HashMap<String, Object> historyMap = new HashMap<String, Object>();
            BpmApproveHistoryInfo historyInfo = (BpmApproveHistoryInfo)((List)response.getData()).get(i);
            historyMap.put("approver", historyInfo.getApprover());
            historyMap.put("index", i + 1);
            historyMap.put("approveInfo", historyInfo.getApproveInfo());
            historyMap.put("approvalOutcome", historyInfo.getApprovalOutcome());
            approverList.add(historyMap);
        }
        map.put("approverList", approverList);
        map.put("list", listSubs);
        for (String s : map.keySet()) {
            map.putIfAbsent(s, "");
        }
        return map;
    }
}

