package com.ejianc.ztpc.util;

import com.ejianc.framework.core.util.ComputeUtil;
import org.springframework.stereotype.Component;

import java.math.BigDecimal;
import java.util.List;
import java.util.Map;


@Component
public class UpSumUtil {



    /**
     * 向上汇总金额
     *
     * @param list    树形结构，必须有children字段
     * @param columns 需要汇总的字段
     * @return
     */
    public List<Map<String, Object>> upSum(List<Map<String, Object>> list, String... columns) {
        for (Map t : list) {
            Object childrenObject = t.get("children");
            List children = null;
            if (childrenObject instanceof List){
                children = (List) childrenObject;
            }
            if (children != null && children.size() > 0) {
                List c = upSum(children, columns);
                sumColumns(t, c, columns);
            }
        }
        return list;
    }

    private void sumColumns(Map<String, Object> t, List<Map<String, Object>> children, String... columns) {
        for (String column : columns) {
            Long sum = 0L;
            for (Map<String, Object> c : children) {
                Object o = c.get(column);
                if (o !=null ){
                    sum = sum + Long.parseLong(o.toString());
                }
            }
            Object o = t.get(column);
            if (o == null){
                t.put(column,sum);
            }
        }
        t.put("children",children);
    }


}
