/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.util;

import com.alibaba.excel.converters.Converter;
import com.alibaba.excel.enums.CellDataTypeEnum;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.GlobalConfiguration;
import com.alibaba.excel.metadata.property.ExcelContentProperty;
import com.ejianc.ztpc.dto.BpmApproveHistoryInfoListDTO;
import java.util.ArrayList;
import java.util.List;

public class BpmApproveHistoryListConverter
implements Converter<List<BpmApproveHistoryInfoListDTO>> {
    public Class supportJavaTypeKey() {
        return List.class;
    }

    public CellDataTypeEnum supportExcelTypeKey() {
        return CellDataTypeEnum.STRING;
    }

    public CellData convertToExcelData(List<BpmApproveHistoryInfoListDTO> list, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        if (list == null) {
            return new CellData("\u65e0\u5ba1\u6279\u8bb0\u5f55");
        }
        if (list.isEmpty()) {
            return new CellData("\u65e0\u5ba1\u6279\u8bb0\u5f55");
        }
        int count = 0;
        int size = list.size();
        StringBuilder sb = new StringBuilder(512);
        int NODE_WIDTH = 14;
        int APPROVER_WIDTH = 16;
        int TIME_WIDTH = 20;
        for (int i = 0; i < size; ++i) {
            BpmApproveHistoryInfoListDTO item = list.get(i);
            if (item == null) continue;
            String approveNode = BpmApproveHistoryListConverter.padRight(this.safeGet(item.getApproveNode(), ""), 14);
            String approver = BpmApproveHistoryListConverter.padRight(this.safeGet(item.getApprover(), ""), 16);
            String processTime = BpmApproveHistoryListConverter.padRight(this.safeGet(item.getProcessTime(), "\u65e0"), 20);
            String approveInfo = this.safeGet(item.getApproveInfo(), "\u65e0");
            if ("\u5355\u636e\u63d0\u4ea4".equals(item.getApproveNode())) {
                sb.append(String.format("\u7b2c%-3d\u6b21\u5ba1\u6279------\n", ++count));
            }
            sb.append(String.format("\u5ba1\u6279\u8282\u70b9\uff1a%s \u5ba1\u6279\u4eba\uff1a%s \u5ba1\u6279\u65f6\u95f4\uff1a%s \u5ba1\u6279\u610f\u89c1\uff1a%s\n", approveNode, approver, processTime, approveInfo));
        }
        if (sb.length() == 0) {
            return new CellData("\u65e0\u5ba1\u6279\u8bb0\u5f55");
        }
        return new CellData(sb.toString());
    }

    public List<BpmApproveHistoryInfoListDTO> convertToJavaData(CellData cellData, ExcelContentProperty contentProperty, GlobalConfiguration globalConfiguration) throws Exception {
        return new ArrayList<BpmApproveHistoryInfoListDTO>();
    }

    private static int getDisplayWidth(String str) {
        if (str == null) {
            return 0;
        }
        return str.chars().map(c -> c > 127 ? 2 : 1).sum();
    }

    private static String repeat(String str, int times) {
        if (times <= 0) {
            return "";
        }
        return new String(new char[times]).replace("\u0000", str);
    }

    private static String padRight(String str, int targetWidth) {
        if (str == null) {
            return BpmApproveHistoryListConverter.repeat(" ", targetWidth);
        }
        int displayWidth = BpmApproveHistoryListConverter.getDisplayWidth(str);
        if (displayWidth >= targetWidth) {
            return str;
        }
        return str + BpmApproveHistoryListConverter.repeat(" ", targetWidth - displayWidth);
    }

    private String safeGet(String value, String defaultValue) {
        return value != null ? value : defaultValue;
    }
}

