/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.aspect;

import com.alibaba.fastjson.JSON;
import org.aspectj.lang.ProceedingJoinPoint;
import org.aspectj.lang.annotation.Around;
import org.aspectj.lang.annotation.Aspect;
import org.aspectj.lang.annotation.Pointcut;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.stereotype.Component;
import org.springframework.web.multipart.MultipartFile;

@Aspect
@Component
public class LogAspect {
    private static final Logger log = LoggerFactory.getLogger(LogAspect.class);

    @Pointcut(value="execution(public * com.ejianc.ztpc.controller..*Controller.*(..)) && (@annotation(org.springframework.web.bind.annotation.RequestMapping))")
    public void privilege() {
    }

    @Around(value="privilege()")
    public Object around(ProceedingJoinPoint pjd) throws Throwable {
        long startTime = System.currentTimeMillis();
        String className = pjd.getTarget().getClass().getName();
        String methodName = pjd.getSignature().getName();
        Object[] args = pjd.getArgs();
        if (args.length > 0) {
            try {
                String params = args[0] instanceof MultipartFile ? "(MultipartFile)" : (args[0] instanceof MultipartFile[] ? "(MultipartFile[])" : JSON.toJSONString((Object)args[0]));
                log.info("{}.{}()\u3010\u8bf7\u6c42\u5165\u53c2\u3011\uff1a{}", new Object[]{className, methodName, params});
            }
            catch (Exception e) {
                log.info("{}.{}()\u3010\u8bf7\u6c42\u5165\u53c2\u6253\u5370\u5931\u8d25\u3011\uff1a{}", new Object[]{className, methodName, e});
            }
        } else {
            log.info("{}.{}()\u3010\u8bf7\u6c42\u65e0\u53c2\u6570\u3011", (Object)className, (Object)methodName);
        }
        Object result = pjd.proceed();
        long time = System.currentTimeMillis() - startTime;
        log.info("{}.{}()\u3010\u6267\u884c\u65f6\u957f\u4e3a\u3011\uff1a{}{}", new Object[]{className, methodName, time, " ms"});
        return result;
    }
}

