/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.controller;

import cn.afterturn.easypoi.word.WordExportUtil;
import cn.afterturn.easypoi.word.entity.MyXWPFDocument;
import com.alibaba.fastjson.JSON;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.update.LambdaUpdateWrapper;
import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.auth.session.UserContext;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.bean.OpinionInfoEntity;
import com.ejianc.ztpc.enumUtils.PageTypeEnum;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.service.IOpinionInfoService;
import com.ejianc.ztpc.vo.OpinionInfoVO;
import com.ejianc.ztpc.vo.SaveOrUpdateOpinionVO;
import java.io.ByteArrayInputStream;
import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.InvocationTargetException;
import java.lang.reflect.Method;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.poi.xwpf.usermodel.XWPFDocument;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.context.ApplicationContext;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestBody;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"opinionInfo"})
public class OpinionInfoController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private IOpinionInfoService service;
    @Autowired
    private IConstructionSchemeService constructionSchemeService;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private ApplicationContext applicationContext;

    @RequestMapping(value={"/saveOrUpdate"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<OpinionInfoVO> saveOrUpdate(@RequestBody OpinionInfoVO saveOrUpdateVO) {
        OpinionInfoEntity entity = (OpinionInfoEntity)((Object)BeanMapper.map((Object)((Object)saveOrUpdateVO), OpinionInfoEntity.class));
        this.service.saveOrUpdate((Object)entity, false);
        OpinionInfoVO vo = (OpinionInfoVO)((Object)BeanMapper.map((Object)((Object)entity), OpinionInfoVO.class));
        return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/saveOrUpdateList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<List<OpinionInfoVO>> saveOrUpdate(@RequestBody SaveOrUpdateOpinionVO vo) {
        List<OpinionInfoVO> saveOrUpdateVOList = vo.getOpinionInfoList();
        if (saveOrUpdateVOList == null || saveOrUpdateVOList.size() == 0) {
            return CommonResponse.error((String)"\u53c2\u6570\u4e3a\u7a7a");
        }
        this.logger.info("\u4f20\u5165\u6570\u636e:" + JSON.toJSONString(saveOrUpdateVOList));
        Long userid = InvocationInfoProxy.getUserid();
        this.logger.info("\u7528\u6237\u4fe1\u606f:" + userid);
        for (OpinionInfoVO opinionInfo : saveOrUpdateVOList) {
            Long proposeUserId = opinionInfo.getProposeUserId();
            OpinionInfoEntity entity = (OpinionInfoEntity)((Object)BeanMapper.map((Object)((Object)opinionInfo), OpinionInfoEntity.class));
            if (userid != null && userid.equals(proposeUserId)) {
                this.logger.info("\u5df2\u7ecf\u4fee\u6539\u4fdd\u5b58\u7684\u610f\u89c1:" + JSON.toJSONString((Object)((Object)opinionInfo)));
                opinionInfo.setTenantId(InvocationInfoProxy.getTenantid());
                this.service.saveOrUpdate((Object)entity);
                continue;
            }
            this.service.update((Wrapper)((LambdaUpdateWrapper)((LambdaUpdateWrapper)new UpdateWrapper().lambda().eq(BaseEntity::getId, (Object)opinionInfo.getId())).set(OpinionInfoEntity::getWhetherAccept, (Object)opinionInfo.getWhetherAccept())).set(OpinionInfoEntity::getAbarbeitungCase, (Object)opinionInfo.getAbarbeitungCase()));
        }
        String type = vo.getType();
        if (StringUtils.isBlank((CharSequence)type)) {
            throw new BusinessException("\u9875\u9762\u7c7b\u578b\u4e3a\u7a7a");
        }
        PageTypeEnum pageType = PageTypeEnum.getByType(vo.getType());
        String serviceName = pageType.getServiceName();
        Object service = this.applicationContext.getBean(serviceName);
        try {
            Method selectByIdMethod = null;
            selectByIdMethod = service.getClass().getMethod("selectById", Serializable.class);
            Object entity = selectByIdMethod.invoke(service, saveOrUpdateVOList.get(0).getPid());
            Field opinionListField = pageType.getEntityClass().getDeclaredField("opinionInfoList");
            opinionListField.setAccessible(true);
            List opinionList = (List)opinionListField.get(entity);
            List opinionInfoVOS = BeanMapper.mapList((Iterable)opinionList, OpinionInfoVO.class);
            return CommonResponse.success((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u6210\u529f\uff01", (Object)opinionInfoVOS);
        }
        catch (IllegalAccessException | NoSuchFieldException | NoSuchMethodException | InvocationTargetException e) {
            e.printStackTrace();
            return CommonResponse.error((String)"\u4fdd\u5b58\u6216\u4fee\u6539\u5355\u636e\u5931\u8d25\uff01");
        }
    }

    @RequestMapping(value={"/queryDetail"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<OpinionInfoVO> queryDetail(Long id) {
        OpinionInfoEntity entity = (OpinionInfoEntity)((Object)this.service.selectById(id));
        OpinionInfoVO vo = (OpinionInfoVO)((Object)BeanMapper.map((Object)((Object)entity), OpinionInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u8be6\u60c5\u6570\u636e\u6210\u529f\uff01", (Object)((Object)vo));
    }

    @RequestMapping(value={"/delete"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<OpinionInfoVO> vos) {
        if (ListUtil.isNotEmpty(vos)) {
            for (OpinionInfoVO opinionInfoVO : vos) {
            }
        }
        this.service.removeByIds(vos.stream().map(BaseVO::getId).collect(Collectors.toList()), true);
        return CommonResponse.success((String)"\u5220\u9664\u6210\u529f\uff01");
    }

    @RequestMapping(value={"/queryList"}, method={RequestMethod.POST})
    @ResponseBody
    public CommonResponse<IPage<OpinionInfoVO>> queryList(@RequestBody QueryParam param) {
        List fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        UserContext userContextCache = this.sessionManager.getUserContext();
        String authOrgIds = userContextCache.getAuthOrgIds();
        List orgVOList = null;
        orgVOList = StringUtils.isNotBlank((CharSequence)authOrgIds) ? (List)this.getRespData(this.iOrgApi.findChildrenByParentIds(Arrays.stream(authOrgIds.split(",")).map(Long::parseLong).collect(Collectors.toList())), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002") : (List)this.getRespData(this.iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()), true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u5f53\u524d\u672c\u4e0b\u7ec4\u7ec7\u4fe1\u606f\u5931\u8d25\u3002");
        ArrayList commonOrgIds = new ArrayList();
        ArrayList departmentIds = new ArrayList();
        orgVOList.stream().forEach(org -> {
            if (5 == org.getOrgType()) {
                departmentIds.add(org.getId());
            } else {
                commonOrgIds.add(org.getId());
            }
        });
        if (CollectionUtils.isNotEmpty(commonOrgIds)) {
            param.getParams().put("orgId", new Parameter("in", commonOrgIds));
        } else if (CollectionUtils.isNotEmpty(departmentIds)) {
            param.getParams().put("orgId", new Parameter("in", departmentIds));
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OpinionInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    @RequestMapping(value={"/excelExport"}, method={RequestMethod.POST})
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        List fuzzyFields = param.getFuzzyFields();
        param.setPageIndex(1);
        param.setPageSize(-1);
        List list = this.service.queryList(param);
        ConstructionSchemeEntity entity = null;
        Map<String, Object> wordMap = null;
        if (list == null || list.size() == 0) {
            return;
        }
        entity = (ConstructionSchemeEntity)((Object)this.constructionSchemeService.selectById(((OpinionInfoEntity)((Object)list.get(0))).getPid()));
        String id = "";
        if (param.getParams().get("id") != null) {
            id = ((Parameter)param.getParams().get("id")).getValue().toString();
        }
        if (id == null || id == "") {
            return;
        }
        String[] idStrings = id.substring(1, id.length() - 1).split(",");
        ArrayList<Long> ids = new ArrayList<Long>();
        for (String str : idStrings) {
            try {
                ids.add(Long.parseLong(str.trim()));
            }
            catch (NumberFormatException e) {
                e.printStackTrace();
            }
        }
        wordMap = this.service.toWordMap(entity, ids);
        try (InputStream resourceAsStream = this.getClass().getResourceAsStream("/excel/constructionScheme-opinion-export.docx");){
            MyXWPFDocument document = new MyXWPFDocument(resourceAsStream);
            WordExportUtil.exportWord07((XWPFDocument)document, wordMap);
            ByteArrayOutputStream out = new ByteArrayOutputStream();
            try {
                document.write((OutputStream)out);
                out.close();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            byte[] fileData = out.toByteArray();
            response.setContentType("application/vnd.openxmlformats-officedocument.wordprocessingml.document");
            String fileName = "\u5ba1\u6838\u610f\u89c1\u6c47\u603b(" + entity.getConsSchemeName() + ").docx";
            response.setHeader("Content-Disposition", "attachment; filename=" + fileName);
            try (ByteArrayInputStream bais = new ByteArrayInputStream(fileData);){
                int bytesRead;
                byte[] buffer = new byte[1024];
                while ((bytesRead = bais.read(buffer)) != -1) {
                    response.getOutputStream().write(buffer, 0, bytesRead);
                }
                response.flushBuffer();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
        catch (Exception e) {
            e.printStackTrace();
        }
    }

    @RequestMapping(value={"/refOpinionInfoData"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<IPage<OpinionInfoVO>> refOpinionInfoData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize, String condition, String searchObject, String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize.intValue());
        param.setPageIndex(pageNumber.intValue());
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        param.getParams().put("tenantId", new Parameter("eq", (Object)InvocationInfoProxy.getTenantid()));
        if (StringUtils.isNotEmpty((CharSequence)condition)) {
            JSONObject jSONObject = JSONObject.parseObject((String)condition);
        }
        IPage page = this.service.queryPage(param, false);
        Page pageData = new Page(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList((Iterable)page.getRecords(), OpinionInfoVO.class));
        return CommonResponse.success((String)"\u67e5\u8be2\u53c2\u7167\u6570\u636e\u6210\u529f\uff01", (Object)pageData);
    }
}

