/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.ztpc.service.impl;

import com.alibaba.excel.EasyExcel;
import com.alibaba.excel.metadata.CellData;
import com.alibaba.excel.metadata.Head;
import com.alibaba.excel.write.handler.CellWriteHandler;
import com.alibaba.excel.write.handler.WriteHandler;
import com.alibaba.excel.write.metadata.holder.WriteSheetHolder;
import com.alibaba.excel.write.metadata.holder.WriteTableHolder;
import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.conditions.Wrapper;
import com.baomidou.mybatisplus.core.conditions.query.LambdaQueryWrapper;
import com.baomidou.mybatisplus.core.conditions.query.QueryWrapper;
import com.beust.jcommander.internal.Lists;
import com.ejianc.business.ztpc.billcode.api.IBillCodeRuleApi;
import com.ejianc.business.ztpc.billcode.bean.DataDictionaryVO;
import com.ejianc.foundation.bpm.api.IBpmApi;
import com.ejianc.foundation.bpm.vo.BpmApproveHistoryInfo;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IDefdocApi;
import com.ejianc.foundation.support.vo.DefdocDetailVO;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.BillStateEnum;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelReader;
import com.ejianc.framework.core.util.FileUtils;
import com.ejianc.framework.core.util.ResultAsTree;
import com.ejianc.framework.skeleton.template.BaseEntity;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import com.ejianc.framework.skeleton.template.BaseVO;
import com.ejianc.support.idworker.util.IdWorker;
import com.ejianc.ztpc.bean.ConSchemePlanEntity;
import com.ejianc.ztpc.bean.ConstructionSchemeEntity;
import com.ejianc.ztpc.mapper.ConstructionSchemeMapper;
import com.ejianc.ztpc.service.IConSchemePlanService;
import com.ejianc.ztpc.service.IConstructionSchemeService;
import com.ejianc.ztpc.util.DetailIndexExcelReader;
import com.ejianc.ztpc.util.EJCDateUtil;
import com.ejianc.ztpc.util.ToolUtil;
import com.ejianc.ztpc.util.UpSumUtil;
import com.ejianc.ztpc.vo.ConstructionSchemeImportVO;
import com.ejianc.ztpcdata.api.IExternalApi;
import java.io.OutputStream;
import java.net.URLEncoder;
import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.Collection;
import java.util.Comparator;
import java.util.Date;
import java.util.HashMap;
import java.util.Iterator;
import java.util.List;
import java.util.Map;
import java.util.function.Function;
import java.util.stream.Collectors;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.collections.CollectionUtils;
import org.apache.commons.collections.MapUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.commons.lang3.time.DateUtils;
import org.apache.poi.ss.usermodel.BorderStyle;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellStyle;
import org.apache.poi.ss.usermodel.FillPatternType;
import org.apache.poi.ss.usermodel.Font;
import org.apache.poi.ss.usermodel.HorizontalAlignment;
import org.apache.poi.ss.usermodel.IndexedColors;
import org.apache.poi.ss.usermodel.Row;
import org.apache.poi.ss.usermodel.Sheet;
import org.apache.poi.ss.usermodel.VerticalAlignment;
import org.apache.poi.ss.usermodel.Workbook;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;
import org.springframework.web.multipart.MultipartFile;
import org.springframework.web.multipart.MultipartHttpServletRequest;

@Service(value="constructionSchemeService")
public class ConstructionSchemeServiceImpl
extends BaseServiceImpl<ConstructionSchemeMapper, ConstructionSchemeEntity>
implements IConstructionSchemeService {
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private ConstructionSchemeMapper mapper;
    @Autowired
    private IDefdocApi iDefdocApi;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private IExternalApi iExternalApi;
    @Autowired
    private IOrgApi iOrgApi;
    @Autowired
    IConSchemePlanService conSchemePlanService;
    @Autowired
    private IBillCodeRuleApi billCodeRuleApi;
    @Autowired
    private IBpmApi bpmApi;
    @Autowired
    private IExternalApi externalApi;
    @Autowired
    private UpSumUtil upSumUtil;
    private static final int FREE_STATE = 0;

    @Override
    public CommonResponse<JSONObject> excelConstructionSchemeImport(HttpServletRequest request) {
        Long tenantId = InvocationInfoProxy.getTenantid();
        MultipartHttpServletRequest multipartRequest = (MultipartHttpServletRequest)request;
        Map fileMap = multipartRequest.getFileMap();
        MultipartFile mf = null;
        ArrayList<ConstructionSchemeImportVO> successList = new ArrayList<ConstructionSchemeImportVO>();
        ArrayList<ConstructionSchemeImportVO> errorList = new ArrayList<ConstructionSchemeImportVO>();
        ArrayList rtErrorList = new ArrayList();
        boolean isFailed = false;
        for (Map.Entry entry : fileMap.entrySet()) {
            mf = (MultipartFile)entry.getValue();
            String originalFileName = mf.getOriginalFilename();
            String extName = null;
            originalFileName = originalFileName.replaceAll("\\/|\\/|\\||:|\\?|\\*|\"|<|>|\\p{Cntrl}", "_");
            originalFileName.replaceAll("00.", "");
            extName = FileUtils.getFileExt((String)originalFileName, (Boolean)false);
            if ("xls".equals(extName) || "xlsx".equals(extName)) continue;
            isFailed = true;
            break;
        }
        if (isFailed) {
            return CommonResponse.error((String)"\u6587\u4ef6\u683c\u5f0f\u4e0d\u5408\u6cd5");
        }
        Integer size = DetailIndexExcelReader.getNumberOfSheets(mf);
        if (size != 1) {
            return CommonResponse.error((String)"\u6587\u4ef6\u9875\u7b7e\u4e0d\u5b8c\u6574\uff0c\u8bf7\u4e0b\u8f7d\u6700\u65b0\u6a21\u677f\uff01");
        }
        List result = ExcelReader.readExcel((MultipartFile)mf);
        if (result != null && result.size() > 0) {
            if (result.size() > 10000) {
                return CommonResponse.error((String)"\u65bd\u5de5\u65b9\u6848\u4fe1\u606f\u8d85\u8fc710000\u6761\uff0c\u8bf7\u5206\u6279\u4e0a\u4f20\uff01");
            }
            Map projDataMapAll = this.mapper.queryMapProjAll().stream().collect(Collectors.toMap(e -> String.valueOf(e.get("projectId")), Function.identity(), (e1, e2) -> e2));
            List mapProjLocal = Lists.newArrayList();
            CommonResponse response = this.iExternalApi.getMapProjLocal();
            if (response.isSuccess()) {
                mapProjLocal = (List)response.getData();
            }
            Map projDataMap = mapProjLocal.stream().collect(Collectors.toMap(e -> String.valueOf(e.get("name")), Function.identity(), (e1, e2) -> e2));
            CommonResponse ctSpecialtyType = this.iDefdocApi.getDefDocByDefCode("ct_specialty_type");
            CommonResponse ctConsSchemeType = this.iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
            CommonResponse ctProjectManageType = this.iDefdocApi.getDefDocByDefCode("ct_project_manage_type");
            for (int i = 0; i < result.size(); ++i) {
                String locationCodeName;
                String finishConsSchemeDateStr;
                String projectManageTypeName;
                ConstructionSchemeImportVO vo;
                StringBuilder errorMessage;
                List datas;
                boolean flag;
                block70: {
                    String consTimeFrameStr;
                    String orgExpertExamine;
                    String consSchemeTypeName;
                    String specialtyTypeName;
                    List<String> consTimeFrameList;
                    flag = true;
                    datas = (List)result.get(i);
                    errorMessage = new StringBuilder("");
                    vo = new ConstructionSchemeImportVO();
                    vo.setId(IdWorker.getId());
                    String projectName = (String)datas.get(0);
                    Map projectNameMap = (Map)projDataMap.get(projectName);
                    if (StringUtils.isBlank((CharSequence)projectName) || MapUtils.isEmpty((Map)projectNameMap)) {
                        errorMessage.append("[\u5de5\u7a0b\u540d\u79f0]").append(projectName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        vo.setProjectName((String)projectNameMap.get("name"));
                        vo.setProjectCode((String)projectNameMap.get("code"));
                        Object id = projectNameMap.get("id");
                        if (id instanceof String) {
                            vo.setProjectId(Long.parseLong((String)id));
                        } else {
                            vo.setProjectId((Long)id);
                        }
                        Object engineeringTypeId = projectNameMap.get("engineering_type_id");
                        if (engineeringTypeId instanceof String) {
                            vo.setEngineeringTypeId(Long.parseLong((String)engineeringTypeId));
                        } else {
                            vo.setEngineeringTypeId((Long)engineeringTypeId);
                        }
                        Object projectLeave = projectNameMap.get("project_rank");
                        if (projectLeave instanceof String) {
                            vo.setProjectLeave(Long.parseLong((String)projectLeave));
                        } else {
                            vo.setProjectLeave((Long)projectLeave);
                        }
                    }
                    String consSchemeIdName = (String)datas.get(1);
                    ConSchemePlanEntity conSchemePlanEntity = (ConSchemePlanEntity)((Object)this.conSchemePlanService.getOne((Wrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)((LambdaQueryWrapper)new QueryWrapper().lambda().eq(ConSchemePlanEntity::getProjectId, (Object)vo.getProjectId())).eq(ConSchemePlanEntity::getConsSchemeName, (Object)consSchemeIdName)).eq(BaseEntity::getDr, (Object)0)).last(" LIMIT 1 ")));
                    if (conSchemePlanEntity == null) {
                        errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355]" + consSchemeIdName + ":\u672a\u627e\u5230");
                        flag = false;
                    } else {
                        Date planRedactDate = conSchemePlanEntity.getPlanRedactDate();
                        Date redactFinishDate = conSchemePlanEntity.getRedactFinishDate();
                        Long specialtyType = conSchemePlanEntity.getSpecialtyType();
                        Long consSchemeType = conSchemePlanEntity.getConsSchemeType();
                        String orgExpertExamine2 = conSchemePlanEntity.getOrgExpertExamine();
                        String consTimeFrame = conSchemePlanEntity.getConsTimeFrame();
                        Long projectTrait = conSchemePlanEntity.getProjectTrait();
                        String keyPointExplain = conSchemePlanEntity.getKeyPointExplain();
                        Date finishConsSchemeDate = conSchemePlanEntity.getFinishConsSchemeDate();
                        vo.setConsSchemeId(conSchemePlanEntity.getId());
                        vo.setPlanRedactDate(planRedactDate);
                        vo.setRedactFinishDate(redactFinishDate);
                        vo.setSpecialtyType(specialtyType);
                        vo.setConsSchemeType(consSchemeType);
                        vo.setOrgExpertExamine(orgExpertExamine2);
                        vo.setProjectTrait(projectTrait);
                        vo.setKeyPointExplain(keyPointExplain);
                        vo.setFinishConsSchemeDate(finishConsSchemeDate);
                        if (ToolUtil.isNotEmpty(consTimeFrame)) {
                            try {
                                consTimeFrameList = Arrays.asList(consTimeFrame.split("~"));
                                DateUtils.parseDate((String)consTimeFrameList.get(0), (String[])new String[]{"yyyy-MM-dd"});
                                DateUtils.parseDate((String)consTimeFrameList.get(1), (String[])new String[]{"yyyy-MM-dd"});
                                vo.setConsTimeFrame(consTimeFrame);
                                vo.setConsTimeFrameList(consTimeFrameList);
                            }
                            catch (Exception e3) {
                                errorMessage.append(consTimeFrame + "\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
                                flag = false;
                                this.logger.info("\u65e5\u671f\u8f6c\u6362\u9519\u8bef");
                            }
                        }
                    }
                    String consSchemeName = (String)datas.get(2);
                    if (ToolUtil.isEmpty(consSchemeName)) {
                        errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u540d\u79f0]").append("\u4e3a\u7a7a;");
                        flag = false;
                    } else {
                        vo.setConsSchemeName(consSchemeName);
                    }
                    String code = (String)datas.get(3);
                    if (ToolUtil.isNotEmpty(code)) {
                        vo.setCode(code);
                    } else {
                        errorMessage.append("[\u6587\u4ef6\u7f16\u7801]\u4e3a\u7a7a;");
                        flag = false;
                    }
                    String outsideCode = (String)datas.get(4);
                    if (ToolUtil.isNotEmpty(outsideCode)) {
                        vo.setOutsideCode(outsideCode);
                    }
                    String fileVersion = (String)datas.get(5);
                    vo.setFileVersion(fileVersion);
                    String planRedactDateStr = (String)datas.get(6);
                    if (ToolUtil.isNotEmpty(planRedactDateStr)) {
                        Date parse = EJCDateUtil.parseDate(planRedactDateStr, "yyyy-MM-dd");
                        if (ToolUtil.isNotEmpty(parse)) {
                            vo.setPlanRedactDate(parse);
                        } else {
                            errorMessage.append("[\u8ba1\u5212\u7f16\u5236\u65f6\u95f4]" + planRedactDateStr + ":\u683c\u5f0f\u9519\u8bef");
                            flag = false;
                        }
                    }
                    if (ToolUtil.isEmpty(specialtyTypeName = (String)datas.get(7))) {
                        if (ToolUtil.isEmpty(vo.getSpecialtyType())) {
                            errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]\u4e3a\u7a7a;");
                            flag = false;
                        }
                    } else if (!ctSpecialtyType.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)ctSpecialtyType.getData()))) {
                        errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]").append(specialtyTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        Long defdocDetailId = ((List)ctSpecialtyType.getData()).stream().filter(a -> specialtyTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                        if (defdocDetailId == null) {
                            errorMessage.append("[\u4e13\u4e1a\u5206\u7c7b]:\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u7167;");
                            flag = false;
                        } else {
                            vo.setSpecialtyType(defdocDetailId);
                        }
                    }
                    if (ToolUtil.isEmpty(consSchemeTypeName = (String)datas.get(8))) {
                        if (ToolUtil.isEmpty(vo.getConsSchemeType())) {
                            errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]\u4e3a\u7a7a;");
                            flag = false;
                        }
                    } else if (!ctConsSchemeType.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)ctConsSchemeType.getData()))) {
                        errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]").append(consSchemeTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                        flag = false;
                    } else {
                        Long defdocDetailId = ((List)ctConsSchemeType.getData()).stream().filter(a -> consSchemeTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                        if (defdocDetailId == null) {
                            errorMessage.append("[\u65bd\u5de5\u65b9\u6848\u7c7b\u522b]:\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u7167;");
                            flag = false;
                        } else {
                            vo.setConsSchemeType(defdocDetailId);
                        }
                    }
                    if (ToolUtil.isNotEmpty(orgExpertExamine = (String)datas.get(9))) {
                        if ("\u662f".equals(orgExpertExamine)) {
                            vo.setOrgExpertExamine("Y");
                        } else if ("\u5426".equals(orgExpertExamine)) {
                            vo.setOrgExpertExamine("N");
                        } else {
                            errorMessage.append("[\u7ec4\u7ec7\u4e13\u5bb6\u5ba1\u67e5\u8981\u6c42]:\u683c\u5f0f\u9519\u8bef;");
                            flag = false;
                        }
                    }
                    if (ToolUtil.isEmpty(consTimeFrameStr = (String)datas.get(10))) {
                        if (ToolUtil.isEmpty(vo.getConsTimeFrame())) {
                            errorMessage.append("[\u65bd\u5de5\u65f6\u6bb5]\u4e3a\u7a7a;");
                            flag = false;
                        }
                    } else {
                        try {
                            consTimeFrameList = Arrays.asList(consTimeFrameStr.split("~"));
                            DateUtils.parseDate((String)consTimeFrameList.get(0), (String[])new String[]{"yyyy-MM-dd"});
                            DateUtils.parseDate((String)consTimeFrameList.get(1), (String[])new String[]{"yyyy-MM-dd"});
                            vo.setConsTimeFrame(consTimeFrameStr);
                            vo.setConsTimeFrameList(consTimeFrameList);
                        }
                        catch (Exception e4) {
                            errorMessage.append("[\u65bd\u5de5\u65f6\u6bb5]\u65e5\u671f\u683c\u5f0f\u9519\u8bef;");
                            flag = false;
                            if (!this.logger.isErrorEnabled()) break block70;
                            this.logger.error("\u65bd\u5de5\u65b9\u6848\u7f16\u5236\u8ba1\u5212\u6e05\u5355 \u5bfc\u5165-\u6821\u9a8c\u6570\u636e \u5931\u8d25\uff01\u7f16\u5236\u5b8c\u6210\u65f6\u95f4\u7684\u65e5\u671f\u683c\u5f0f\u9519\u8bef");
                        }
                    }
                }
                if (ToolUtil.isEmpty(projectManageTypeName = (String)datas.get(11))) {
                    if (ToolUtil.isEmpty(vo.getConsSchemeType())) {
                        errorMessage.append("[\u9879\u76ee\u7ba1\u7406\u5206\u7c7b]\u4e3a\u7a7a;");
                        flag = false;
                    }
                } else if (!ctProjectManageType.isSuccess() || CollectionUtils.isEmpty((Collection)((Collection)ctProjectManageType.getData()))) {
                    errorMessage.append("[\u9879\u76ee\u7ba1\u7406\u5206\u7c7b]").append(projectManageTypeName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                    flag = false;
                } else {
                    Long defdocDetailId = ((List)ctProjectManageType.getData()).stream().filter(a -> projectManageTypeName.equals(a.getName())).map(BaseVO::getId).findFirst().orElse(null);
                    if (defdocDetailId == null) {
                        errorMessage.append("[\u9879\u76ee\u7ba1\u7406\u5206\u7c7b]:\u672a\u627e\u5230\u5bf9\u5e94\u53c2\u7167;");
                        flag = false;
                    } else {
                        vo.setProjectManageType(defdocDetailId);
                    }
                }
                if (ToolUtil.isNotEmpty(finishConsSchemeDateStr = (String)datas.get(12))) {
                    Date parse = EJCDateUtil.parseDate(finishConsSchemeDateStr, "yyyy-MM-dd");
                    if (ToolUtil.isNotEmpty(parse)) {
                        vo.setFinishConsSchemeDate(parse);
                    } else {
                        errorMessage.append("[\u5b8c\u6210\u65bd\u5de5\u65b9\u6848\u65f6\u95f4]" + finishConsSchemeDateStr + ":\u683c\u5f0f\u9519\u8bef");
                        flag = false;
                    }
                }
                if (ToolUtil.isNotEmpty(locationCodeName = (String)datas.get(13))) {
                    Map data;
                    HashMap<String, String> map = new HashMap<String, String>();
                    map.put("categoryName", locationCodeName);
                    CommonResponse mapCommonResponse = this.billCodeRuleApi.materialClassificationTree(map);
                    if (mapCommonResponse.isSuccess() && ToolUtil.isNotEmpty(data = (Map)mapCommonResponse.getData())) {
                        Long id = (Long)data.get("name");
                        vo.setLocationCode(id);
                    }
                }
                String mgrpName = (String)datas.get(14);
                HashMap<String, String> dictionaryQueryMap = new HashMap<String, String>();
                if (ToolUtil.isNotEmpty(mgrpName)) {
                    List data;
                    dictionaryQueryMap.put("projectId", vo.getProjectId() + "");
                    dictionaryQueryMap.put("categoryCode", "mgrp");
                    CommonResponse mgrpCommonResponse = this.billCodeRuleApi.queryUnitBumber(dictionaryQueryMap);
                    if (mgrpCommonResponse.isSuccess() && (data = (List)mgrpCommonResponse.getData()) != null) {
                        DataDictionaryVO dataDictionaryVO = data.stream().filter(a -> mgrpName.equals(a.getDictionaryName())).findFirst().orElse(null);
                        if (dataDictionaryVO == null) {
                            errorMessage.append("[\u673a\u7ec4]").append(mgrpName).append(":\u9519\u8bef\u53c2\u7167\u65e0\u6cd5\u83b7\u53d6;");
                            flag = false;
                        } else {
                            vo.setMgrp(dataDictionaryVO.getId());
                        }
                    }
                }
                vo.setRowIndex(i + 2);
                Map stringStringMap = (Map)projDataMapAll.get(String.valueOf(vo.getProjectId()));
                CommonResponse orgVO = this.iOrgApi.getOneById((Long)stringStringMap.get("orgId"));
                if (!orgVO.isSuccess()) {
                    errorMessage.append("[\u9879\u76ee\u65e0\u5bf9\u5e94\u7ec4\u7ec7]");
                }
                vo.setOrgId((Long)stringStringMap.get("orgId"));
                vo.setOrgCode(((OrgVO)orgVO.getData()).getCode());
                vo.setOrgName(((OrgVO)orgVO.getData()).getName());
                vo.setParentOrgId((Long)stringStringMap.get("parentOrgId"));
                vo.setParentOrgCode((String)stringStringMap.get("parentOrgCode"));
                vo.setParentOrgName((String)stringStringMap.get("parentOrgName"));
                if (flag) {
                    successList.add(vo);
                    continue;
                }
                vo.setErrorMessage(errorMessage.toString());
                errorList.add(vo);
            }
        }
        JSONObject json = new JSONObject();
        json.put("successList", successList);
        json.put("errorList", errorList.stream().sorted(Comparator.comparing(ConstructionSchemeImportVO::getRowIndex)).collect(Collectors.toList()));
        return CommonResponse.success((Object)json);
    }

    @Override
    public CommonResponse<List<Map<String, Object>>> statistics(String startDate, String endDate) {
        SimpleDateFormat sdf = new SimpleDateFormat("yyyy-MM-dd HH:mm:ss");
        Date start = null;
        try {
            start = sdf.parse(startDate);
        }
        catch (ParseException e) {
            this.logger.info("startDate\u8f6c\u6362\u9519\u8bef:" + startDate);
        }
        Date end = null;
        try {
            end = sdf.parse(endDate);
        }
        catch (ParseException e) {
            this.logger.info("endDate\u8f6c\u6362\u9519\u8bef:" + endDate);
        }
        CommonResponse consSchemeTypeDefdoc = this.iDefdocApi.getDefDocByDefCode("ct_cons_scheme_type");
        if (!consSchemeTypeDefdoc.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u65bd\u5de5\u65b9\u6848\u53c2\u7167\u9519\u8bef");
        }
        QueryParam param = new QueryParam();
        param.getParams().put("billState", new Parameter("in", Arrays.asList(1, 3)));
        List constructionSchemeEntities = this.queryList(param);
        if (start != null && end != null) {
            for (int i = 0; i < constructionSchemeEntities.size(); ++i) {
                Object constructionSchemeEntity = (ConstructionSchemeEntity)((Object)constructionSchemeEntities.get(i));
                CommonResponse history = this.bpmApi.queryHistoryById(constructionSchemeEntity.getId());
                if (!history.isSuccess()) {
                    throw new BusinessException(history.getMsg());
                }
                if (((List)history.getData()).size() == 0) continue;
                BpmApproveHistoryInfo historyInfo = (BpmApproveHistoryInfo)((List)history.getData()).get(((List)history.getData()).size() - 1);
                String processTime = historyInfo.getProcessTime();
                Iterator lastApproveDate = null;
                try {
                    lastApproveDate = sdf.parse(processTime);
                }
                catch (ParseException e) {
                    this.logger.info("lastApproveDate\u8f6c\u6362\u9519\u8bef:" + processTime);
                }
                if (lastApproveDate == null || ((Date)((Object)lastApproveDate)).after(start) && ((Date)((Object)lastApproveDate)).before(end)) continue;
                constructionSchemeEntities.remove(i);
                --i;
            }
        }
        HashMap dataMap = new HashMap();
        for (ConstructionSchemeEntity entity : constructionSchemeEntities) {
            Long keyOrgId = entity.getParentOrgId();
            if (keyOrgId == null) continue;
            HashMap<String, String> data = (HashMap<String, String>)dataMap.get(keyOrgId);
            if (data == null) {
                data = new HashMap<String, String>();
                data.put("orgId", keyOrgId + "");
                data.put("orgName", entity.getParentOrgName());
                for (DefdocDetailVO datum : (List)consSchemeTypeDefdoc.getData()) {
                    if (datum.getId().equals(entity.getConsSchemeType())) {
                        data.put(datum.getCode(), "1");
                        continue;
                    }
                    data.put(datum.getCode(), "0");
                }
                dataMap.put(keyOrgId, data);
                continue;
            }
            for (DefdocDetailVO datum : (List)consSchemeTypeDefdoc.getData()) {
                String code = datum.getCode();
                if (!datum.getId().equals(entity.getConsSchemeType())) continue;
                data.put(code, Integer.parseInt((String)data.get(code)) + 1 + "");
            }
        }
        CommonResponse orgListResponse = this.externalApi.getOrgList(null, null, InvocationInfoProxy.getOrgId());
        if (!orgListResponse.isSuccess()) {
            return CommonResponse.error((String)"\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u9519\u8bef");
        }
        List orgVOList = (List)this.getRespData(orgListResponse, true, "\u67e5\u8be2\u5931\u8d25\uff0c\u83b7\u53d6\u7ec4\u7ec7\u6570\u636e\u9519\u8bef");
        for (int i = 0; i < orgVOList.size(); ++i) {
            OrgVO orgVO = (OrgVO)orgVOList.get(i);
            if (orgVO.getOrgType() != 5) continue;
            orgVOList.remove(i);
            --i;
        }
        List mapList = BeanMapper.mapList((Iterable)orgVOList, Map.class);
        for (Map map : mapList) {
            Long id = Long.parseLong(map.get("id").toString());
            Map stringStringMap = (Map)dataMap.get(id);
            if (stringStringMap == null) continue;
            for (DefdocDetailVO datum : (List)consSchemeTypeDefdoc.getData()) {
                String value = (String)stringStringMap.get(datum.getCode());
                map.put(datum.getCode(), value == null ? 0L : Long.valueOf(value));
            }
        }
        List treeData = ResultAsTree.createTreeData((List)mapList);
        List<Map<String, Object>> result = this.upSumUtil.upSum(treeData, "A", "B", "C");
        return CommonResponse.success(result);
    }

    @Override
    public void exportConSchemeInfo(List<ConstructionSchemeEntity> list, HttpServletResponse response) {
        try {
            ArrayList dataList = new ArrayList();
            for (ConstructionSchemeEntity entity : list) {
                CommonResponse bpmInfoResp;
                HashMap<String, String> rowData = new HashMap<String, String>();
                rowData.put("\u6587\u4ef6\u7f16\u7801", entity.getCode());
                rowData.put("\u65bd\u5de5\u65b9\u6848\u540d\u79f0", entity.getConsSchemeName());
                rowData.put("\u6267\u884c\u72b6\u6001", BillStateEnum.getEnumByStateCode((Integer)entity.getBillState()).getDescription());
                StringBuilder approvalInfo = new StringBuilder();
                if (!entity.getBillState().equals(0) && (bpmInfoResp = this.bpmApi.queryAllHistoryByBillId(entity.getId())).isSuccess() && CollectionUtils.isNotEmpty((Collection)((Collection)bpmInfoResp.getData()))) {
                    List historyList = (List)bpmInfoResp.getData();
                    int count = 0;
                    for (BpmApproveHistoryInfo bpmApproveHistoryInfo : historyList) {
                        if (!"\u5355\u636e\u63d0\u4ea4".equals(bpmApproveHistoryInfo.getApproveNode()) && !StringUtils.isNotEmpty((CharSequence)bpmApproveHistoryInfo.getApproveInfo())) continue;
                        if ("\u5355\u636e\u63d0\u4ea4".equals(bpmApproveHistoryInfo.getApproveNode())) {
                            approvalInfo.append(String.format("\u7b2c%d\u6b21\u5ba1\u6279------\n", ++count));
                        }
                        String approver = bpmApproveHistoryInfo.getApprover() != null ? bpmApproveHistoryInfo.getApprover() : "";
                        String processTime = bpmApproveHistoryInfo.getProcessTime() != null ? bpmApproveHistoryInfo.getProcessTime() : "\u65e0";
                        String approveInfo = bpmApproveHistoryInfo.getApproveInfo() != null ? bpmApproveHistoryInfo.getApproveInfo() : "\u65e0";
                        String approveNode = bpmApproveHistoryInfo.getApproveNode() != null ? bpmApproveHistoryInfo.getApproveNode() : "";
                        approvalInfo.append(String.format("\u5ba1\u6279\u8282\u70b9\uff1a%s \u5ba1\u6279\u4eba\uff1a%s \u5ba1\u6279\u65f6\u95f4\uff1a%s \u5ba1\u6279\u610f\u89c1\uff1a%s\n", approveNode, approver, processTime, approveInfo));
                    }
                }
                if (approvalInfo.length() == 0) {
                    approvalInfo.append("\u65e0\u5ba1\u6279\u8bb0\u5f55");
                }
                rowData.put("\u5ba1\u6279\u4fe1\u606f", approvalInfo.toString());
                dataList.add(rowData);
            }
            response.setContentType("application/vnd.openxmlformats-officedocument.spreadsheetml.sheet");
            response.setCharacterEncoding("UTF-8");
            String fileName = URLEncoder.encode("\u65bd\u5de5\u65b9\u6848\u5ba1\u6279\u4fe1\u606f", "UTF-8").replaceAll("\\+", "%20");
            response.setHeader("Content-Disposition", "attachment;filename*=utf-8''" + fileName + ".xlsx");
            ArrayList headList = new ArrayList();
            ArrayList<String> head1 = new ArrayList<String>();
            head1.add("\u6587\u4ef6\u7f16\u7801");
            ArrayList<String> head2 = new ArrayList<String>();
            head2.add("\u65bd\u5de5\u65b9\u6848\u540d\u79f0");
            ArrayList<String> head3 = new ArrayList<String>();
            head3.add("\u6267\u884c\u72b6\u6001");
            ArrayList<String> head4 = new ArrayList<String>();
            head4.add("\u5ba1\u6279\u4fe1\u606f");
            headList.add(head1);
            headList.add(head2);
            headList.add(head3);
            headList.add(head4);
            ArrayList dataRows = new ArrayList();
            for (Map map : dataList) {
                ArrayList row = new ArrayList();
                row.add(map.get("\u6587\u4ef6\u7f16\u7801"));
                row.add(map.get("\u65bd\u5de5\u65b9\u6848\u540d\u79f0"));
                row.add(map.get("\u6267\u884c\u72b6\u6001"));
                row.add(map.get("\u5ba1\u6279\u4fe1\u606f"));
                dataRows.add(row);
            }
            EasyExcel.write((OutputStream)response.getOutputStream()).head(headList).registerWriteHandler((WriteHandler)new ApproveInfoStyleHandler()).registerWriteHandler((WriteHandler)new CustomColumnWidthStyleStrategy()).registerWriteHandler((WriteHandler)new HeaderStyleHandler()).sheet("\u65bd\u5de5\u65b9\u6848\u5ba1\u6279").doWrite(dataRows);
        }
        catch (Exception e) {
            this.logger.error("\u5bfc\u51fa\u65bd\u5de5\u65b9\u6848\u5ba1\u6279\u4fe1\u606f\u5931\u8d25", (Throwable)e);
            e.printStackTrace();
        }
    }

    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if (isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank((CharSequence[])new CharSequence[]{errMsg}) ? errMsg : "\u8c03\u7528Rpc\u670d\u52a1\u5931\u8d25");
        }
        return resp.getData();
    }

    private static class HeaderStyleHandler
    implements CellWriteHandler {
        private HeaderStyleHandler() {
        }

        public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
        }

        public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
            if (isHead.booleanValue()) {
                Workbook workbook = writeSheetHolder.getSheet().getWorkbook();
                CellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setFillForegroundColor(IndexedColors.GREY_25_PERCENT.getIndex());
                cellStyle.setFillPattern(FillPatternType.SOLID_FOREGROUND);
                Font font = workbook.createFont();
                font.setBold(true);
                cellStyle.setFont(font);
                cellStyle.setBorderBottom(BorderStyle.THIN);
                cellStyle.setBorderLeft(BorderStyle.THIN);
                cellStyle.setBorderRight(BorderStyle.THIN);
                cellStyle.setBorderTop(BorderStyle.THIN);
                cellStyle.setAlignment(HorizontalAlignment.CENTER);
                cellStyle.setVerticalAlignment(VerticalAlignment.CENTER);
                cell.setCellStyle(cellStyle);
            }
        }

        public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        }
    }

    private static class CustomColumnWidthStyleStrategy
    implements CellWriteHandler {
        private CustomColumnWidthStyleStrategy() {
        }

        public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
            if (isHead.booleanValue() && relativeRowIndex == 0) {
                Sheet sheet = writeSheetHolder.getSheet();
                switch (columnIndex) {
                    case 0: {
                        sheet.setColumnWidth(columnIndex.intValue(), 5120);
                        break;
                    }
                    case 1: {
                        sheet.setColumnWidth(columnIndex.intValue(), 7680);
                        break;
                    }
                    case 2: {
                        sheet.setColumnWidth(columnIndex.intValue(), 3840);
                        break;
                    }
                    case 3: {
                        sheet.setColumnWidth(columnIndex.intValue(), 20480);
                        break;
                    }
                    default: {
                        sheet.setColumnWidth(columnIndex.intValue(), 3840);
                    }
                }
            }
        }

        public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        }

        public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        }
    }

    private static class ApproveInfoStyleHandler
    implements CellWriteHandler {
        private ApproveInfoStyleHandler() {
        }

        public void beforeCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Row row, Head head, Integer columnIndex, Integer relativeRowIndex, Boolean isHead) {
        }

        public void afterCellCreate(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
        }

        public void afterCellDispose(WriteSheetHolder writeSheetHolder, WriteTableHolder writeTableHolder, List<CellData> cellDataList, Cell cell, Head head, Integer relativeRowIndex, Boolean isHead) {
            if (!isHead.booleanValue() && cell.getColumnIndex() == 3) {
                Workbook workbook = writeSheetHolder.getSheet().getWorkbook();
                CellStyle cellStyle = workbook.createCellStyle();
                cellStyle.setWrapText(true);
                cellStyle.setAlignment(HorizontalAlignment.LEFT);
                cell.setCellStyle(cellStyle);
                writeSheetHolder.getSheet().getRow(cell.getRowIndex()).setHeightInPoints(100.0f);
            }
        }
    }
}

