package com.ejianc.ztpcdata.api;

import com.ejianc.foundation.orgcenter.vo.EmployeeVO;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpcdata.hystrix.ExternalHystrix;
import com.ejianc.ztpcdata.hystrix.IIdmOrgHystrix;
import com.ejianc.ztpcdata.util.IIdmOrgParams;
import org.springframework.cloud.openfeign.FeignClient;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

@FeignClient(name = "ejc-ztpcdata-web", url = "${common.env.feign-client-url}", path = "ejc-ztpcdata-web", fallback = IIdmOrgHystrix.class)
//@FeignClient(name = "ejc-ztpcdata-web", url = "http://127.0.0.1:8080", path = "ejc-ztpcdata-web", fallback = IIdmOrgHystrix.class)
public interface IIdmOrgApi {
    @RequestMapping(value = "/api/idmOrg/synIdmEmpByHr", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<String> synIdmEmpByHr(@RequestBody IIdmOrgParams orgParams);

    @RequestMapping(value = "/api/idmOrg/queryOrgListByName", method = RequestMethod.POST)
    @ResponseBody
    CommonResponse<List<OrgVO>> queryOrgListByName(String  name);
}
