package com.ejianc.ztpcdata.factory;

import com.ejianc.foundation.share.vo.SupplierVO;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.ztpcdata.api.IExternalApi;
import com.ejianc.ztpcdata.hystrix.ExternalHystrix;
import feign.hystrix.FallbackFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

import java.util.List;

@Component
public class ExternalHystrixFallbackFactory implements FallbackFactory<IExternalApi> {
    @Autowired
    private ExternalHystrix externalHystrix; // 注入原有的 Hystrix 降级类

    @Override
    public IExternalApi create(Throwable cause) {
        externalHystrix.setCause(cause); // 设置降级原因
        return externalHystrix; // 返回复用的降级逻辑
    }
}
