package com.ejianc.business.basem.utils;

import org.springframework.expression.EvaluationContext;
import org.springframework.expression.Expression;
import org.springframework.expression.ExpressionParser;
import org.springframework.expression.spel.standard.SpelExpressionParser;
import org.springframework.expression.spel.support.StandardEvaluationContext;

import java.util.Map;

/**
 * @Classname ElFactory
 * @Description TODO
 * @Date 2022/4/15 10:24
 * @Created by lijunxue
 */
public class ElFactory {

    private StandardEvaluationContext context ;

    public static EvaluationContext getInstance() {
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        return standardEvaluationContext;
    }

    public static EvaluationContext getInstance(Map<String, Object> map) {
        StandardEvaluationContext standardEvaluationContext = new StandardEvaluationContext();
        map.keySet().stream().forEach(key -> standardEvaluationContext.setVariable(key, map.get(key)));
        return standardEvaluationContext;
    }

    public static String getElStrValue(String el , EvaluationContext context) {
        ExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(el);
        ValidateUtil valid = new ValidateUtil();
        context.setVariable("valid", valid);
        String value = exp.getValue(context, String.class);
        return value;
    }


    public static Integer getElIntValue(String el , EvaluationContext context) {
        ExpressionParser parser = new SpelExpressionParser();
        Expression exp = parser.parseExpression(el);
        ValidateUtil valid = new ValidateUtil();
        context.setVariable("valid", valid);
        Integer value = exp.getValue(context, Integer.class);
        return value;
    }
}
