package com.ejianc.business.ztpczr.service.impl;

import com.ejianc.business.ztpczr.bean.PubFinereportPtintconfigEntity;
import com.ejianc.business.ztpczr.cores.utils.ElFactory;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.cores.utils.ValidateUtil;
import com.ejianc.business.ztpczr.mapper.PubFinereportPtintconfigMapper;
import com.ejianc.business.ztpczr.service.IPubFinereportPtintconfigService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.expression.EvaluationContext;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;

/**
 * PRT
 *
 * @author generator
 */
@Service("pubFinereportPtintconfigService")
public class PubFinereportPtintconfigServiceImpl extends BaseServiceImpl<PubFinereportPtintconfigMapper, PubFinereportPtintconfigEntity> implements IPubFinereportPtintconfigService {

    @Autowired
    private PubFinereportPtintconfigMapper pubFinereportPtintconfigMapper;

    @Autowired
    private SessionManager sessionManager;


    /**
     * 一个menu_id或者button_id可能对应多个模板
     * 多条数据可能对应一个模板或者多个模板
     * 如果对应多个模板，分组
     *
     * @param params
     * @return
     */
    @Override
    public CommonResponse<String> ckFineReportUrl(Map params) {
        if (!params.containsKey("appCode") && !params.containsKey("pageCode") && !params.containsKey("buttonCode")) {
            return CommonResponse.error("appId 或 pageId 或 buttonCode 传入参数为null！");
        }

        //项目打印模板没有配置，取通用的打印模板
        List<PubFinereportPtintconfigEntity> pubFinereportPtintconfigEntityList = pubFinereportPtintconfigMapper.cktPubFinereportPtintconfig(params);

        if (ToolUtil.isNotEmpty(pubFinereportPtintconfigEntityList)) {
            if (pubFinereportPtintconfigEntityList.size() == 0) {
                return CommonResponse.success("未重复", "Y");
            } else if (pubFinereportPtintconfigEntityList.size() == 1 &&
                    pubFinereportPtintconfigEntityList.get(0).getId().equals(params.get("id"))) {
                return CommonResponse.success("未重复", "Y");
            }
        } else {
            return CommonResponse.success("未重复", "Y");
        }

        return CommonResponse.error("配置打印模版重复", "N");


    }

    /**
     * 一个menu_id或者button_id可能对应多个模板
     * 多条数据可能对应一个模板或者多个模板
     * 如果对应多个模板，分组
     *
     * @param params
     * @return
     */
    @Override
    public CommonResponse<List<Map<String, Object>>> getFineReportUrl(Map params) {
        if (!params.containsKey("appCode") && !params.containsKey("pageCode") && !params.containsKey("buttonCode")) {
            return CommonResponse.error("appId 或 pageId 或 buttonCode 传入参数为null！");
        }
        List<PubFinereportPtintconfigEntity> pubFinereportPtintconfigEntityList = null;

        if (ToolUtil.isEmpty(params.get("orgId"))) {

            pubFinereportPtintconfigEntityList = pubFinereportPtintconfigMapper.selectPubFinereportPtintconfig(
                    params,
                    sessionManager.getUserContext().getOrgCode()
            );

            if (ValidateUtil.isEmpty(pubFinereportPtintconfigEntityList)) {
                //项目打印模板没有配置，取通用的打印模板
                pubFinereportPtintconfigEntityList = pubFinereportPtintconfigMapper.selectPubFinereportPtintconfig(params, "01");
            }

        } else {
            pubFinereportPtintconfigEntityList = pubFinereportPtintconfigMapper.cktPubFinereportPtintconfig(params);
        }


        //业务逻辑处理
        List<Map<String, Object>> list = new ArrayList<>();
        List<Map<String, Object>> rowDatas = (List<Map<String, Object>>) params.get("rowDatas");
        if (ToolUtil.isEmpty(rowDatas)) {
            if (pubFinereportPtintconfigEntityList.size() == 1) {
                //不需要根据勾选的数据获取帆软打印模板信息
                PubFinereportPtintconfigEntity pubFinereportPtintconfigEntity = pubFinereportPtintconfigEntityList.get(0);
                Map<String, Object> map = new HashMap<>();
                map.put("addr", pubFinereportPtintconfigEntity.getFinereportServiceaddres());
                map.put("path", pubFinereportPtintconfigEntity.getFinereportPath());
                map.put("name", pubFinereportPtintconfigEntity.getFinereportName());
                map.put("opType", pubFinereportPtintconfigEntity.getOpType());
                list.add(map);
            }

        } else {

            //需要根据勾选的数据获取帆软打印模板信息
            pubFinereportPtintconfigEntityList.stream().forEach(po -> {
                String conditionEl = po.getConditionEl();
                Map<String, Object> map = new HashMap<>();
                map.put("addr", po.getFinereportServiceaddres());
                map.put("path", po.getFinereportPath());
                map.put("name", po.getFinereportName());
                map.put("opType", po.getOpType());
                rowDatas.stream().forEach(rowData -> {
                    Boolean elFlag = true;
                    //通过el表达式来匹配对应的数据
                    if (ValidateUtil.isNotEmpty(conditionEl)) {
                        EvaluationContext instance = ElFactory.getInstance(rowData);
                        elFlag = ElFactory.getElStrValue(conditionEl, instance) == "true" ? true : false;
                    }
                    if (elFlag) {//如果成功说明匹配成功
                        if (po.getFinereportType().equals("word")) {
                            //当类型为word的时候则一条一条打印
                            Map<String, Object> wordMap = new HashMap<>();
                            wordMap.put("addr", po.getFinereportServiceaddres());
                            wordMap.put("path", po.getFinereportPath());
                            wordMap.put("name", po.getFinereportName());
                            wordMap.put("opType", po.getOpType());
                            wordMap.put("params", rowData.get("id"));
                            list.add(wordMap);
                        } else if (map.containsKey(String.valueOf(po.getId()))) {
                            String dataGlobalIds = (String) map.get(String.valueOf(po.getId()));
                            dataGlobalIds = dataGlobalIds + "','" + rowData.get("id");
                            map.put(String.valueOf(po.getId()), dataGlobalIds);
                        } else {
                            map.put(String.valueOf(po.getId()), rowData.get("id"));
                        }
                    }
                });
                if (map.containsKey(String.valueOf(po.getId()))) {
                    map.put("params", map.get(String.valueOf(po.getId())));
                    list.add(map);
                }
            });
        }
        if (ValidateUtil.isEmpty(list)) {
            return CommonResponse.error("无法打印，没有配置相对应的打印模板！");
        }
        return CommonResponse.success("请求成功", list);
    }
}
