/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ztpczr.controller;

import com.ejianc.business.ztpczr.bean.DcFileTypeQuery;
import com.ejianc.business.ztpczr.bean.SystemEntity;
import com.ejianc.business.ztpczr.bean.SystemRtEntity;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.service.ISystemService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import java.io.Serializable;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RequestMethod;
import org.springframework.web.bind.annotation.RequestParam;
import org.springframework.web.bind.annotation.ResponseBody;

@Controller
@RequestMapping(value={"pubVarConfig"})
public class SystemController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISystemService service;
    @Autowired
    private SessionManager sessionManager;

    @RequestMapping(value={"/queryByTableName"}, method={RequestMethod.GET})
    @ResponseBody
    public CommonResponse<Map<String, List<Map>>> queryListByAttribute(@RequestParam String tableName) {
        QueryParam param = new QueryParam();
        List<SystemEntity> systemEntities = this.service.selectByTableName(tableName);
        if (systemEntities == null || systemEntities.size() != 3) {
            return CommonResponse.success((String)("\u8be5\u8868\u6ca1\u6709\u8bbe\u7f6e\u53c2\u7167\uff01tableName:" + tableName));
        }
        List<SystemRtEntity> systemRtEntityList = this.service.selectByCode(systemEntities);
        ArrayList filterEntityList = new ArrayList();
        systemRtEntityList.stream().forEach(e -> {
            HashMap<String, Object> entityMap = new HashMap<String, Object>();
            entityMap.put("code", e.getCode());
            entityMap.put("name", e.getName());
            entityMap.put("id", e.getId());
            filterEntityList.add(entityMap);
        });
        HashMap data = new HashMap();
        data.put("data", filterEntityList);
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", data);
    }

    @RequestMapping(value={"/dcFileTypeQueryTree"}, method={RequestMethod.GET})
    @ResponseBody
    public List<Map<String, Object>> dcFileTypeQueryTree(@RequestParam(required=false) String condition, @RequestParam(required=false) Long pid, @RequestParam(required=false) String searchText) {
        HashMap<String, Object> params = new HashMap<String, Object>();
        params.put("belongOrgId", this.sessionManager.getUserContext().getOrgId());
        if (ToolUtil.isEmpty(pid)) {
            params.put("pid", 1474197986685751299L);
        } else {
            params.put("pid", pid);
        }
        List<Long> inIds = null;
        List<Long> notInIds = null;
        if (ToolUtil.isNotEmpty(condition)) {
            String substring;
            if (condition.startsWith("inIds")) {
                substring = condition.substring("inIds".length());
                inIds = SystemController.getIds(substring);
            }
            if (condition.startsWith("notInIds")) {
                substring = condition.substring("notInIds".length());
                notInIds = SystemController.getIds(substring);
            }
        }
        params.put("inIds", inIds);
        params.put("notInIds", notInIds);
        List<DcFileTypeQuery> dataList = this.service.dcFileTypeQuery(params);
        List map = BeanMapper.mapList(dataList, Map.class);
        return ResultAsTree.createTreeData((List)map);
    }

    public static List<Long> getIds(String ids) {
        if (ToolUtil.isEmpty(ids)) {
            return null;
        }
        List<Long> collect = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
        return collect;
    }
}

