package com.ejianc.basem.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.ejianc.basem.vo.ButtonInfoVO;
import com.ejianc.basem.bean.IdeModulePo;
import com.ejianc.basem.mapper.IdeModuleMapper;
import com.ejianc.basem.service.IIdeModuleService;
import com.ejianc.basem.utils.ToolUtil;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;

/**
 * @Classname ActRuExecutionService
 * @Description TODO
 * @Date 2023/4/27 15:33
 * @Created by lijunxue
 */
@Service("ideModuleService")
public class IdeModuleService implements IIdeModuleService {

    @Autowired
    private IdeModuleMapper ideModuleMapper;


    @Autowired
    private ActRuTaskService actRuTaskService;

    /**
     * 按钮信息处理
     *
     * @return
     */
    public List<ButtonInfoVO> getButtonAuthList(String bizId, String appId, String code) {
        List<IdeModulePo> ideModulePoList = ideModuleMapper.selectMyPageInfo(appId, code);
        List<ButtonInfoVO> buttonAuthList = new ArrayList<ButtonInfoVO>();
        if (ToolUtil.isNotEmpty(ideModulePoList) && ideModulePoList.size() == 1) {
            String nodeType = actRuTaskService.getNodeType(bizId);
            IdeModulePo ideModulePo = ideModulePoList.get(0);
            String data = ideModulePo.getData();
            JSONObject root = JSONObject.parseObject(data);
            JSONArray children = root.getJSONArray("children");
            children.stream().forEach(e -> {
                JSONObject obj = (JSONObject) e;
                String uitype = obj.getString("uitype");
                if ("EJCToolbar".equals(uitype)) {
                    JSONArray childrenSub = obj.getJSONArray("children");
                    childrenSub.stream().forEach(es -> {
                        JSONObject objSub = (JSONObject) es;
                        String uitypeSub = objSub.getString("uitype");
                        if ("EJCButton".equals(uitypeSub)) {
                            String enTitle = objSub.getString("enTitle");
                            String uikey = objSub.getString("uikey");
                            if (ToolUtil.isNotEmpty(enTitle)&&enTitle.contains("auth_")) {
                                ButtonInfoVO buttonAuthVO = new ButtonInfoVO();
                                buttonAuthVO.setButtonCode(uikey);
                                if (("auth_" + nodeType).equals(enTitle)) {
                                    buttonAuthVO.setShowAble("Y");
                                } else {
                                    buttonAuthVO.setShowAble("N");
                                }
                                buttonAuthList.add(buttonAuthVO);
                            }
                        }
                    });
                }
            });
            return buttonAuthList;
        } else {
            // 有多个说明 可能出现不同的情况
            return buttonAuthList;
        }
    }


}
