package com.ejianc.business.ztpczr.service.impl;

import com.baomidou.mybatisplus.core.conditions.update.UpdateWrapper;
import com.ejianc.business.ztpczr.bean.PubVarConfigEntity;
import com.ejianc.business.ztpczr.mapper.PubVarConfigMapper;
import com.ejianc.business.ztpczr.service.IPubVarConfigService;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.skeleton.template.BaseServiceImpl;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

/**
 * CVAR
 * 
 * @author generator
 * 
 */
@Service("pubVarConfigService")
public class PubVarConfigServiceImpl extends BaseServiceImpl<PubVarConfigMapper, PubVarConfigEntity> implements IPubVarConfigService{


    @Autowired
    private PubVarConfigMapper pubVarConfigMapper;

    @Autowired
    private SessionManager sessionManager;

    @Override
    public PubVarConfigEntity getPubVarConfigEntity(String varName) {
        UpdateWrapper<PubVarConfigEntity> updateWrapper = new UpdateWrapper<>();
        updateWrapper.lambda().eq(PubVarConfigEntity::getVarName,varName)
                .set(PubVarConfigEntity::getDr, 0);
        PubVarConfigEntity pubVarConfigEntity = this.baseMapper.selectOne(updateWrapper);
        return pubVarConfigEntity;
    }


}
