package com.ejianc.business.ztpczr.controller;

import com.alibaba.fastjson.JSONObject;
import com.baomidou.mybatisplus.core.metadata.IPage;
import com.baomidou.mybatisplus.core.toolkit.IdWorker;
import com.baomidou.mybatisplus.extension.plugins.pagination.Page;
import com.ejianc.business.ztpczr.bean.PubFinereportPtintconfigEntity;
import com.ejianc.business.ztpczr.service.IPubFinereportPtintconfigService;
import com.ejianc.business.ztpczr.vo.PubFinereportPtintconfigVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.orgcenter.vo.OrgVO;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.exception.BusinessException;
import com.ejianc.framework.core.kit.collection.ListUtil;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.Parameter;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ExcelExport;
import org.apache.commons.lang3.StringUtils;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import javax.servlet.http.HttpServletResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import java.util.stream.Collectors;

/**
 * PRT
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("pubFinereportPtintconfig")
public class PubFinereportPtintconfigController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IPubFinereportPtintconfigService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/saveOrUpdate", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<PubFinereportPtintconfigVO> saveOrUpdate(@RequestBody PubFinereportPtintconfigVO saveOrUpdateVO) {
    	PubFinereportPtintconfigEntity entity = BeanMapper.map(saveOrUpdateVO, PubFinereportPtintconfigEntity.class);
        Map<String, Object> params = new HashMap<>();
        params.put("appCode",saveOrUpdateVO.getAppCode());
        params.put("pageCode",saveOrUpdateVO.getPageCode());
        params.put("orgId",saveOrUpdateVO.getOrgId());
        params.put("buttonCode",saveOrUpdateVO.getButtonCode());
        params.put("id",saveOrUpdateVO.getId());

        CommonResponse<String> stringCommonResponse = service.ckFineReportUrl(params);

        if (!stringCommonResponse.isSuccess()){
            return CommonResponse.error(stringCommonResponse.getMsg(),null);
        }

        if(entity.getId() == null || entity.getId() == 0){
            entity.setId(IdWorker.getId());
        }


//            entity.setId(IdWorker.getId());
////            BillCodeParam billCodeParam = BillCodeParam.build(BILL_CODE,InvocationInfoProxy.getTenantid(),saveOrUpdateVO);
////            CommonResponse<String> billCode = billCodeApi.generateBillCode(billCodeParam);
////            if(billCode.isSuccess()) {
//////                entity.setCode(billCode.getData());//此处需要根据实际修改 删除本行或者下一行
//////                entity.setBillCode(billCode.getData());//此处需要根据实际修改 删除本行或者上一行
////            }else{
////                throw new BusinessException("网络异常， 编码生成失败， 请稍后再试");
////            }
//        }


    	service.saveOrUpdate(entity, false);
    	PubFinereportPtintconfigVO vo = BeanMapper.map(entity, PubFinereportPtintconfigVO.class);
    	return CommonResponse.success("保存或修改单据成功！",vo);
    }

    /**
     * @Description queryDetail 查询详情
     * @param id
     */
    @RequestMapping(value = "/queryDetail", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<PubFinereportPtintconfigVO> queryDetail(Long id) {
    	PubFinereportPtintconfigEntity entity = service.selectById(id);
    	PubFinereportPtintconfigVO vo = BeanMapper.map(entity, PubFinereportPtintconfigVO.class);
        return CommonResponse.success("查询详情数据成功！",vo);
    }

    /**
     * @Description delete 批量删除单据
     * @Param [ids]
     */
    @RequestMapping(value = "/delete", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<String> delete(@RequestBody List<PubFinereportPtintconfigVO> vos) {
        if(ListUtil.isNotEmpty(vos)){
            for (PubFinereportPtintconfigVO vo : vos) {
                // 参数是单据类型编码字符串 根据需求是否打开下面代码
                /* CommonResponse<String> resp = billTypeApi.checkQuote("billTypeCode", vo.getId());
                if(!resp.isSuccess()){
                    return CommonResponse.error("删除失败！"+resp.getMsg());
                }*/
            }
        }
        service.removeByIds(vos.stream().map(PubFinereportPtintconfigVO::getId).collect(Collectors.toList()),true);
        return CommonResponse.success("删除成功！");
    }

    /**
     * @Description queryList 查询列表
     * @param param
     * @Return com.ejianc.framework.core.response.CommonResponse<java.lang.String>
     */
    @RequestMapping(value = "/queryList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<IPage<PubFinereportPtintconfigVO>> queryList(@RequestBody QueryParam param) {

        param.getFuzzyFields().add("finereportName");
        param.getFuzzyFields().add("appName");
        param.getFuzzyFields().add("pageName");
        param.getFuzzyFields().add("buttonName");

        /** 数据隔离 本下 没有组织orgId的删除上面代码-------------结束！！！ */

        IPage<PubFinereportPtintconfigEntity> page = service.queryPage(param,false);
        IPage<PubFinereportPtintconfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
  		pageData.setRecords(BeanMapper.mapList(page.getRecords(), PubFinereportPtintconfigVO.class));

        return CommonResponse.success("查询列表数据成功！",pageData);
    }

    /**
     * 获取RPC数据
     * resp 返回值
     * isMustSuc 是否必须成功
     * errMsg 失败提示
     */
    private Object getRespData(CommonResponse<?> resp, boolean isMustSuc, String errMsg) {
        if(isMustSuc && !resp.isSuccess()) {
            throw new BusinessException(StringUtils.isNoneBlank(errMsg) ? errMsg : "调用Rpc服务失败");
        }
        return resp.getData();
    }


    /**
     * @Description 导出
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/excelExport", method = RequestMethod.POST)
    @ResponseBody
    public void excelExport(@RequestBody QueryParam param, HttpServletResponse response) {
        /** 模糊搜索配置字段示例 */
        List<String> fuzzyFields = param.getFuzzyFields();
        param.getParams().put("tenant_id",new Parameter(QueryParam.EQ,InvocationInfoProxy.getTenantid()));
        param.setPageIndex(1);
        param.setPageSize(-1);
        /** 数据隔离 本下 没有组织orgId的删除下面代码 */
        param.getParams().put("orgId",new Parameter(QueryParam.IN,iOrgApi.findChildrenByParentId(InvocationInfoProxy.getOrgId()).getData().stream().map(OrgVO::getId).collect(Collectors.toList())));
        List<PubFinereportPtintconfigEntity> list = service.queryList(param);
        //todo:字段翻译等等
        Map<String, Object> beans = new HashMap<>();
        beans.put("records", list);
        ExcelExport.getInstance().export("PubFinereportPtintconfig-export.xlsx", beans, response);
    }

    /**
     * @Description 参照
     * @param param
     * @Return void
     */
    @RequestMapping(value = "/refPubFinereportPtintconfigData", method = RequestMethod.GET)
    @ResponseBody
    public CommonResponse<IPage<PubFinereportPtintconfigVO>> refPubFinereportPtintconfigData(@RequestParam Integer pageNumber, @RequestParam Integer pageSize,
                                                                        String condition,
                                                                        String searchObject,
                                                                        String searchText) {
        QueryParam param = new QueryParam();
        param.setPageSize(pageSize);
        param.setPageIndex(pageNumber);
        param.setSearchText(searchText);
        param.setSearchObject(searchObject);
        /** 租户隔离 */
        param.getParams().put("tenantId", new Parameter(QueryParam.EQ, InvocationInfoProxy.getTenantid()));
        if(StringUtils.isNotEmpty(condition)){
            /** 处理condition */
            JSONObject _con = JSONObject.parseObject(condition);
        }

        IPage<PubFinereportPtintconfigEntity> page = service.queryPage(param,false);
        IPage<PubFinereportPtintconfigVO> pageData = new Page<>(page.getCurrent(), page.getSize(), page.getTotal());
        pageData.setRecords(BeanMapper.mapList(page.getRecords(), PubFinereportPtintconfigVO.class));

        return CommonResponse.success("查询参照数据成功！",pageData);
     }


    /**
     * 获取帆软报表配置模板信息
     * 获取模板对应的url
     *
     * 如果多条业务数据对应几个模板，分组，合并。参数归类
     * @param params
     * @return
     */
    @RequestMapping(value ="/getFineReportUrl", method = RequestMethod.POST)
    @ResponseBody
//    @ApiOperation(value = "信息列表")
    public CommonResponse<List<Map<String, Object>>> getFineReportUrl(@RequestBody(required = false) Map<String, Object> params) {
        CommonResponse<List<Map<String, Object>>> tPage = service.getFineReportUrl(params);
        //bean转换
        return tPage;
    }

    /**
     * 获取帆软报表配置模板信息
     * 获取模板对应的url
     *
     * 如果多条业务数据对应几个模板，分组，合并。参数归类
     * @param params
     * @return
     */
    @RequestMapping(value ="/getBatchFineReportUrl", method = RequestMethod.POST)
    @ResponseBody
//    @ApiOperation(value = "信息列表")
    public CommonResponse<List<Map<String, Object>>> getBatchFineReportUrl(@RequestBody(required = false) Map<String, Object> params) {
        CommonResponse<List<Map<String, Object>>> tPage = service.getBatchFineReportUrl(params);
        //bean转换
        return tPage;
    }

    /**
     * 获取帆软报表配置模板信息
     * 获取模板对应的url
     *
     * 如果多条业务数据对应几个模板，分组，合并。参数归类
     * @param params
     * @return
     */
    @RequestMapping(value ="/preFineReportUrl", method = RequestMethod.POST)
    @ResponseBody
//    @ApiOperation(value = "信息列表")
    public CommonResponse<List<Map<String, Object>>> preFineReportUrl(@RequestBody(required = false) Map<String, Object> params) {
        CommonResponse<List<Map<String, Object>>> tPage = service.getFineReportUrl(params);
        //bean转换
        return tPage;
    }



}
