package com.ejianc.business.ztpczr.controller;

import com.ejianc.basem.service.IIdeModuleService;
import com.ejianc.basem.vo.ButtonInfoRequestVO;
import com.ejianc.basem.vo.ButtonInfoVO;
import com.ejianc.business.ztpczr.service.IAttachmentService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;

/**
 * PRT
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("buttonController")
public class ButtonController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IAttachmentService service;

    @Autowired
    private SessionManager sessionManager;



    @Autowired
    private IIdeModuleService iIdeModuleService;

    /**
     * @Description
     */
    @RequestMapping(value = "/queryButtonAuthList", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<List<ButtonInfoVO>> queryButtonAuthList(@RequestBody ButtonInfoRequestVO buttonInfoRequestVO) {
        List<ButtonInfoVO> buttonAuthList = iIdeModuleService.getButtonAuthList(buttonInfoRequestVO.getBizId(), buttonInfoRequestVO.getAppId(), buttonInfoRequestVO.getCode());
        return CommonResponse.success(buttonAuthList);
    }



}
