package com.ejianc.business.ztpczr.controller;

import com.ejianc.business.ztpczr.bean.DcFileTypeQuery;
import com.ejianc.business.ztpczr.bean.SystemEntity;
import com.ejianc.business.ztpczr.bean.SystemRtEntity;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.service.ISystemService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * CVAR
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("/api/pubVarConfig")
public class RefController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISystemService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private DiscoveryClient discoveryClient;

    /**
     * 简版新参照
     * @param tableName
     * @return
     */
    @GetMapping(value = "/queryListByAttributeTbKey")
    public CommonResponse<Map<Object,Map>> queryListByAttributeTbKey(@RequestParam(value = "tableName")  String tableName,@RequestParam(value = "keyType")  String keyType) {

        ServletRequestAttributes requestAttributes = ServletRequestAttributes.class.
                cast(RequestContextHolder.getRequestAttributes());
        HttpServletRequest contextRequest = requestAttributes.getRequest();

        logger.info("request1->信息为:"+contextRequest.getRemoteHost());
        logger.info("request2->信息为:"+contextRequest.getRemoteUser());
        logger.info("request3->信息为:"+contextRequest.getRemoteAddr());
        Enumeration<String> headerNames = contextRequest.getHeaderNames();
        StringBuilder header = new StringBuilder();
        while(headerNames.hasMoreElements()) {
            String headName = headerNames.nextElement();
            String headerValue = contextRequest.getHeader(headName);
            header.append(headName+headerValue+";");
        }
        logger.info("request4->信息为:"+header);
        String remoteAddr = contextRequest.getRemoteAddr();
        if (ToolUtil.isNotEmpty(remoteAddr)){
            remoteAddr = remoteAddr.replaceAll("/", "");
            List<String> serviceNames = discoveryClient.getServices();
            for (String serviceName : serviceNames) {
                List<ServiceInstance> sis = discoveryClient.getInstances(serviceName);
                for (int i = 0; i < sis.size(); i++) {
                    ServiceInstance serviceInstance =  sis.get(i);
                    if (remoteAddr.equals(serviceInstance.getHost())) {
                        logger.info("requestN->信息为:匹配到注册中心=============="+serviceInstance.getServiceId()+"=>"+serviceInstance.getHost()+"目标来源host为"+remoteAddr);
                    }else {
                        logger.info("requestN->信息为:未匹配到注册中心"+serviceInstance.getServiceId()+"=>"+serviceInstance.getHost()+"目标来源host为"+remoteAddr);
                    }
                }
            }
        }





        List<SystemEntity> systemEntities = service.selectByTableName(tableName);

        if (systemEntities == null||systemEntities.size() != 3){
            return CommonResponse.success("该表没有设置参照！tableName:"+tableName);
        }

        List<SystemRtEntity> systemRtEntityList = service.selectByCode(systemEntities);

        Map<Object,Map> filterEntityList = new HashMap<>();

        systemRtEntityList.stream().forEach(e -> {
            Map entityMap = new HashMap();
            entityMap.put("code", e.getCode());
            entityMap.put("name", e.getName());
            entityMap.put("id", e.getId());
            Object key = e.getId();
            if ("code".equals(keyType)){
                key = e.getCode();
            }else if ("name".equals(keyType)){
                key = e.getName();
            }
            filterEntityList.put(key,entityMap);
        });
        return CommonResponse.success("查询列表数据成功！", filterEntityList);
    }

    /**
     * 简版新参照
     * @param tableName
     * @return
     */
    @GetMapping(value = "/queryListByAttributeTb")
    public CommonResponse<Map<String,List<Map>>> queryListByAttributeTb(@RequestParam(value = "tableName")  String tableName) {

        ServletRequestAttributes requestAttributes = ServletRequestAttributes.class.
                cast(RequestContextHolder.getRequestAttributes());
        HttpServletRequest contextRequest = requestAttributes.getRequest();
        logger.info("request信息为:"+contextRequest.toString());
        List<SystemEntity> systemEntities = service.selectByTableName(tableName);

        if (systemEntities == null||systemEntities.size() != 3){
            return CommonResponse.success("该表没有设置参照！tableName:"+tableName);
        }

        List<SystemRtEntity> systemRtEntityList = service.selectByCode(systemEntities);

        List<Map> filterEntityList = new ArrayList<>();

        systemRtEntityList.stream().forEach(e -> {
            Map entityMap = new HashMap();
            entityMap.put("code", e.getCode());
            entityMap.put("name", e.getName());
            entityMap.put("id", e.getId());
            filterEntityList.add(entityMap);
        });



        //业务需要 包装对象
        Map data = new HashMap<>();

        data.put("data",filterEntityList);

        return CommonResponse.success("查询列表数据成功！", data);
    }



}
