package com.ejianc.basem.utils;

import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

import static com.ejianc.basem.consts.ZtpcConsts.REF;

/**
 * @Classname CkUtil
 * @Description TODO
 * @Date 2023/6/7 10:36
 * @Created by lijunxue
 */
public class CkUtil {
    public static CommonResponse getCommonResponse(DiscoveryClient discoveryClient, Logger logger, ServletRequestAttributes requestAttributes) {

        HttpServletRequest contextRequest = requestAttributes.getRequest();
        String remoteAddr = contextRequest.getRemoteAddr();

        if (ToolUtil.isNotEmpty(remoteAddr)){
            remoteAddr = remoteAddr.replaceAll("/", "");
            List<String> serviceNames = discoveryClient.getServices();
            for (String serviceName : serviceNames) {
                List<ServiceInstance> sis = discoveryClient.getInstances(serviceName);
                for (int i = 0; i < sis.size(); i++) {
                    ServiceInstance serviceInstance =  sis.get(i);
                    if (remoteAddr.equals(serviceInstance.getHost())) {
                        if (!serviceName.startsWith(REF)){
                            return CommonResponse.error("网络错误。");
                        }
                        logger.debug("requestN->信息为:匹配到注册中心=============="+serviceInstance.getServiceId()+"=>"+serviceInstance.getHost()+"目标来源host为"+ remoteAddr);
                    }else {
                        logger.debug("requestN->信息为:未匹配到注册中心"+serviceInstance.getServiceId()+"=>"+serviceInstance.getHost()+"目标来源host为"+ remoteAddr);
                    }
                }
            }
        }
        return null;
    }
}
