package com.ejianc.basem.utils;

import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.util.List;

import static com.ejianc.basem.consts.ZtpcConsts.REF;

/**
 * @Classname CkUtil
 * @Description TODO
 * @Date 2023/6/7 10:36
 * @Created by lijunxue
 */
public class CkUtil {
    public static CommonResponse getCommonResponse(DiscoveryClient discoveryClient, Logger logger, ServletRequestAttributes requestAttributes) {
        HttpServletRequest contextRequest = requestAttributes.getRequest();
        String remoteAddr = contextRequest.getRemoteAddr();
        if (ToolUtil.isNotEmpty(remoteAddr)){
            remoteAddr = remoteAddr.replaceAll("/", "");
            List<String> serviceNames = discoveryClient.getServices();
            for (String serviceName : serviceNames) {
                List<ServiceInstance> sis = discoveryClient.getInstances(serviceName);
                for (int i = 0; i < sis.size(); i++) {
                    ServiceInstance serviceInstance =  sis.get(i);
                    if (remoteAddr.equals(serviceInstance.getHost())) {
                        if (!serviceName.toUpperCase().contains(REF)){
                            // 未连接到网络
                            return CommonResponse.error("网络问题，查询失败。");
                        }
                    }
                }
            }
        }
        return null;
    }
}
