package com.ejianc.business.ztpczr.controller;

import com.ejianc.business.ztpczr.bean.DcFileTypeQuery;
import com.ejianc.business.ztpczr.bean.RefProjectPoolEntity;
import com.ejianc.business.ztpczr.bean.SystemEntity;
import com.ejianc.business.ztpczr.bean.SystemRtEntity;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.service.ISystemService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.ServiceInstance;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

import static com.ejianc.basem.consts.ZtpcConsts.REF;
import static com.ejianc.basem.utils.CkUtil.getCommonResponse;

/**
 * CVAR
 *
 * @author generator
 *
 */
@RestController
@RequestMapping("/api/pubVarConfig")
public class RefController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISystemService service;

    @Autowired
    private SessionManager sessionManager;

    @Autowired
    private DiscoveryClient discoveryClient;


    /**
     * 简版新参照
     * @param tableName
     * @return
     */
    @GetMapping(value = "/queryListByAttributeTbKey")
    public CommonResponse<Map<Object,Map>> queryListByAttributeTbKey(@RequestParam(value = "tableName")  String tableName,@RequestParam(value = "keyType")  String keyType) {
        CommonResponse commonResponse = getCommonResponse(discoveryClient, logger, ServletRequestAttributes.class.
                cast(RequestContextHolder.getRequestAttributes()));
        if (ToolUtil.isNotEmpty(commonResponse)){
            return commonResponse;
        }
        List<SystemEntity> systemEntities = service.selectByTableName(tableName);
        if (systemEntities == null||systemEntities.size() != 3){
            return CommonResponse.error("该表没有设置参照！tableName:"+tableName);
        }
        List<SystemRtEntity> systemRtEntityList = service.selectByCode(systemEntities);
        Map<Object,Map> filterEntityList = new HashMap<>();
        systemRtEntityList.stream().forEach(e -> {
            Map entityMap = new HashMap();
            entityMap.put("code", e.getCode());
            entityMap.put("name", e.getName());
            entityMap.put("id", e.getId());
            Object key = e.getId();
            if ("code".equals(keyType)){
                key = e.getCode();
            }else if ("name".equals(keyType)){
                key = e.getName();
            }
            filterEntityList.put(key,entityMap);
        });
        return CommonResponse.success("查询列表数据成功！", filterEntityList);
    }


    /**
     * 简版新参照
     * @param
     * @return
     */
    @GetMapping(value = "/refProjectPool")
    public CommonResponse<Map<String,Map<String,String>>> refProjectPool() {
        CommonResponse commonResponse = getCommonResponse(discoveryClient, logger, ServletRequestAttributes.class.
                cast(RequestContextHolder.getRequestAttributes()));
        if (ToolUtil.isNotEmpty(commonResponse)){
            return commonResponse;
        }
        List<RefProjectPoolEntity> refProjectPoolEntities = service.refProjectPool();
        if (refProjectPoolEntities.size()>50000){
            logger.error("RefProjectPool is too many entities"+refProjectPoolEntities.size());
        }
        Map<String,Map<String,String>> entityMap = new HashMap<String,Map<String,String>>();
        refProjectPoolEntities.stream().forEach(e->{
            Map<String,String> map = new HashMap<>();

            map.put("projectId", String.valueOf(e.getProjectId()));
            map.put("projectCode", e.getProjectCode());
            map.put("projectName", e.getProjectName());

            map.put("orgId", String.valueOf(e.getOrgId()));
            map.put("orgCode", e.getOrgCode());
            map.put("orgName", e.getOrgName());

            map.put("parentOrgId", String.valueOf(e.getParentOrgId()));
            map.put("parentOrgCode", e.getParentOrgCode());
            map.put("parentOrgName", e.getParentOrgName());
            entityMap.put(String.valueOf(e.getProjectId()),map);

        });

        return CommonResponse.success("查询列表数据成功！", entityMap);
    }



    /**
     * 简版新参照
     * @param tableName
     * @return
     */
    @GetMapping(value = "/queryListByAttributeTb")
    public CommonResponse<Map<String,List<Map>>> queryListByAttributeTb(@RequestParam(value = "tableName")  String tableName) {

        ServletRequestAttributes requestAttributes = ServletRequestAttributes.class.
                cast(RequestContextHolder.getRequestAttributes());
        HttpServletRequest contextRequest = requestAttributes.getRequest();
        logger.info("request信息为:"+contextRequest.toString());
        List<SystemEntity> systemEntities = service.selectByTableName(tableName);

        if (systemEntities == null||systemEntities.size() != 3){
            return CommonResponse.success("该表没有设置参照！tableName:"+tableName);
        }

        List<SystemRtEntity> systemRtEntityList = service.selectByCode(systemEntities);

        List<Map> filterEntityList = new ArrayList<>();

        systemRtEntityList.stream().forEach(e -> {
            Map entityMap = new HashMap();
            entityMap.put("code", e.getCode());
            entityMap.put("name", e.getName());
            entityMap.put("id", e.getId());
            filterEntityList.add(entityMap);
        });



        //业务需要 包装对象
        Map data = new HashMap<>();

        data.put("data",filterEntityList);

        return CommonResponse.success("查询列表数据成功！", data);
    }



}
