package com.ejianc.business.ztpczr.controller;

import com.ejianc.business.ztpczr.bean.DcFileTypeQuery;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.service.ISystemService;
import com.ejianc.business.ztpczr.bean.SystemEntity;
import com.ejianc.business.ztpczr.bean.SystemRtEntity;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import com.ejianc.framework.core.response.QueryParam;
import com.ejianc.framework.core.util.ResultAsTree;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

import javax.servlet.http.HttpServletRequest;
import java.io.Serializable;
import java.util.*;
import java.util.stream.Collectors;

/**
 * CVAR
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("pubVarConfig")
public class SystemController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private ISystemService service;

    @Autowired
    private SessionManager sessionManager;


    /**
     * 异步树----文件类型
     *
     * @param condition
     * @param searchText
     * @return
     */
    @RequestMapping(value = "/dcFileTypeQueryTree", method = RequestMethod.GET)
    @ResponseBody
    public List<Map<String, Object>> dcFileTypeQueryTree(@RequestParam(required=false) String condition,
                                                              @RequestParam(required=false) Long pid,
                                                         @RequestParam(required = false) String searchText) {

        Map<String,Object> params = new HashMap<>();
        params.put("belongOrgId",sessionManager.getUserContext().getOrgId());
        if (ToolUtil.isEmpty(pid)){
            params.put("pid",1474197986685751299L);
        } else {
            params.put("pid",pid);
        }
        List<Long> inIds = null;
        List<Long> notInIds = null;
        if (ToolUtil.isNotEmpty(condition)){
            if (condition.startsWith("inIds")){
                String substring = condition.substring("inIds".length());
                inIds = getIds(substring);
            }
            if (condition.startsWith("notInIds")){
                String substring = condition.substring("notInIds".length());
                notInIds = getIds(substring);
            }
        }
        params.put("inIds",inIds);
        params.put("notInIds",notInIds);
        List<DcFileTypeQuery> dataList = service.dcFileTypeQuery(params);
        List<Map> map = BeanMapper.mapList(dataList, Map.class);
        return ResultAsTree.createTreeData(map);

    }


    public static List<Long> getIds(String ids){
        if (ToolUtil.isEmpty(ids)){
            return null;
        }else {
            List<Long> collect = Arrays.stream(ids.split(",")).map(Long::parseLong).collect(Collectors.toList());
            return collect;
        }
    }


}
