package com.ejianc.basem.service.impl;

import com.alibaba.fastjson.JSONArray;
import com.alibaba.fastjson.JSONObject;
import com.beust.jcommander.internal.Lists;
import com.ejianc.basem.bean.ActRuTaskPo;
import com.ejianc.basem.vo.ButtonInfoVO;
import com.ejianc.basem.bean.IdeModulePo;
import com.ejianc.basem.mapper.IdeModuleMapper;
import com.ejianc.basem.service.IIdeModuleService;
import com.ejianc.basem.utils.ToolUtil;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import org.apache.poi.ss.formula.functions.T;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

import java.util.ArrayList;
import java.util.List;
import java.util.stream.Collectors;

/**
 * @Classname ActRuExecutionService
 * @Description TODO
 * @Date 2023/4/27 15:33
 * @Created by lijunxue
 */
@Service("ideModuleService")
public class IdeModuleService implements IIdeModuleService {

    @Autowired
    private IdeModuleMapper ideModuleMapper;


    @Autowired
    private ActRuTaskService actRuTaskService;

    /**
     * 按钮信息处理
     *
     * @return
     */
    @Override
    public List<ButtonInfoVO> getButtonAuthList(String bizId, String appId, String code) {
        List<ButtonInfoVO> buttonAuthList = Lists.newArrayList();
        List<IdeModulePo> ideModulePoList = ideModuleMapper.selectMyPageInfo(appId, code);
        if (ToolUtil.isNotEmpty(ideModulePoList) && ideModulePoList.size() == 1) {
            List<ActRuTaskPo> actRuTaskPoList = actRuTaskService.getActRuTaskPo(bizId);
            if (ToolUtil.isEmpty(actRuTaskPoList)) {
                throw new RuntimeException("当前未有审批流程，无按钮权限");
            }
            actRuTaskPoList = actRuTaskPoList.stream().filter(a -> a.getAssignee().equals(String.valueOf(InvocationInfoProxy.getUserid()))).collect(Collectors.toList());
            if (ToolUtil.isEmpty(actRuTaskPoList)) {
                throw new RuntimeException("当前未有审批流程，无按钮权限");
            }
            String description = actRuTaskPoList.get(0).getDescription();
            IdeModulePo ideModulePo = ideModulePoList.get(0);
            String data = ideModulePo.getData();
            JSONObject root = JSONObject.parseObject(data);
            // 递归设置按钮权限
            return recursionSetButtonAuth(root, description, buttonAuthList);
        } else {
            // 有多个说明 可能出现不同的情况
            return buttonAuthList;
        }
    }

    /**
     * 递归设置按钮权限
     *
     * @param root           页面控件JSON
     * @param description    审批节点说明
     * @param buttonAuthList 按钮权限集合
     * @return 按钮权限集合
     */
    private List<ButtonInfoVO> recursionSetButtonAuth(JSONObject root, String description, List<ButtonInfoVO> buttonAuthList) {
        JSONArray children = root.getJSONArray("children");
        for (Object child : children) {
            JSONObject objSub = (JSONObject) child;
            if ("EJCButton".equals(objSub.get("uitype")) || "EJCReferButton".equals(objSub.get("uitype"))) {
                String enTitle = objSub.getString("enTitle");
                String uikey = objSub.getString("uikey");
                if (("auth_" + description).equals(enTitle)) {
                    ButtonInfoVO buttonAuthVO = new ButtonInfoVO();
                    buttonAuthVO.setButtonCode(uikey);
                    buttonAuthVO.setShowAble("Y");
                    buttonAuthList.add(buttonAuthVO);
                }
            }
            if (ToolUtil.isEmpty(objSub.get("children")) || !"[".equals(objSub.get("children").toString().substring(0, 1)) || ToolUtil.isEmpty(objSub.getJSONArray("children"))) {
                continue;
            }
            recursionSetButtonAuth(objSub, description, buttonAuthList);
        }
        return buttonAuthList;
    }


}
