package com.ejianc.business.ztpczr.controller;

import com.ejianc.business.ztpczr.bean.AttachmentEntity;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.service.IAttachmentService;
import com.ejianc.business.ztpczr.vo.AttachmentVO;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.kit.mapper.BeanMapper;
import com.ejianc.framework.core.response.CommonResponse;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Controller;
import org.springframework.web.bind.annotation.*;

import java.io.Serializable;
import java.util.List;
import java.util.Map;

/**
 * PRT
 *
 * @author generator
 *
 */
@Controller
@RequestMapping("attachment")
public class AttachmentController implements Serializable {
	private static final long serialVersionUID = 1L;

    private Logger logger = LoggerFactory.getLogger(this.getClass());

    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;

    private static final String BILL_CODE = "Invoice_Open_Apply_Code";//此处需要根据实际修改

    @Autowired
    private IAttachmentService service;

    @Autowired
    private SessionManager sessionManager;

    /**
     * @Description saveOrUpdate 新增或者修改
     */
    @RequestMapping(value = "/queryFileIdBySourceId", method = RequestMethod.POST)
    @ResponseBody
    public CommonResponse<AttachmentVO> queryFileIdBySourceId(@RequestBody Map query) {


        List<AttachmentEntity> records = service.getFileId(query);

        if (ToolUtil.isNotEmpty(records)&&records.size()==1){
            return CommonResponse.success("请求成功",BeanMapper.map(records.get(0), AttachmentVO.class));
        } else {
            return CommonResponse.success("wps遇到了未知错误，请联系平台管理员 提示文件过多或为None");
        }
    }

}
