/*
 * Decompiled with CFR 0.152.
 */
package com.ejianc.business.ztpczr.controller;

import com.ejianc.basem.utils.CkUtil;
import com.ejianc.business.ztpczr.bean.RefProjectPoolEntity;
import com.ejianc.business.ztpczr.cores.utils.ToolUtil;
import com.ejianc.business.ztpczr.service.ISystemService;
import com.ejianc.foundation.orgcenter.api.IOrgApi;
import com.ejianc.foundation.support.api.IBillCodeApi;
import com.ejianc.foundation.support.api.IBillTypeApi;
import com.ejianc.framework.auth.session.SessionManager;
import com.ejianc.framework.core.response.CommonResponse;
import java.io.Serializable;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.cloud.client.discovery.DiscoveryClient;
import org.springframework.web.bind.annotation.GetMapping;
import org.springframework.web.bind.annotation.RequestMapping;
import org.springframework.web.bind.annotation.RestController;
import org.springframework.web.context.request.RequestContextHolder;
import org.springframework.web.context.request.ServletRequestAttributes;

@RestController
@RequestMapping(value={"/api/pubVarConfig"})
public class RefController
implements Serializable {
    private static final long serialVersionUID = 1L;
    private Logger logger = LoggerFactory.getLogger(this.getClass());
    @Autowired
    private IBillTypeApi billTypeApi;
    @Autowired
    private IBillCodeApi billCodeApi;
    @Autowired
    private IOrgApi iOrgApi;
    private static final String BILL_CODE = "Invoice_Open_Apply_Code";
    @Autowired
    private ISystemService service;
    @Autowired
    private SessionManager sessionManager;
    @Autowired
    private DiscoveryClient discoveryClient;

    @GetMapping(value={"/refProjectPool"})
    public CommonResponse<Map<String, Map<String, String>>> refProjectPool() {
        CommonResponse commonResponse = CkUtil.getCommonResponse(this.discoveryClient, this.logger, (ServletRequestAttributes)ServletRequestAttributes.class.cast(RequestContextHolder.getRequestAttributes()));
        if (ToolUtil.isNotEmpty(commonResponse)) {
            return commonResponse;
        }
        List<RefProjectPoolEntity> refProjectPoolEntities = this.service.refProjectPool();
        if (refProjectPoolEntities.size() > 50000) {
            this.logger.error("RefProjectPool is too many entities" + refProjectPoolEntities.size());
        }
        HashMap entityMap = new HashMap();
        refProjectPoolEntities.stream().forEach(e -> {
            HashMap<String, String> map = new HashMap<String, String>();
            map.put("projectId", String.valueOf(e.getProjectId()));
            map.put("projectCode", e.getProjectCode());
            map.put("projectName", e.getProjectName());
            map.put("orgId", String.valueOf(e.getOrgId()));
            map.put("orgCode", e.getOrgCode());
            map.put("orgName", e.getOrgName());
            map.put("parentOrgId", String.valueOf(e.getParentOrgId()));
            map.put("parentOrgCode", e.getParentOrgCode());
            map.put("parentOrgName", e.getParentOrgName());
            entityMap.put(String.valueOf(e.getProjectId()), map);
        });
        return CommonResponse.success((String)"\u67e5\u8be2\u5217\u8868\u6570\u636e\u6210\u529f\uff01", entityMap);
    }
}

