package com.ejianc.business.ztpczr.service.impl;

import com.ejianc.basem.utils.ToolUtil;
import com.ejianc.business.ztpczr.jwt.RsaKeyHelper;
import com.ejianc.business.ztpczr.service.JwtService;
import com.ejianc.foundation.orgcenter.api.IUserApi;
import com.ejianc.foundation.usercenter.vo.UserVO;
import com.ejianc.framework.core.context.InvocationInfoProxy;
import com.ejianc.framework.core.response.CommonResponse;
import io.jsonwebtoken.Jwts;
import io.jsonwebtoken.SignatureAlgorithm;
import org.joda.time.DateTime;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Service;

@Service
public class JwtServiceImpl implements JwtService {

    @Autowired
    private IUserApi userApi;

    private static RsaKeyHelper rsaKeyHelper = new RsaKeyHelper();
    @Override
    public String generateToken() throws Exception {
        Long userid = InvocationInfoProxy.getUserid();
        CommonResponse<UserVO> userByUserId = userApi.findUserByUserId(userid);
        if (ToolUtil.isNotEmpty(userByUserId.getData())&&userByUserId.isSuccess()){
            String compactJws = Jwts.builder()
                    .setSubject(userByUserId.getData().getUserCode())
                    .claim("cz", "cczz")
                    .claim("jobNumber", userByUserId.getData().getUserCode())
                    .claim("phone", userByUserId.getData().getUserMobile())
                    .claim("timestamp",System.currentTimeMillis())
                    .setExpiration(DateTime.now().plusSeconds(180).toDate())
                    .signWith(SignatureAlgorithm.RS256, rsaKeyHelper.getPrivateKey("xxOO1LJX12LJX^%3^(LJX5"))
                    .compact();
            return compactJws;
        }
        throw new Exception("用户信息查找不到");
    }
}
